/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.atlassian.crucible.fisheye.CrucibleReindexMessage;
import com.cenqua.crucible.hibernate.EmptyHibernateListener;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.type.Type;

public class AuditListener
extends EmptyHibernateListener {
    private Session session;
    private final Set<String> repnames = new HashSet<String>();
    private final Map<Review, Set<CrucibleRevision>> changedRevisions = new LinkedHashMap<Review, Set<CrucibleRevision>>();

    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public void onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        if (entity instanceof FRXRevision) {
            FRXRevision r2 = (FRXRevision)entity;
            this.frxRevisionChanged(r2);
        }
        if (entity instanceof FileRevisionExtraInfo) {
            FileRevisionExtraInfo frx = (FileRevisionExtraInfo)entity;
            this.frxChanged(frx);
        }
        if (entity instanceof Review) {
            Review review = (Review)entity;
            this.reviewChanged(review, currentState, previousState, propertyNames);
        }
    }

    @Override
    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (entity instanceof FRXRevision) {
            FRXRevision r2 = (FRXRevision)entity;
            this.frxRevisionChanged(r2);
        }
        if (entity instanceof FileRevisionExtraInfo) {
            FileRevisionExtraInfo frx = (FileRevisionExtraInfo)entity;
            this.frxChanged(frx);
        }
    }

    @Override
    public void onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (entity instanceof FRXRevision) {
            FRXRevision r2 = (FRXRevision)entity;
            this.frxRevisionChanged(r2);
        }
        if (entity instanceof FileRevisionExtraInfo) {
            FileRevisionExtraInfo frx = (FileRevisionExtraInfo)entity;
            this.frxChanged(frx);
        }
    }

    @Override
    public void afterTransactionCommit(Transaction transaction) {
        if (this.repnames.isEmpty()) {
            return;
        }
        RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
        for (String repname : this.repnames) {
            RepositoryHandle rh = rm.getRepository(repname);
            if (rh == null) {
                Logs.APP_LOG.warn((Object)("could not find repository " + repname));
                continue;
            }
            Logs.APP_LOG.debug((Object)("Requesting Crucible scan for " + rh.getName()));
            try {
                rh.requestCrucibleIncrementalScan();
            }
            catch (RepositoryHandle.StateException e2) {
                Logs.APP_LOG.warn((Object)"Crucible scan was not run as the repository was no longer running");
            }
        }
        this.clear();
    }

    @Override
    public void afterTransactionRollback(Transaction tx) {
        this.clear();
    }

    private void clear() {
        this.repnames.clear();
        this.changedRevisions.clear();
    }

    private void reviewChanged(Review review, Object[] currentState, Object[] previousState, String[] propertyNames) {
        for (int i2 = 0; i2 < propertyNames.length; ++i2) {
            String prevState;
            String prop = propertyNames[i2];
            if (!"stateName".equals(prop)) continue;
            String newState = (String)currentState[i2];
            String string = prevState = previousState == null ? null : (String)previousState[i2];
            if (ObjectUtils.equals((Object)newState, (Object)prevState)) continue;
            this.reviewStateChanged(review);
        }
    }

    private void frxRevisionChanged(FRXRevision rev) {
        FileRevisionExtraInfo frx = rev.getFrx();
        if (frx == null) {
            Logs.APP_LOG.warn((Object)"FRXRevision has null frx");
            return;
        }
        Review review = frx.getReview();
        if (review == null) {
            Logs.APP_LOG.warn((Object)"FRXRevision has frx with null review");
            return;
        }
        this.updatedRevision(review, rev.getRevision());
    }

    private void frxChanged(FileRevisionExtraInfo frx) {
        Review review = frx.getReview();
        this.updatedFrx(review, frx);
    }

    private void reviewStateChanged(Review review) {
        for (FileRevisionExtraInfo frx : review.getFrxs()) {
            this.updatedFrx(review, frx);
        }
    }

    private void updatedFrx(Review review, FileRevisionExtraInfo frx) {
        if (frx == null) {
            Logs.APP_LOG.warn((Object)"FRX has null frx");
            return;
        }
        if (review == null) {
            Logs.APP_LOG.warn((Object)"FRX has null review");
            return;
        }
        for (FRXRevision frxRevision : frx.getFrxRevisions()) {
            CrucibleRevision fr = frxRevision.getRevision();
            this.updatedRevision(review, fr);
        }
    }

    private void updatedRevision(Review review, CrucibleRevision fr) {
        if (fr == null) {
            Logs.APP_LOG.warn((Object)"frx contains a null revision");
            return;
        }
        String sourceName = fr.getSourceName();
        RepositoryHandle r2 = AppConfig.getsConfig().getRepositoryManager().getRepository(sourceName);
        if (r2 == null) {
            return;
        }
        Set<CrucibleRevision> alreadySeen = this.changedRevisions.get(review);
        if (alreadySeen == null) {
            alreadySeen = new HashSet<CrucibleRevision>();
            this.changedRevisions.put(review, alreadySeen);
        }
        if (alreadySeen.contains(fr)) {
            return;
        }
        alreadySeen.add(fr);
        if (Logs.APP_LOG.isDebugEnabled()) {
            Logs.APP_LOG.debug((Object)("log fr update " + review.getPermaId() + " " + sourceName + " " + fr.getPath() + " " + fr.getRevision()));
        }
        this.repnames.add(sourceName);
        CrucibleReindexMessage update = new CrucibleReindexMessage();
        update.setReviewId(review.getId());
        update.setFileRevision(fr);
        this.session.save((Object)update);
    }
}

