/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible;

import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.logging.Logs;

public final class CrucibleSysProps {
    private static final String CRUCIBLE_PROP_PREFIX = "crucible.";
    public static final String TRACK_SESSIONS_PROP = "crucible.track.sessions";
    public static final String DETECT_METADATA_REVISION_CHANGES_PROP = "crucible.detect.metadata.revision.changes";
    public static final String DEBUG_NOTIFICATION_EMAILS_PROP = "crucible.debug.notification.emails";
    public static final String REVIEW_CONTENT_SIZE_LIMIT_PROP = "crucible.review.content.size.limit";
    public static final String SQL_IN_CLAUSE_SIZE_LIMIT_PROP = "crucible.sql.inclause.limit";
    public static final String USERS_PER_GROUP_IN_REVIEW_LIMIT_PROP = "crucible.users.per.group.in.review";
    public static final String BRANCH_REVIEW_COMMIT_TRAVERSAL_LIMIT_PROP = "crucible.review.branch.changeset.limit";
    public static boolean DETECT_METADATA_REVISION_CHANGES = false;
    public static boolean TRACK_SESSIONS = false;
    public static boolean DEBUG_NOTIFICATION_EMAILS = false;
    public static int REVIEW_CONTENT_SIZE_LIMIT = 800;
    public static int SQL_IN_CLAUSE_SIZE_LIMIT = 100;
    public static int USERS_PER_GROUP_IN_REVIEW_LIMIT = 10;
    public static int BRANCH_REVIEW_COMMIT_TRAVERSAL_LIMIT = 5000;

    public static void reloadProperties() {
        TRACK_SESSIONS = Boolean.valueOf(System.getProperty(TRACK_SESSIONS_PROP, String.valueOf(TRACK_SESSIONS)));
        DETECT_METADATA_REVISION_CHANGES = Boolean.valueOf(System.getProperty(DETECT_METADATA_REVISION_CHANGES_PROP, String.valueOf(DETECT_METADATA_REVISION_CHANGES)));
        DEBUG_NOTIFICATION_EMAILS = Boolean.valueOf(System.getProperty(DEBUG_NOTIFICATION_EMAILS_PROP, String.valueOf(DEBUG_NOTIFICATION_EMAILS)));
        SQL_IN_CLAUSE_SIZE_LIMIT = FishEyeSysProps.loadIntProperty(SQL_IN_CLAUSE_SIZE_LIMIT_PROP, 5, 10000, SQL_IN_CLAUSE_SIZE_LIMIT);
        CrucibleSysProps.reloadContentSizeLimit();
        USERS_PER_GROUP_IN_REVIEW_LIMIT = FishEyeSysProps.loadIntProperty(USERS_PER_GROUP_IN_REVIEW_LIMIT_PROP, 10);
        BRANCH_REVIEW_COMMIT_TRAVERSAL_LIMIT = FishEyeSysProps.loadIntProperty(BRANCH_REVIEW_COMMIT_TRAVERSAL_LIMIT_PROP, BRANCH_REVIEW_COMMIT_TRAVERSAL_LIMIT);
    }

    private static void reloadContentSizeLimit() {
        Integer newLimit = Integer.getInteger(REVIEW_CONTENT_SIZE_LIMIT_PROP, REVIEW_CONTENT_SIZE_LIMIT);
        if (newLimit > 0) {
            REVIEW_CONTENT_SIZE_LIMIT = newLimit;
        } else {
            Logs.APP_LOG.warn((Object)("Invalid review content size limit specified, ignoring value of: " + newLimit));
        }
    }

    static {
        CrucibleSysProps.reloadProperties();
    }
}

