/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util;

import com.cenqua.fisheye.logging.Logs;
import it.unimi.dsi.fastutil.longs.Long2ObjectRBTreeMap;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class IndexingStats {
    private static final int TOP_SIZE = 20;
    private final Map<String, OperationStat> opStats = new HashMap<String, OperationStat>();
    private final SortedMap<Long, String> longestOperations = new Long2ObjectRBTreeMap();

    public void addOperation(String opName, String description, long duration) {
        this.getOperationStat(opName).addOperation(duration);
        if (this.longestOperations.size() < 20 || duration > this.longestOperations.firstKey()) {
            this.addLongOperation(duration, description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLongOperation(long duration, String description) {
        SortedMap<Long, String> sortedMap = this.longestOperations;
        synchronized (sortedMap) {
            if (this.longestOperations.size() < 20 || duration > this.longestOperations.firstKey()) {
                this.longestOperations.put(duration, description);
                if (this.longestOperations.size() > 20) {
                    this.longestOperations.remove(this.longestOperations.firstKey());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStat getOperationStat(String opname) {
        OperationStat opStat = this.opStats.get(opname);
        if (opStat == null) {
            Map<String, OperationStat> map = this.opStats;
            synchronized (map) {
                opStat = this.opStats.get(opname);
                if (opStat == null) {
                    opStat = new OperationStat();
                    this.opStats.put(opname, opStat);
                }
            }
        }
        return opStat;
    }

    public void addStats(IndexingStats stats) {
        for (Map.Entry<String, OperationStat> entry : stats.opStats.entrySet()) {
            this.getOperationStat(entry.getKey()).addStat(entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : stats.longestOperations.entrySet()) {
            this.addLongOperation((Long)entry.getKey(), (String)entry.getValue());
        }
        stats.clear();
    }

    public void clear() {
        this.opStats.clear();
        this.longestOperations.clear();
    }

    public void dump() {
        for (Map.Entry<String, OperationStat> entry : this.opStats.entrySet()) {
            OperationStat value = entry.getValue();
            Logs.APP_LOG.debug((Object)(entry.getKey() + " called " + value.numCalls + " times taking " + value.totalTimeMillis + " millis"));
        }
        Logs.APP_LOG.debug((Object)"Longest Operations:");
        for (Map.Entry<Object, Object> entry : this.longestOperations.entrySet()) {
            Logs.APP_LOG.debug((Object)((String)entry.getValue() + " took " + entry.getKey() + " millis"));
        }
    }

    private static class OperationStat {
        private AtomicInteger numCalls = new AtomicInteger(0);
        private AtomicLong totalTimeMillis = new AtomicLong(0L);

        private OperationStat() {
        }

        public void addOperation(long duration) {
            this.numCalls.incrementAndGet();
            this.totalTimeMillis.addAndGet(duration);
        }

        public void addStat(OperationStat stat) {
            this.numCalls.addAndGet(stat.numCalls.get());
            this.totalTimeMillis.addAndGet(stat.totalTimeMillis.get());
        }
    }
}

