/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.xwork;

import com.cenqua.fisheye.logging.Logs;
import com.opensymphony.xwork.ObjectFactory;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component(value="xworkObjectFactory")
public class SpringObjectFactory
extends ObjectFactory
implements ApplicationListener {
    private ApplicationContext context;

    public Object buildBean(Class aClass, Map extraContext) throws Exception {
        Method[] methods;
        if (aClass == null) {
            IllegalArgumentException e2 = new IllegalArgumentException("buildBean called with null class");
            Logs.APP_LOG.error((Object)"Null bean class", (Throwable)e2);
            throw e2;
        }
        Object bean = this.context.getAutowireCapableBeanFactory().createBean(aClass, 4, false);
        if (bean instanceof FactoryBean) {
            bean = ((FactoryBean)bean).getObject();
        }
        for (Method m2 : methods = bean.getClass().getMethods()) {
            if (!"afterPropertiesSet".equals(m2.getName())) continue;
            m2.invoke(bean, new Object[0]);
            break;
        }
        return bean;
    }

    public Object buildBean(String string, Map extraContext) throws Exception {
        return this.buildBean(this.getClassInstance(string), extraContext);
    }

    public void setContext(ApplicationContext context) {
        this.context = context;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            ContextRefreshedEvent cre = (ContextRefreshedEvent)event;
            if (this.context != null) {
                Logs.APP_LOG.warn((Object)"Spring context will be replaced - it may have unexpected side-effects");
            }
            this.setContext(cre.getApplicationContext());
            ObjectFactory.setObjectFactory((ObjectFactory)this);
        }
    }
}

