/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.xwork;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.interceptor.PreResultListener;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.XWorkConverter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SimpleConversionErrorInterceptor
implements Interceptor {
    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        ActionContext invocationContext = invocation.getInvocationContext();
        Map conversionErrors = invocationContext.getConversionErrors();
        final HashMap<String, String> filteredConversionErrors = new HashMap<String, String>();
        for (Map.Entry stringObjectEntry : conversionErrors.entrySet()) {
            String propertyName = (String)stringObjectEntry.getKey();
            String value = SimpleConversionErrorInterceptor.getStringValue(stringObjectEntry.getValue());
            if (!StringUtils.isNotBlank((String)value)) continue;
            filteredConversionErrors.put(propertyName, value);
            Object action = invocation.getAction();
            if (!(action instanceof ValidationAware)) continue;
            ValidationAware validationAware = (ValidationAware)action;
            String message = XWorkConverter.getConversionErrorMessage((String)propertyName, (OgnlValueStack)invocationContext.getValueStack());
            validationAware.addFieldError(propertyName, message);
        }
        invocation.addPreResultListener(new PreResultListener(){

            public void beforeResult(ActionInvocation invocation, String resultCode) {
                if (invocation.getStack() != null && invocation.getStack().getContext() != null) {
                    Map map = invocation.getStack().getContext();
                    map.putAll(filteredConversionErrors);
                }
            }
        });
        return invocation.invoke();
    }

    private static String getStringValue(Object o2) {
        if (o2 instanceof String[]) {
            String[] strings = (String[])o2;
            if (strings.length > 0) {
                return strings[0];
            }
            return null;
        }
        return (String)o2;
    }
}

