/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.web;

import com.atlassian.fisheye.web.SiteUrlBuilder;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.filters.TotalityFilter;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component(value="siteUrlBuilder")
@AvailableToPlugins
public class SimpleSiteUrlBuilder
implements SiteUrlBuilder {
    @Override
    public String getSiteUrl(HttpServletRequest req) {
        if (req == null && TotalityFilter.isInRequest()) {
            req = TotalityFilter.getRequest();
        }
        return req != null ? ServletUtils.getBaseUrl(req) : this.getConfiguredSiteURL();
    }

    @Override
    public String getSiteUrl() {
        return this.getSiteUrl(null);
    }

    @Override
    public String getConfiguredSiteURL() {
        return AppConfig.getsConfig().getSiteURL();
    }

    @Override
    public String getSiteContextPath(boolean fromRequest) {
        if (fromRequest && TotalityFilter.isInRequest()) {
            return TotalityFilter.getRequest().getContextPath();
        }
        return AppConfig.getsConfig().getContextPath();
    }

    @Override
    public String getSiteContextPathOrUrl() {
        return TotalityFilter.isInRequest() ? this.getSiteContextPath(true) : this.getConfiguredSiteURL();
    }
}

