/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.web;

import java.net.InetAddress;
import java.net.UnknownHostException;

public final class NetworkLocation {
    private static final String WILDCARD = "0.0.0.0";
    private final InetAddress hostInetAddress;
    private final int port;
    private final boolean explicitIpAddress;

    public NetworkLocation(String hostAndPort) throws UnknownHostException {
        int portIndex = hostAndPort.lastIndexOf(58);
        if (portIndex == -1) {
            this.port = Integer.parseInt(hostAndPort);
            this.hostInetAddress = null;
            this.explicitIpAddress = false;
        } else {
            this.port = Integer.parseInt(hostAndPort.substring(portIndex + 1));
            String hostSubstring = hostAndPort.substring(0, portIndex).trim();
            if (hostSubstring.length() == 0 || WILDCARD.equals(hostSubstring)) {
                this.hostInetAddress = null;
                this.explicitIpAddress = false;
            } else {
                InetAddress[] addresses = InetAddress.getAllByName(hostSubstring);
                InetAddress ourHost = null;
                for (InetAddress a2 : addresses) {
                    if (!a2.getHostAddress().equals(hostSubstring)) continue;
                    ourHost = a2;
                    break;
                }
                boolean bl = this.explicitIpAddress = ourHost != null;
                if (ourHost == null && addresses.length > 0) {
                    ourHost = addresses[0];
                }
                this.hostInetAddress = ourHost;
            }
        }
        if (this.port < 0 || this.port > 65535) {
            throw new IllegalArgumentException("Invalid port number: " + this.port);
        }
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getInetAddress() {
        return this.hostInetAddress;
    }

    public String getHost() {
        if (this.hostInetAddress != null) {
            return this.explicitIpAddress ? this.hostInetAddress.getHostAddress() : this.hostInetAddress.getHostName();
        }
        return WILDCARD;
    }

    public String toString() {
        return this.getHost() + ":" + this.port;
    }

    public boolean isWildcard() {
        return this.hostInetAddress == null;
    }
}

