/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.web;

import com.atlassian.crucible.explorers.ChangeSetPair;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.model.ChangesetComment;
import com.atlassian.fisheye.util.DevMode;
import com.atlassian.fisheye.web.SimpleSiteUrlBuilder;
import com.atlassian.fisheye.web.SiteUrlBuilder;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.web.ActionDispatcherServlet;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.cenqua.fisheye.web.util.WayBackUrlEncoder;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

public class NavBuilder {
    private static final String CRU_COMPONENT = "cru";
    private static final String SNIPPET_COMPONENT = "snippet";
    private static final String USER_COMPONENT = "user";
    private static final SiteUrlBuilder siteUrlBuilder = new SimpleSiteUrlBuilder();

    public static String changeset(String repoName, String csid) {
        NavBuilder.checkNotNull(repoName);
        NavBuilder.checkNotNull(csid);
        return NavBuilder.changelog(repoName) + "?cs=" + FishEyeURLEncoder.uriEncode(csid);
    }

    public static String changeset(HttpServletRequest request, String repoName, String csid) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.changeset(repoName, csid);
    }

    public static String changesetAbs(HttpServletRequest request, String repoName, String csid) {
        return NavBuilder.getSiteUrl(request) + "/" + NavBuilder.changeset(repoName, csid);
    }

    public static String changesetComment(ChangesetComment comment) {
        return NavBuilder.changesetComment(comment.getRepository(), comment.getCsid(), comment.getId());
    }

    public static String changesetComment(String repoName, String csid, int id) {
        return NavBuilder.changeset(repoName, csid) + "#c" + id;
    }

    public static String changesetComment(HttpServletRequest request, String repoName, String csid, int id) {
        return NavBuilder.changeset(request, repoName, csid) + "#c" + id;
    }

    public static String changesetCommentAbs(ChangesetComment c2) {
        return NavBuilder.changesetCommentAbs(null, c2.getRepository(), c2.getCsid(), c2.getId());
    }

    public static String changesetCommentAbs(HttpServletRequest request, String repoName, String csid, int id) {
        return NavBuilder.changesetAbs(request, repoName, csid) + "#c" + id;
    }

    public static String changesetDiscussion(String repoName, String csid) {
        return NavBuilder.changesetComment(repoName, csid, 0);
    }

    public static String changesetDiscussion(HttpServletRequest request, String repoName, String csid) {
        return NavBuilder.changesetComment(request, repoName, csid, 0);
    }

    public static String changesetDiscussionAbs(HttpServletRequest request, String repoName, String csid) {
        return NavBuilder.changesetCommentAbs(request, repoName, csid, 0);
    }

    public static String changelog(String repoName) {
        return NavBuilder.changelog(repoName, null);
    }

    public static String changelog(String repoName, @Nullable String branchName) {
        NavBuilder.checkNotNull(repoName);
        StringBuilder sb = new StringBuilder("changelog").append("/");
        if (branchName != null) {
            sb.append("~");
            sb.append("br=").append(WayBackUrlEncoder.commandUrlEncode(branchName));
            sb.append("/");
        }
        sb.append(FishEyeURLEncoder.uriEncode(repoName));
        return sb.toString();
    }

    public static String changelog(HttpServletRequest request, String repoName) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.changelog(repoName);
    }

    public static String changelogAtPath(HttpServletRequest request, String repoName, String pathString) {
        Path path = new Path(pathString);
        StringBuilder builder = new StringBuilder(NavBuilder.getContextPath(request)).append("/").append(NavBuilder.changelog(repoName));
        if (!path.isRoot()) {
            builder.append("/").append(path.getAsUrl());
        }
        return builder.toString();
    }

    public static String changelogAbs(HttpServletRequest request, String repoName) {
        return NavBuilder.getSiteUrl(request) + "/" + NavBuilder.changelog(repoName);
    }

    public static String changelogAbs(HttpServletRequest request, String repoName, String branchName) {
        return NavBuilder.getSiteUrl(request) + "/" + NavBuilder.changelog(repoName, branchName);
    }

    public static String changelogAtChangeset(HttpServletRequest request, String repoName, String csid) {
        NavBuilder.checkNotNullOrEmpty(csid);
        return NavBuilder.changelog(request, repoName) + "?showid=" + FishEyeURLEncoder.uriEncode(csid) + "&view=fe";
    }

    public static String browse(WaybackSpec waybackSpec, String repoName, Path filePath) {
        NavBuilder.checkNotNull(repoName);
        StringBuilder sb = new StringBuilder();
        sb.append("browse");
        if (waybackSpec != null && !waybackSpec.isEmpty()) {
            sb.append(waybackSpec.getUrlCommand());
        }
        sb.append("/").append(FishEyeURLEncoder.uriEncode(repoName));
        if (filePath != null) {
            sb.append("/").append(filePath.getAsUrl());
        }
        return sb.toString();
    }

    public static String browse(HttpServletRequest request, WaybackSpec waybackSpec, String repoName, Path filePath) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.browse(waybackSpec, repoName, filePath);
    }

    public static String browseAbs(WaybackSpec waybackSpec, String repoName, Path filePath) {
        return NavBuilder.getSiteUrl(null) + "/" + NavBuilder.browse(waybackSpec, repoName, filePath);
    }

    public static String browseAbs(HttpServletRequest request, WaybackSpec waybackSpec, String repoName, Path filePath) {
        return NavBuilder.getSiteUrl(request) + "/" + NavBuilder.browse(waybackSpec, repoName, filePath);
    }

    public static String browseRevision(HttpServletRequest request, WaybackSpec waybackSpec, String repoName, Path filePath, String revisionId) {
        NavBuilder.checkNotNull(revisionId);
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.browse(waybackSpec, repoName, filePath) + "#r" + revisionId;
    }

    public static String browseSource(WaybackSpec waybackSpec, String repoName, FileRevision revision) {
        NavBuilder.checkNotNull(revision);
        return NavBuilder.browseSource(waybackSpec, repoName, revision.getPath(), revision.getRevision());
    }

    public static String browseDiffToPrevious(HttpServletRequest request, WaybackSpec waybackSpec, String repoName, Path filePath, String revisionId) {
        NavBuilder.checkNotNull(revisionId);
        return NavBuilder.browse(request, waybackSpec, repoName, filePath) + "?r2=" + revisionId;
    }

    public static String browseSource(WaybackSpec waybackSpec, String repoName, Path path, String revision) {
        return NavBuilder.browse(waybackSpec, repoName, path) + "?r=" + FishEyeURLEncoder.uriEncode(revision);
    }

    public static String browseSource(HttpServletRequest request, WaybackSpec waybackSpec, String repoName, FileRevision revision) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.browseSource(waybackSpec, repoName, revision);
    }

    public static String browseSource(HttpServletRequest request, WaybackSpec waybackSpec, String repoName, Path path, String revision) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.browseSource(waybackSpec, repoName, path, revision);
    }

    public static String browseSourceAbs(HttpServletRequest request, WaybackSpec waybackSpec, String repoName, Path path, String revision) {
        return NavBuilder.getSiteUrl(request) + "/" + NavBuilder.browseSource(waybackSpec, repoName, path, revision);
    }

    public static String fileHistory(WaybackSpec waybackSpec, String repoName, FileRevision revision) {
        NavBuilder.checkNotNull(revision);
        return NavBuilder.browse(waybackSpec, repoName, revision.getPath()) + "#r" + FishEyeURLEncoder.uriEncode(revision.getRevision());
    }

    public static String fileHistory(HttpServletRequest request, WaybackSpec waybackSpec, String repoName, FileRevision revision) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.fileHistory(waybackSpec, repoName, revision);
    }

    public static String fileHistoryAbs(HttpServletRequest request, WaybackSpec waybackSpec, String repoName, FileRevision revision) {
        return NavBuilder.getSiteUrl(request) + "/" + NavBuilder.fileHistory(waybackSpec, repoName, revision);
    }

    public static String browseRawFile(String repoName, String revision, Path path) {
        NavBuilder.checkNotNull(repoName);
        NavBuilder.checkNotNull(revision);
        NavBuilder.checkNotNull(path);
        StringBuilder sb = new StringBuilder("browse").append("/~raw,r=").append(FishEyeURLEncoder.uriEncode(revision)).append("/").append(FishEyeURLEncoder.uriEncode(repoName)).append("/").append(path.getAsUrl());
        return sb.toString();
    }

    public static String browseRawFile(String repoName, FileRevision revision) {
        return NavBuilder.browseRawFile(repoName, revision.getRevision(), revision.getPath());
    }

    public static String browseRawFile(HttpServletRequest request, String repoName, FileRevision revision) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.browseRawFile(repoName, revision);
    }

    public static String browseRawFile(HttpServletRequest request, String repoName, String revision, Path path) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.browseRawFile(repoName, revision, path);
    }

    public static String browseDiff(WaybackSpec waybackSpec, String repoName, FileRevision revision) {
        NavBuilder.checkNotNull(revision);
        if (revision.getDiffRevision() == null) {
            return NavBuilder.browseSource(waybackSpec, repoName, revision);
        }
        return NavBuilder.browse(waybackSpec, repoName, revision.getPath()) + "?r1=" + FishEyeURLEncoder.uriEncode(revision.getDiffRevision().getRev()) + "&r2=" + FishEyeURLEncoder.uriEncode(revision.getRevision());
    }

    public static String browseDiff(HttpServletRequest request, WaybackSpec waybackSpec, String repoName, FileRevision revision) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.browseDiff(waybackSpec, repoName, revision);
    }

    public static String browseDiffAbs(HttpServletRequest request, WaybackSpec waybackSpec, String repoName, FileRevision revision) {
        return NavBuilder.getSiteUrl(request) + "/" + NavBuilder.browseDiff(waybackSpec, repoName, revision);
    }

    public static String branch(HttpServletRequest request, String repoName, String branchName) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.changelog(repoName, branchName);
    }

    public static String branchAbs(HttpServletRequest request, String repoName, String branchName) {
        return NavBuilder.getSiteUrl(request) + "/" + NavBuilder.changelog(repoName, branchName);
    }

    public static String graph(String repoName) {
        NavBuilder.checkNotNull(repoName);
        return "graph" + "/" + FishEyeURLEncoder.uriEncode(repoName);
    }

    public static String graph(HttpServletRequest request, String repoName) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.graph(repoName);
    }

    public static String graphAtChangeset(String repoName, String csid) {
        NavBuilder.checkNotNullOrEmpty(csid);
        return NavBuilder.graph(repoName) + "?" + "csid=" + FishEyeURLEncoder.uriEncode(csid);
    }

    public static String graphAtChangeset(HttpServletRequest request, String repoName, String csid) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.graphAtChangeset(repoName, csid);
    }

    public static String review(Review review) {
        return NavBuilder.review(review.getPermaId(), review.isSnippet());
    }

    public static String reviewComment(HttpServletRequest request, Comment comment) {
        Review review = comment.getReview();
        StringBuilder sb = new StringBuilder(NavBuilder.getContextPath(request));
        sb.append("/");
        sb.append(NavBuilder.reviewComment(comment));
        return sb.toString();
    }

    public static String reviewComment(Comment comment) {
        Review review = comment.getReview();
        return NavBuilder.review(review.getPermaId(), review.isSnippet()) + "#c" + comment.getId();
    }

    public static String reviewGeneralComments(Review review) {
        return NavBuilder.review(review.getPermaId(), review.isSnippet()) + "#general-comments";
    }

    public static String reviewFile(FileRevisionExtraInfo frx) {
        Review review = frx.getReview();
        return NavBuilder.review(review.getPermaId(), review.isSnippet()) + "#CFR-" + frx.getId();
    }

    public static String review(HttpServletRequest request, Review review, boolean forwardRequestParams) {
        String queryString;
        StringBuilder builder = new StringBuilder(NavBuilder.getContextPath(request)).append("/").append(NavBuilder.review(review.getPermaId(), review.isSnippet()));
        if (forwardRequestParams && !(queryString = NavBuilder.forwardRequestParametersToQueryString(request)).equals("")) {
            builder.append("?").append(queryString);
        }
        return builder.toString();
    }

    public static String review(HttpServletRequest request, Review review) {
        return NavBuilder.review(request, review, false);
    }

    public static String reviewWithRequestParams(HttpServletRequest request, Review review) {
        return NavBuilder.review(request, review, true);
    }

    private static String forwardRequestParametersToQueryString(HttpServletRequest request) {
        StringBuilder queryParams = new StringBuilder();
        for (Map.Entry valuesByKey : request.getParameterMap().entrySet()) {
            if ("wasInvalidToken".equals(valuesByKey.getKey())) continue;
            for (String value : (String[])valuesByKey.getValue()) {
                if (Strings.isNullOrEmpty((String)value)) continue;
                if (queryParams.length() > 0) {
                    queryParams.append("&");
                }
                queryParams.append(FishEyeURLEncoder.uriEncode((String)valuesByKey.getKey()));
                queryParams.append("=");
                queryParams.append(FishEyeURLEncoder.uriEncode(value));
            }
        }
        return queryParams.toString();
    }

    public static String reviewAbs(HttpServletRequest request, Review review) {
        return NavBuilder.getSiteUrl(request) + "/" + NavBuilder.review(review.getPermaId(), review.isSnippet());
    }

    public static String reviewAbs(HttpServletRequest request, String reviewPermaId) {
        return NavBuilder.getSiteUrl(request) + "/" + NavBuilder.review(reviewPermaId, false);
    }

    public static String review(HttpServletRequest request, String permaId) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.review(permaId, false);
    }

    private static String review(String reviewPermaId, boolean isSnippet) {
        NavBuilder.checkNotNull(reviewPermaId);
        return NavBuilder.makeUrl(reviewPermaId, isSnippet ? SNIPPET_COMPONENT : CRU_COMPONENT);
    }

    public static String createReview(HttpServletRequest request, String repoName, String csid) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.createReview(repoName, csid);
    }

    public static String createReviewAbs(HttpServletRequest request, String repoName, String csid) {
        return NavBuilder.getSiteUrl(request) + "/" + NavBuilder.createReview(repoName, csid);
    }

    private static String createReview(String repoName, String csid) {
        return "cru/create?csid=" + FishEyeURLEncoder.uriEncode(ChangeSetPair.newInstance(repoName, csid).toString());
    }

    public static String committer(HttpServletRequest request, String repoName, String committerName) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.committer(repoName, committerName);
    }

    public static String committerAbs(HttpServletRequest request, String repoName, String committerName) {
        return NavBuilder.getSiteUrl(request) + "/" + NavBuilder.committer(repoName, committerName);
    }

    public static String committer(String repoName, String committerName) {
        NavBuilder.checkNotNull(repoName);
        NavBuilder.checkNotNull(committerName);
        return "committer/" + NavBuilder.makeUrl(committerName.toLowerCase(), repoName);
    }

    public static String comment(HttpServletRequest request, String reviewPermaId, int commentId) {
        return NavBuilder.review(request, reviewPermaId) + "#c" + commentId;
    }

    public static String commentAbs(HttpServletRequest request, String reviewPermaId, int commentId) {
        return NavBuilder.reviewAbs(request, reviewPermaId) + "#c" + commentId;
    }

    public static String user(FecruUser feUser) {
        NavBuilder.checkNotNull(feUser);
        return NavBuilder.user(feUser.getUsername());
    }

    public static String user(HttpServletRequest request, FecruUser user) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.user(user);
    }

    public static String user(String username) {
        NavBuilder.checkNotNull(username);
        return NavBuilder.makeUrl(username, USER_COMPONENT);
    }

    public static String user(HttpServletRequest request, String username) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.user(username);
    }

    public static String userAbs(HttpServletRequest request, String username) {
        return NavBuilder.getSiteUrl(request) + "/" + NavBuilder.user(username);
    }

    private static String makeUrl(String entityData, String entityType) {
        return FishEyeURLEncoder.uriEncode(entityType) + "/" + FishEyeURLEncoder.uriEncode(entityData);
    }

    public static String project(Project project) {
        return NavBuilder.project(project.getProjKey());
    }

    public static String project(String projectKey) {
        NavBuilder.checkNotNull(projectKey);
        return NavBuilder.makeUrl(projectKey, "project");
    }

    public static String project(HttpServletRequest request, Project project) {
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.project(project);
    }

    public static String project(HttpServletRequest request, String projectKey) {
        NavBuilder.checkNotNull(projectKey);
        return NavBuilder.getContextPath(request) + "/" + NavBuilder.project(projectKey);
    }

    public static String projectAbs(HttpServletRequest request, String projectKey) {
        NavBuilder.checkNotNull(projectKey);
        return NavBuilder.getSiteUrl(request) + "/" + NavBuilder.project(projectKey);
    }

    private static String getContextPath(HttpServletRequest req) {
        return req != null ? req.getContextPath() : AppConfig.getsConfig().getContextPath();
    }

    public static String getSiteUrl() {
        return siteUrlBuilder.getSiteUrl();
    }

    public static String getSiteUrl(HttpServletRequest req) {
        return siteUrlBuilder.getSiteUrl(req);
    }

    private static void checkNotNull(Object param) {
        if (param == null) {
            NullPointerException npe = new NullPointerException("unexpected null parameter");
            Logs.APP_LOG.error((Object)"Unexpected null", (Throwable)npe);
            if (DevMode.isDevMode()) {
                throw npe;
            }
        }
    }

    private static void checkNotNullOrEmpty(Object param) {
        NavBuilder.checkNotNull(param);
        boolean empty = false;
        if (param instanceof String) {
            empty = ((String)param).isEmpty();
        } else if (param instanceof Collection) {
            empty = ((Collection)param).isEmpty();
        }
        if (empty) {
            IllegalArgumentException iae = new IllegalArgumentException("unexpected empty parameter");
            Logs.APP_LOG.error((Object)"Unexpected empty argument", (Throwable)iae);
            if (DevMode.isDevMode()) {
                throw iae;
            }
        }
    }

    public static String reviewDashboard(HttpServletRequest request) {
        return NavBuilder.getContextPath(request) + "/" + CRU_COMPONENT;
    }

    public static String reviewInbox(HttpServletRequest request) {
        return NavBuilder.reviewDashboard(request) + "?filter=inbox";
    }

    public static String userDashboard(HttpServletRequest request) {
        return NavBuilder.getContextPath(request) + "/" + USER_COMPONENT;
    }

    public static String repository(HttpServletRequest request, String repository) {
        return NavBuilder.browse(request, null, repository, null);
    }

    public static String repositoryAbs(HttpServletRequest request, String repository) {
        return NavBuilder.browseAbs(request, null, repository, null);
    }

    public static String quickSearch(HttpServletRequest request, String repository, String query) {
        StringBuilder sb = new StringBuilder(NavBuilder.getContextPath(request)).append("/qsearch");
        if (!Strings.isNullOrEmpty((String)repository)) {
            sb.append("/").append(FishEyeURLEncoder.uriEncode(repository));
        }
        if (!Strings.isNullOrEmpty((String)query)) {
            sb.append("?q=").append(FishEyeURLEncoder.uriEncode(query));
        }
        return sb.toString();
    }

    public static String logicalPathRedirect(HttpServletRequest request, String repository, String logicalPath) {
        return NavBuilder.getContextPath(request) + "/browse/" + FishEyeURLEncoder.uriEncode(repository) + "?logicalPathRedirect=" + FishEyeURLEncoder.uriEncode(logicalPath);
    }

    public static String staticResourceAbs(String path) {
        return NavBuilder.getSiteUrl() + "/" + NavBuilder.staticResource(path);
    }

    public static String staticResource(String path) {
        return ActionDispatcherServlet.STATIC_DIR + "/" + path;
    }
}

