/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.web;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.soy.renderer.SoyException;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterState;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterTree;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.soy.SoyRenderer;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class HeaderUtil {
    private static final UserManager userManager = AppConfig.getsConfig().getUserManager();

    private static FecruUser getCurrentUser(PageContext context) {
        return userManager.getUserFor(userManager.getCurrentUser((HttpServletRequest)context.getRequest()));
    }

    private static FecruUser getCurrentCrucibleUser(PageContext context) {
        FecruUser user = HeaderUtil.getCurrentUser(context);
        return user == null ? null : CrucibleUserManager.getUserByName(user.getUsername());
    }

    public static ReviewFilterTree getReviewFilterTree(PageContext context) {
        FecruUser cruUser = HeaderUtil.getCurrentCrucibleUser(context);
        if (cruUser != null) {
            ReviewFilterState filterState = new ReviewFilterState(cruUser, ReviewFilters.FilterKey.INBOX, "some action?");
            return new ReviewFilterTree(filterState);
        }
        return null;
    }

    public static String renderHeader(RootConfig rootConfig, SoyRenderer soyRenderer, String primaryNavContent, String secondaryNavContent) throws SoyException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("headerLink", rootConfig.getContextPath() + "/");
        params.put("logo", rootConfig.isCrucibleOnly() ? "crucible" : (rootConfig.isFishEyeOnly() ? "fisheye" : "fecru"));
        params.put("primaryNavContent", primaryNavContent);
        params.put("secondaryNavContent", secondaryNavContent);
        params.put("headerBeforeContent", soyRenderer.render("com.atlassian.plugins.atlassian-nav-links-plugin:rotp-menu", "navlinks.templates.appswitcher.switcher", Collections.emptyMap()));
        return soyRenderer.render("com.atlassian.auiplugin:aui-experimental-soy-templates", "aui.page.header", params);
    }
}

