/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import java.util.ArrayList;
import java.util.List;

public class BreadCrumb {
    private final Path path;
    private final String encodedUrl;
    private final String linkname;
    private final String title;

    public BreadCrumb(Path path, String encodedUrl, String linkname, String title) {
        this.path = path;
        this.encodedUrl = encodedUrl;
        this.linkname = linkname;
        this.title = title;
    }

    public Path getPath() {
        return this.path;
    }

    public String getEncodedUrl() {
        return this.encodedUrl;
    }

    public String getLinkname() {
        return this.linkname;
    }

    public String getTitle() {
        return this.title;
    }

    public static BreadCrumb create(Path path, String encodedUrl, String linkname, String title) {
        return new BreadCrumb(path, encodedUrl, linkname, title);
    }

    public static BreadCrumb createRepoCrumb(String repname) {
        return BreadCrumb.createRepoCrumb(repname, "", "changelog");
    }

    private static BreadCrumb createRepoCrumb(String repname, String urlCommand, String view) {
        if (urlCommand == null) {
            urlCommand = "";
        }
        return new BreadCrumb(null, "/" + view + urlCommand + "/" + FishEyeURLEncoder.uriEncode(repname), repname, null);
    }

    private static BreadCrumb createPathCrumb(String repname, Path path, String urlCommand) {
        if (urlCommand == null) {
            urlCommand = "";
        }
        return new BreadCrumb(path, "/browse" + urlCommand + "/" + FishEyeURLEncoder.uriEncode(repname) + "/" + path.getAsUrl(), path.getName(), path.getPath());
    }

    public static List<BreadCrumb> createPathCrumbs(String repname, Path path, String urlCommand) {
        ArrayList<BreadCrumb> crumbs = new ArrayList<BreadCrumb>();
        if (path.getNumComponents() == 0) {
            return crumbs;
        }
        crumbs.add(BreadCrumb.createRepoCrumb(repname, urlCommand, "browse"));
        Path[] paths = path.abbreviatePathComponents(130);
        for (int i2 = 0; i2 < paths.length; ++i2) {
            Path pathComp = paths[i2];
            if (pathComp == null) {
                crumbs.add(BreadCrumb.create(null, null, "...", null));
                continue;
            }
            if (pathComp.getNumComponents() == 0 || i2 == paths.length - 1) continue;
            crumbs.add(BreadCrumb.createPathCrumb(repname, pathComp, urlCommand));
        }
        return crumbs;
    }

    public static BreadCrumb createCsCrumb(String repname, ChangeSet cs) {
        return new BreadCrumb(null, "/changelog/" + FishEyeURLEncoder.uriEncode(repname) + "?showid=" + FishEyeURLEncoder.uriEncode(cs.getId()), cs.getDisplayId(), cs.getComment());
    }

    public static List<BreadCrumb> addToList(List<BreadCrumb> existing, BreadCrumb crumb) {
        if (existing == null) {
            existing = new ArrayList<BreadCrumb>();
        }
        existing.add(crumb);
        return existing;
    }
}

