/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.util;

import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.web.filters.MessageSource;
import com.cenqua.fisheye.web.filters.SimpleMessage;
import com.cenqua.fisheye.web.filters.SystemMessage;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class ClearCaseMessageSource
implements MessageSource {
    public static final String CLEARCASE_EOL_DOCO = "https://confluence.atlassian.com/display/FISHEYE/Upgrading+from+FishEye+2.7+with+existing+ClearCase+Repositories";
    @Resource
    private RepositoryManager repositoryManager;
    @Resource
    private RootConfig rootConfig;

    @Override
    public List<SystemMessage> getMessages(HttpServletRequest request) {
        int count = this.repositoryManager.getClearCaseRepoCount();
        if (count != 0) {
            return Collections.singletonList(new SimpleMessage("You have " + count + " ClearCase " + ExpressionUtil.pluralise("repository", "repositories", count) + " configured. " + this.rootConfig.getProductName() + " no longer supports ClearCase. These repositories have been disabled in " + this.rootConfig.getProductName() + ". ", CLEARCASE_EOL_DOCO, true, SimpleMessage.ShowIn.HEADER));
        }
        return Collections.emptyList();
    }
}

