/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.permissions.model;

import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;

public final class GlobalPermission {
    private Integer id;
    private String group;
    private boolean fisheyeUser;
    private boolean crucibleUser;

    public GlobalPermission() {
    }

    public GlobalPermission(String group, Set<GlobalPermissionType> globalPermissionTypes) {
        this.group = group;
        this.setGlobalUserPermissions(globalPermissionTypes);
    }

    public GlobalPermission(String group, boolean fisheyeUser, boolean crucibleUser) {
        this.group = group;
        this.setFisheyeUser(fisheyeUser);
        this.setCrucibleUser(crucibleUser);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public boolean isCrucibleUser() {
        return this.crucibleUser;
    }

    public void setCrucibleUser(boolean crucibleUser) {
        this.crucibleUser = crucibleUser;
    }

    public boolean isFisheyeUser() {
        return this.fisheyeUser;
    }

    public void setFisheyeUser(boolean fisheyeUser) {
        this.fisheyeUser = fisheyeUser;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setGlobalUserPermissions(Set<GlobalPermissionType> globalPermissionTypes) {
        this.setFisheyeUser(globalPermissionTypes.contains(GlobalPermissionType.FISHEYE_USER));
        this.setCrucibleUser(globalPermissionTypes.contains(GlobalPermissionType.CRUCIBLE_USER));
    }

    public Set<GlobalPermissionType> toGlobalUserPermissionSet() {
        ImmutableSet.Builder permissions = ImmutableSet.builder();
        if (this.fisheyeUser) {
            permissions.add((Object)GlobalPermissionType.FISHEYE_USER);
        }
        if (this.crucibleUser) {
            permissions.add((Object)GlobalPermissionType.CRUCIBLE_USER);
        }
        return permissions.build();
    }

    public boolean hasAnyPermissions() {
        return this.fisheyeUser || this.crucibleUser;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        GlobalPermission that = (GlobalPermission)o2;
        return this.fisheyeUser == that.fisheyeUser && this.crucibleUser == that.crucibleUser && Objects.equals(this.group, that.group);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.fisheyeUser, this.crucibleUser);
    }
}

