/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.permissions.cache;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.UserListChangedEvent;
import com.atlassian.fisheye.user.permissions.GlobalPermissionModifiedEvent;
import com.atlassian.fisheye.user.permissions.cache.GlobalPermissionCache;
import com.cenqua.fisheye.logging.Logs;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GlobalPermissionCacheInvalidator {
    private static final Logger log = Logs.loggerFor(GlobalPermissionCacheInvalidator.class);
    private final GlobalPermissionCache cache;
    private final EventPublisher eventPublisher;

    @Autowired
    public GlobalPermissionCacheInvalidator(GlobalPermissionCache cache, EventPublisher eventPublisher) {
        this.cache = cache;
        this.eventPublisher = eventPublisher;
    }

    @PostConstruct
    public void registerListener() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void unregisterListener() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onUserListChanged(UserListChangedEvent event) {
        this.invalidate(event);
    }

    @EventListener
    public void onGlobalPermissionsChanged(GlobalPermissionModifiedEvent event) {
        this.invalidate(event);
    }

    private void invalidate(Object cause) {
        log.debug((Object)("Invalidating cache due to " + cause));
        this.cache.invalidateAll();
    }
}

