/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.permissions.cache;

import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.fisheye.user.permissions.cache.GlobalPermissionCacheLoader;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.SetMultimap;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GlobalPermissionCache {
    private final LoadingCache<Object, SetMultimap<GlobalPermissionType, String>> usersWithPermissionCache;
    private final Object CACHE_KEY = new Object();

    @Autowired
    public GlobalPermissionCache(final GlobalPermissionCacheLoader globalPermissionCacheLoader) {
        this.usersWithPermissionCache = CacheBuilder.newBuilder().expireAfterWrite(24L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<Object, SetMultimap<GlobalPermissionType, String>>(){

            public SetMultimap<GlobalPermissionType, String> load(Object key) throws Exception {
                return globalPermissionCacheLoader.load(key);
            }
        });
    }

    public Set<String> getUsersWithPermission(GlobalPermissionType permission) {
        return ((SetMultimap)this.usersWithPermissionCache.getUnchecked(this.CACHE_KEY)).get((Object)permission);
    }

    public void invalidateAll() {
        this.usersWithPermissionCache.invalidateAll();
    }
}

