/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.permissions.cache;

import com.atlassian.fecru.utils.collectors.ImmutableCollectors;
import com.atlassian.fisheye.user.permissions.GlobalPermissionDao;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.fisheye.user.permissions.cache.GlobalPermissionCacheLoader;
import com.atlassian.fisheye.user.permissions.model.GlobalPermission;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Timer;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class EagerGlobalPermissionCacheLoader
implements GlobalPermissionCacheLoader {
    private static final Logger log = Logs.loggerFor(EagerGlobalPermissionCacheLoader.class);
    private final GlobalPermissionDao dao;
    private final GroupMembershipManager groupMembershipManager;

    @Autowired
    public EagerGlobalPermissionCacheLoader(GlobalPermissionDao dao, GroupMembershipManager groupMembershipManager) {
        this.dao = dao;
        this.groupMembershipManager = groupMembershipManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public SetMultimap<GlobalPermissionType, String> load(@Nonnull Object key) throws Exception {
        Timer loadTimer = new Timer(log, "Loading global permission cache");
        try {
            ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder().orderValuesBy(Comparator.naturalOrder());
            for (GlobalPermission groupPermission : this.dao.getGroupsWithPermissions(Collections.emptySet(), 0, Integer.MAX_VALUE)) {
                List usersInGroup = (List)this.groupMembershipManager.getUsersInGroup(groupPermission.getGroup()).stream().map(user -> UserManager.USERNAME_NORMALIZATION.apply(user.getUsername())).collect(ImmutableCollectors.toList());
                for (GlobalPermissionType type : groupPermission.toGlobalUserPermissionSet()) {
                    result.putAll((Object)type, (Iterable)usersInGroup);
                }
            }
            ImmutableSetMultimap immutableSetMultimap = result.build();
            return immutableSetMultimap;
        }
        finally {
            loadTimer.end();
        }
    }
}

