/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.permissions;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fisheye.user.permissions.GlobalPermissionDao;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionModifiedEvent;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.fisheye.user.permissions.cache.GlobalPermissionCache;
import com.atlassian.fisheye.user.permissions.model.GlobalPermission;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins
@Component(value="globalPermissionManager")
public class DefaultGlobalPermissionManager
implements GlobalPermissionManager {
    private static final Logger log = Logs.loggerFor(DefaultGlobalPermissionManager.class);
    private final GlobalPermissionDao dao;
    private final EventPublisher eventPublisher;
    private final GlobalPermissionCache globalPermissionCache;

    @Autowired
    public DefaultGlobalPermissionManager(GlobalPermissionDao dao, EventPublisher eventPublisher, GlobalPermissionCache globalPermissionCache) {
        this.dao = dao;
        this.eventPublisher = eventPublisher;
        this.globalPermissionCache = globalPermissionCache;
    }

    @Override
    public boolean hasPermission(String username, GlobalPermissionType permission) {
        return this.hasPermissions(username, Collections.singleton(permission));
    }

    @Override
    public boolean hasPermissions(String username, Set<GlobalPermissionType> permissions) {
        return permissions.stream().allMatch(permission -> this.getUsersWithPermission((GlobalPermissionType)permission).contains(UserManager.USERNAME_NORMALIZATION.apply(username)));
    }

    @Override
    @Transactional
    public void setPermissionsForGroup(String group, GlobalPermissionType permissions) {
        this.setPermissionsForGroup(group, (Set<GlobalPermissionType>)ImmutableSet.of((Object)permissions));
    }

    @Override
    @Transactional
    public void setPermissionsForGroup(String group, Set<GlobalPermissionType> permissions) {
        log.debug((Object)("Setting " + permissions + " to group: " + group));
        if (!this.canAddPermission(this.getPermissionForGroup(group), permissions)) {
            throw new IllegalStateException("Can't add Crucible permission without Fisheye");
        }
        this.dao.setPermissionsForGroup(UserManager.GROUPNAME_NORMALIZATION.apply(group), permissions);
        this.eventPublisher.publish((Object)new GlobalPermissionModifiedEvent());
    }

    private boolean canAddPermission(Optional<GlobalPermission> group, Set<GlobalPermissionType> permissions) {
        return !permissions.contains(GlobalPermissionType.CRUCIBLE_USER) || permissions.contains(GlobalPermissionType.FISHEYE_USER);
    }

    @Override
    @Transactional
    public void removeAllPermissionsForGroup(String group) {
        log.debug((Object)("Revoking all permissions to group: " + group));
        this.dao.removeAllPermissionsForGroup(UserManager.GROUPNAME_NORMALIZATION.apply(group));
        this.eventPublisher.publish((Object)new GlobalPermissionModifiedEvent());
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<GlobalPermission> getPermissionForGroup(String group) {
        return Optional.ofNullable(this.dao.getPermissionForGroup(group));
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<GlobalPermission> listPermissions(@Nonnull PageRequest pageRequest) {
        return this.dao.getGroupsWithPermissions(Collections.emptySet(), pageRequest.getStart(), pageRequest.getLimit());
    }

    @Override
    public int countUsersWithPermission(GlobalPermissionType permission) {
        return this.getUsersWithPermission(permission).size();
    }

    @Override
    public Set<String> getUsersWithPermission(GlobalPermissionType permission) {
        return this.globalPermissionCache.getUsersWithPermission(permission);
    }
}

