/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.permissions;

import com.atlassian.fisheye.user.permissions.GlobalPermissionDao;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.fisheye.user.permissions.model.GlobalPermission;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="globalPermissionDao")
public class DefaultGlobalPermissionDao
implements GlobalPermissionDao {
    private final CurrentSessionProvider currentSessionProvider;

    @Autowired
    public DefaultGlobalPermissionDao(CurrentSessionProvider currentSessionProvider) {
        this.currentSessionProvider = currentSessionProvider;
    }

    @Override
    public void setPermissionsForGroup(@Nonnull String group, @Nonnull Set<GlobalPermissionType> permissions) {
        Session session = this.currentSessionProvider.currentSession();
        GlobalPermission globalPermission = (GlobalPermission)this.getGroupMatchingCriteria(group, session).uniqueResult();
        if (globalPermission != null) {
            if (permissions.isEmpty()) {
                session.delete((Object)globalPermission);
            } else {
                globalPermission.setGlobalUserPermissions(permissions);
                session.update((Object)globalPermission);
            }
        } else if (!permissions.isEmpty()) {
            GlobalPermission newGlobalPermission = new GlobalPermission(group, permissions);
            session.save((Object)newGlobalPermission);
        }
    }

    @Override
    public void removeAllPermissionsForGroup(@Nonnull String group) {
        Session session = this.currentSessionProvider.currentSession();
        Query query = session.createQuery("FROM GlobalPermission where group = :group");
        query.setParameter("group", (Object)group);
        Optional<GlobalPermission> maybePermission = Optional.ofNullable((GlobalPermission)query.uniqueResult());
        maybePermission.ifPresent(arg_0 -> ((Session)session).delete(arg_0));
    }

    @Override
    public boolean existsGroupWithPermission(@Nonnull Collection<String> groups, @Nonnull Set<GlobalPermissionType> permissions) {
        if (groups.isEmpty()) {
            return false;
        }
        Session session = this.currentSessionProvider.currentSession();
        Criteria criteria = session.createCriteria(GlobalPermission.class);
        Disjunction orGroupsAndPermissions = Restrictions.disjunction();
        groups.stream().map(group -> {
            SimpleExpression eqGroup = Restrictions.eq((String)"group", (Object)group);
            Conjunction and = Restrictions.conjunction();
            and.add((Criterion)eqGroup);
            permissions.forEach(permission -> and.add(this.mapPermissionToCriterion((GlobalPermissionType)permission, true)));
            return and;
        }).forEach(arg_0 -> ((Disjunction)orGroupsAndPermissions).add(arg_0));
        criteria.add((Criterion)orGroupsAndPermissions);
        criteria.setProjection((Projection)Projections.count((String)"id"));
        Object count = criteria.uniqueResult();
        return count != null && (Long)count > 0L;
    }

    @Override
    public Collection<GlobalPermission> getGroupsWithPermissions(@Nonnull Set<GlobalPermissionType> permissions, int start, int limit) {
        Session session = this.currentSessionProvider.currentSession();
        Criteria criteria = session.createCriteria(GlobalPermission.class);
        permissions.forEach(perm -> criteria.add(this.mapPermissionToCriterion((GlobalPermissionType)perm, true)));
        criteria.setFirstResult(start);
        criteria.setMaxResults(limit);
        criteria.addOrder(Order.asc((String)"group"));
        return HibernateUtil.typedList(criteria);
    }

    @Override
    public GlobalPermission getPermissionForGroup(String group) {
        Criteria criteria = this.getGroupMatchingCriteria(group, this.currentSessionProvider.currentSession());
        return (GlobalPermission)criteria.uniqueResult();
    }

    @VisibleForTesting
    Criterion mapPermissionToCriterion(GlobalPermissionType permission, boolean equals) {
        return Restrictions.eq((String)this.mapPermissionToProperty(permission), (Object)equals);
    }

    private String mapPermissionToProperty(GlobalPermissionType permissionType) {
        switch (permissionType) {
            case FISHEYE_USER: {
                return "fisheyeUser";
            }
            case CRUCIBLE_USER: {
                return "crucibleUser";
            }
        }
        throw new IllegalArgumentException("Could not map");
    }

    private Criteria getGroupMatchingCriteria(@Nonnull String group, Session session) {
        Criteria criteria = session.createCriteria(GlobalPermission.class);
        criteria.add((Criterion)Restrictions.eq((String)"group", (Object)group));
        return criteria;
    }
}

