/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.permissions;

import com.atlassian.crucible.spi.services.GlobalPermissionService;
import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.fisheye.user.permissions.EffectiveUserPermissionService;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.cenqua.fisheye.license.LicenseInfo;
import com.google.common.base.Preconditions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="effectiveUserPermissionService")
public class DefaultEffectiveUserPermissionService
implements EffectiveUserPermissionService {
    @Autowired
    private GlobalPermissionService globalPermissionService;
    @Autowired
    private LicenseManager licenseManager;

    @Override
    public boolean canUserAccessFisheye(String username) {
        Preconditions.checkNotNull((Object)username);
        LicenseInfo licenseInfo = this.licenseManager.getLicenseInfo();
        return licenseInfo != null && licenseInfo.isFishEye() && this.globalPermissionService.hasUserPermissions(username, GlobalPermissionType.FISHEYE_USER);
    }

    @Override
    public boolean canUserAccessCrucible(String username) {
        Preconditions.checkNotNull((Object)username);
        LicenseInfo licenseInfo = this.licenseManager.getLicenseInfo();
        return licenseInfo != null && licenseInfo.isCrucible() && this.globalPermissionService.hasUserPermissions(username, GlobalPermissionType.CRUCIBLE_USER);
    }
}

