/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.model;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.atlassian.fisheye.user.model.RecentlyVisitedItemFactory;
import com.atlassian.fisheye.user.model.RecentlyVisitedUser;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.user.UserManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecentlyVisitedUserFactory
implements RecentlyVisitedItemFactory<RecentlyVisitedUser> {
    private final UserManager userManager;

    @Autowired
    public RecentlyVisitedUserFactory(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    public RecentlyVisitedUser createItem(String username, String entityId, long lastViewed) {
        return new RecentlyVisitedUser(username, UserManager.USERNAME_NORMALIZATION.apply(entityId), lastViewed);
    }

    @Override
    public void load(RecentlyVisitedUser historyItem, Principal principal) {
        FecruUser user = this.userManager.getLicensedUser(historyItem.getEntityId());
        historyItem.setUser(user);
    }

    @Override
    public RecentlyVisitedItem.Type getType() {
        return RecentlyVisitedItem.Type.USER;
    }
}

