/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.model;

import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.atlassian.fisheye.user.model.RecentlyVisitedItemFactory;
import com.atlassian.fisheye.user.model.RecentlyVisitedSnippet;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecentlyVisitedSnippetFactory
implements RecentlyVisitedItemFactory<RecentlyVisitedSnippet> {
    private final ReviewManager reviewManager;
    private final PermissionManager permissionManager;

    @Autowired
    public RecentlyVisitedSnippetFactory(ReviewManager reviewManager, PermissionManager permissionManager) {
        this.reviewManager = reviewManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public RecentlyVisitedSnippet createItem(String username, String entityId, long lastViewed) {
        return new RecentlyVisitedSnippet(username, entityId, lastViewed);
    }

    @Override
    public void load(RecentlyVisitedSnippet historyItem, Principal principal) {
        Review review = this.reviewManager.getReviewByPermaId(historyItem.getEntityId());
        if (review != null && principal != null && this.permissionManager.canPrincipalDoAction(review.getProject().getPermissionScheme(), principal, null, UserActionManager.ACTION_VIEW, review)) {
            historyItem.setReview(review);
        }
    }

    @Override
    public RecentlyVisitedItem.Type getType() {
        return RecentlyVisitedItem.Type.SNIPPET;
    }
}

