/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.model;

import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewPermaId;

public class RecentlyVisitedReview
extends RecentlyVisitedItem<Review> {
    private Review review;

    public RecentlyVisitedReview() {
        this.setEntityType(RecentlyVisitedItem.Type.REVIEW.getType());
    }

    public RecentlyVisitedReview(String username, String entityId, long lastViewed) {
        super(username, entityId, lastViewed);
        this.setEntityType(RecentlyVisitedItem.Type.REVIEW.getType());
    }

    public void setReview(Review review) {
        if (review != null && !review.getPermaId().equals(this.getEntityId())) {
            boolean found = false;
            for (ReviewPermaId reviewPermaId : review.getPermaIdHistory()) {
                if (!this.getEntityId().equals(reviewPermaId.getPermaIdKey().toString())) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("Can't associate review " + review + " with entityId " + this.getEntityId());
            }
        }
        this.review = review;
    }

    @Override
    public Review getEntity() {
        return this.review;
    }
}

