/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.model;

import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.atlassian.fisheye.user.model.RecentlyVisitedItemFactory;
import com.atlassian.fisheye.user.model.RecentlyVisitedRepository;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecentlyVisitedRepositoryFactory
implements RecentlyVisitedItemFactory<RecentlyVisitedRepository> {
    private final RepositoryManager repoManager;
    private final UserManager userManager;

    @Autowired
    public RecentlyVisitedRepositoryFactory(RepositoryManager repoManager, UserManager userManager) {
        this.repoManager = repoManager;
        this.userManager = userManager;
    }

    @Override
    public RecentlyVisitedRepository createItem(String username, String entityId, long lastViewed) {
        return new RecentlyVisitedRepository(username, entityId, lastViewed);
    }

    @Override
    public void load(RecentlyVisitedRepository historyItem, Principal principal) {
        RepositoryHandle repositoryHandle = this.repoManager.getRepository(historyItem.getEntityId());
        if (repositoryHandle != null && principal != null && this.userManager.hasPermissionToAccess(principal, repositoryHandle)) {
            historyItem.setRepository(repositoryHandle);
        }
    }

    @Override
    public RecentlyVisitedItem.Type getType() {
        return RecentlyVisitedItem.Type.REPOSITORY;
    }
}

