/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.model;

import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.atlassian.fisheye.user.model.RecentlyVisitedItemFactory;
import com.atlassian.fisheye.user.model.RecentlyVisitedProject;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecentlyVisitedProjectFactory
implements RecentlyVisitedItemFactory<RecentlyVisitedProject> {
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;

    @Autowired
    public RecentlyVisitedProjectFactory(ProjectManager projectManager, PermissionManager permissionManager) {
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public RecentlyVisitedProject createItem(String username, String entityId, long lastViewed) {
        return new RecentlyVisitedProject(username, entityId, lastViewed);
    }

    @Override
    public void load(RecentlyVisitedProject historyItem, Principal principal) {
        Project project = this.projectManager.getProjectByKey(historyItem.getEntityId());
        if (project != null && principal != null && this.permissionManager.isProjectVisible(principal, project)) {
            historyItem.setProject(project);
        }
    }

    @Override
    public RecentlyVisitedItem.Type getType() {
        return RecentlyVisitedItem.Type.PROJECT;
    }
}

