/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.model;

import com.cenqua.crucible.model.ModelUtils;
import com.cenqua.fisheye.user.UserManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class RecentlyVisitedItem<T>
implements Serializable {
    private String username;
    private String entityType;
    private String entityId;
    private Long lastViewed;

    protected RecentlyVisitedItem() {
    }

    protected RecentlyVisitedItem(String username, String entityId, long lastViewed) {
        this.setEntityId(entityId);
        this.setUsername(username);
        this.setLastViewed(lastViewed);
    }

    public abstract T getEntity();

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        ModelUtils.ensureNotNullOrEmpty("User names", username);
        this.username = UserManager.USERNAME_NORMALIZATION.apply(username);
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        ModelUtils.ensureNotNullOrEmpty("Entity IDs", entityId);
        this.entityId = entityId;
    }

    public Long getLastViewed() {
        return this.lastViewed;
    }

    public void setLastViewed(Long lastViewed) {
        this.lastViewed = lastViewed;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        RecentlyVisitedItem that = (RecentlyVisitedItem)o2;
        if (this.entityId != null ? !this.entityId.equals(that.entityId) : that.entityId != null) {
            return false;
        }
        if (this.entityType != null ? !this.entityType.equals(that.entityType) : that.entityType != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    public int hashCode() {
        int result = this.username != null ? this.username.hashCode() : 0;
        result = 31 * result + (this.entityType != null ? this.entityType.hashCode() : 0);
        result = 31 * result + (this.entityId != null ? this.entityId.hashCode() : 0);
        return result;
    }

    public static enum Type {
        REPOSITORY("atlassian-repository"){

            @Override
            public <T> T visit(TypeVisitor<T> visitor) {
                return visitor.visitRepository();
            }
        }
        ,
        PROJECT("atlassian-project"){

            @Override
            public <T> T visit(TypeVisitor<T> visitor) {
                return visitor.visitProject();
            }
        }
        ,
        REVIEW("atlassian-review"){

            @Override
            public <T> T visit(TypeVisitor<T> visitor) {
                return visitor.visitReview();
            }
        }
        ,
        SNIPPET("atlassian-snippet"){

            @Override
            public <T> T visit(TypeVisitor<T> visitor) {
                return visitor.visitSnippet();
            }
        }
        ,
        USER("atlassian-user"){

            @Override
            public <T> T visit(TypeVisitor<T> visitor) {
                return visitor.visitUser();
            }
        };

        private static final Map<String, Type> TYPE_MAP;
        private String type;

        public abstract <T> T visit(TypeVisitor<T> var1);

        private Type(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static Type getByType(String type) {
            return TYPE_MAP.get(type);
        }

        static {
            TYPE_MAP = new HashMap<String, Type>(Type.values().length){
                {
                    for (Type type : Type.values()) {
                        this.put(type.getType(), type);
                    }
                }
            };
        }

        public static interface TypeVisitor<T> {
            public T visitRepository();

            public T visitProject();

            public T visitReview();

            public T visitSnippet();

            public T visitUser();
        }
    }
}

