/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.action.userlistgenerator;

import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.bucket.BreakdownOption;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketDataTotalled;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.user.action.UserData;
import com.atlassian.fisheye.user.action.view.PersonDO;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Timer;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserListGenerator {
    private static final Logger log = LoggerFactory.getLogger(UserListGenerator.class);
    private final UserManager userManager;
    private final Principal currentUser;
    private final List<RepositoryHandle> reps;
    private final ReviewManager reviewManager;
    private final ActivitySearchMonitor monitor;
    private final CommitterUserMappingManager committerMappingManager;
    private final HashMap<String, UserData> users = new HashMap();
    private CrossRepLuceneIndex crossRepLuceneIndex = AppConfig.getsConfig().getCrossRepLuceneIndex();
    private final boolean addLocToPeople;

    public UserListGenerator(ReviewManager reviewManager, UserManager userManager, CommitterUserMappingManager committerMappingManager, ActivitySearchMonitor monitor, Principal currentUser, List<RepositoryHandle> reps, boolean addLocToPeople) {
        this.reviewManager = reviewManager;
        this.monitor = monitor;
        this.currentUser = currentUser;
        this.reps = reps;
        this.committerMappingManager = committerMappingManager;
        this.userManager = userManager;
        this.addLocToPeople = addLocToPeople;
    }

    public List<PersonDO> getEveryone() throws RepositoryHandle.StateException {
        this.initUsersAndCommitters();
        return this.getAllPeople();
    }

    abstract List<PersonDO> getAllPeople();

    abstract void initUsersAndCommitters() throws DbException;

    public void completeUserData(List<PersonDO> people) throws Exception {
        this.users.clear();
        if (!people.isEmpty()) {
            this.updateUsersAndCommitters(people);
        }
        this.addCommitsToPeople();
        if (this.addLocToPeople) {
            this.addLocToPeople();
        }
        this.addReviewCountToPeople(this.users);
    }

    protected abstract void updateUsersAndCommitters(List<PersonDO> var1);

    Map<String, Object2IntMap<String>> getLocDataForCommittersByRep() throws RepositoryHandle.StateException, DbException {
        return this.getLocDataForCommittersByRep(null);
    }

    Map<String, Object2IntMap<String>> getLocDataForCommittersByRep(final String branch) throws RepositoryHandle.StateException, DbException {
        HashMap<String, Object2IntMap<String>> rep2CommitterLoc = new HashMap<String, Object2IntMap<String>>();
        for (RepositoryHandle rep : this.reps) {
            if (!this.userManager.hasPermissionToAccess(this.currentUser, rep)) continue;
            if (this.monitor.isTimeExceeded()) {
                this.monitor.setSearchTruncated(true);
                break;
            }
            Object2IntOpenHashMap repCommitterLoc = new Object2IntOpenHashMap();
            rep2CommitterLoc.put(rep.getName(), (Object2IntMap<String>)repCommitterLoc);
            if (!rep.isRunning() || !rep.getCfg().isAuthorLocEnabled()) continue;
            rep.withEngine(new Function<RepositoryEngine, Void>((Object2IntMap)repCommitterLoc){
                final /* synthetic */ Object2IntMap val$repCommitterLoc;
                {
                    this.val$repCommitterLoc = object2IntMap;
                }

                public Void apply(RepositoryEngine engine) {
                    BucketGraph bucketGraph = engine.getBucketGraph();
                    ParameterSetQuery params = new ParameterSetQuery();
                    params.setBreakdown(BreakdownOption.AUTHOR);
                    params.setPath(UserListGenerator.this.getPath());
                    if (!Strings.isNullOrEmpty((String)branch)) {
                        params.setBranch(branch);
                    }
                    BucketDataCollectionTotalled buckets = bucketGraph.getBuckets(params);
                    for (Map.Entry e2 : buckets.entrySet()) {
                        String name = (String)e2.getKey();
                        this.val$repCommitterLoc.put((Object)name, ((BucketDataTotalled)e2.getValue()).getTotalLoc());
                    }
                    return null;
                }
            });
        }
        return rep2CommitterLoc;
    }

    protected abstract Set<String> getUnmappedCommitters();

    abstract void addCommitsToPeople() throws DbException;

    abstract void addLocToPeople() throws RepositoryHandle.StateException, DbException;

    private void addReviewCountToPeople(Map<String, UserData> users) throws DbException {
        Timer timer = new Timer(this.getClass().getName() + ".addReviewCountToPeople");
        if (AppConfig.isCrucible() && (this.userManager.isCrucibleEnabled(this.currentUser.getUserName()) || this.currentUser == Principal.Anonymous.ANON && AppConfig.getsConfig().isCruAnonAccessAllowed())) {
            Object2LongMap<String> reviewCountByUser = this.reviewManager.getReviewCountForUsers(this.getPath(), this.getRepositoryName(), users.keySet());
            for (String user : reviewCountByUser.keySet()) {
                PersonDO p2 = users.get(user);
                if (p2 == null) continue;
                p2.setNumReviews((Long)reviewCountByUser.get((Object)user));
            }
        }
        timer.end();
    }

    abstract Path getPath();

    abstract String getRepositoryName();

    public UserManager getUserManager() {
        return this.userManager;
    }

    public Principal getCurrentUser() {
        return this.currentUser;
    }

    public List<RepositoryHandle> getReps() {
        return this.reps;
    }

    public ActivitySearchMonitor getMonitor() {
        return this.monitor;
    }

    public HashMap<String, UserData> getUsers() {
        return this.users;
    }

    public CommitterUserMappingManager getCommitterUserMappingManager() {
        return this.committerMappingManager;
    }

    public LuceneConnection<CrossRepLuceneIndexes> getCrossRepLuceneConnection() {
        return this.crossRepLuceneIndex.getConnection();
    }
}

