/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.action.userlistgenerator;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.user.action.UserData;
import com.atlassian.fisheye.user.action.userlistgenerator.UserListGenerator;
import com.atlassian.fisheye.user.action.view.PersonDO;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.csindex.ChangesetStatsCalculator;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.web.CommitterData;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.WaybackSpec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RepUserListGenerator
extends UserListGenerator {
    private final FishEyePathInfo pi;
    private WaybackSpec wbSpec;
    private final String branch;
    private final Path p;
    private final String repositoryName;
    private final HashMap<String, CommitterData> unmappedCommitters = new HashMap();
    private final HashMap<String, UserData> mappedCommitters = new HashMap();

    public RepUserListGenerator(ReviewManager reviewManager, UserManager userManager, CommitterUserMappingManager committerMappingManager, ActivitySearchMonitor monitor, Principal currentUser, FishEyePathInfo pi, List<RepositoryHandle> reps, boolean addLocToPeople) {
        super(reviewManager, userManager, committerMappingManager, monitor, currentUser, reps, addLocToPeople);
        this.pi = pi;
        this.repositoryName = pi.getRepname();
        this.p = pi.getLocalPath();
        this.wbSpec = WaybackSpec.fromPathInfo(pi);
        if (this.wbSpec == null) {
            this.wbSpec = new WaybackSpec();
        }
        this.branch = this.wbSpec.getBranch();
    }

    @Override
    List<PersonDO> getAllPeople() {
        LinkedList<PersonDO> people = new LinkedList<PersonDO>();
        people.addAll(this.unmappedCommitters.values());
        people.addAll(this.getUsers().values());
        return people;
    }

    @Override
    void initUsersAndCommitters() throws DbException {
        Timer timer = new Timer(this.getClass().getName() + ".initUsersAndCommitters");
        List<String> committers = this.pi.getEngine().getRevisionCache().findAuthors(this.p, this.branch);
        committers.remove("");
        while (!committers.isEmpty()) {
            String committer = committers.remove(0);
            FecruUser user = this.getCommitterUserMappingManager().getUserForCommitter(this.pi.getRepname(), committer);
            if (user == null) {
                this.unmappedCommitters.put(committer, new CommitterData(committer));
                continue;
            }
            UserData userData = this.getUsers().get(user.getUsername());
            if (userData == null) {
                userData = new UserData(user);
                this.getUsers().put(user.getUsername(), userData);
            }
            this.mappedCommitters.put(committer, userData);
        }
        timer.end();
    }

    @Override
    protected void updateUsersAndCommitters(List<PersonDO> people) {
        this.unmappedCommitters.clear();
        for (PersonDO person : people) {
            if (person instanceof CommitterData) {
                this.unmappedCommitters.put(person.getName(), (CommitterData)person);
                continue;
            }
            if (!(person instanceof UserData)) continue;
            this.getUsers().put(person.getName(), (UserData)person);
        }
        Iterator<Map.Entry<String, UserData>> iterator = this.mappedCommitters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, UserData> e2 = iterator.next();
            if (this.getUsers().containsKey(e2.getValue().getName())) continue;
            iterator.remove();
        }
    }

    @Override
    void addCommitsToPeople() throws DbException {
        Timer timer = new Timer(this.getClass().getName() + ".addCommitsToPeople");
        ChangesetStatsCalculator calculator = new ChangesetStatsCalculator(this.pi.getRepname(), this.branch, (List<String>)null, this.pi.getLocalPath());
        HashSet<String> allCommitters = new HashSet<String>();
        allCommitters.addAll(this.getUnmappedCommitters());
        allCommitters.addAll(this.mappedCommitters.keySet());
        Object2IntMap<String> commitsByCommitter = calculator.getCommitCount(this.getCrossRepLuceneConnection(), allCommitters);
        for (Object2IntMap.Entry e2 : commitsByCommitter.object2IntEntrySet()) {
            String committer = (String)e2.getKey();
            UserData userData = this.mappedCommitters.get(committer);
            CommitterData committerData = this.unmappedCommitters.get(committer);
            if (userData != null) {
                userData.setNumCommits((long)e2.getIntValue() + userData.getNumCommits());
                continue;
            }
            if (committerData == null) continue;
            committerData.setNumCommits(Long.valueOf(e2.getIntValue()));
        }
        timer.end();
    }

    @Override
    void addLocToPeople() throws RepositoryHandle.StateException, DbException {
        Map<String, Object2IntMap<String>> rep2CommitterLoc;
        Object2IntMap<String> result;
        Timer timer = new Timer(this.getClass().getName() + ".addLocToPeople");
        if (this.branch != null && (result = (rep2CommitterLoc = this.getLocDataForCommittersByRep(this.branch)).get(this.repositoryName)) != null) {
            for (Object2IntMap.Entry e2 : rep2CommitterLoc.get(this.repositoryName).object2IntEntrySet()) {
                String committer = (String)e2.getKey();
                int loc = e2.getIntValue();
                UserData userData = this.mappedCommitters.get(committer);
                CommitterData committerData = this.unmappedCommitters.get(committer);
                if (userData != null) {
                    userData.setLoc(userData.getLoc() + (long)loc);
                    continue;
                }
                if (committerData == null) continue;
                committerData.setLoc(Long.valueOf(loc));
            }
        }
        timer.end();
    }

    @Override
    Path getPath() {
        return this.p;
    }

    @Override
    String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    protected Set<String> getUnmappedCommitters() {
        return this.unmappedCommitters.keySet();
    }
}

