/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.action.userlistgenerator;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.user.action.UserData;
import com.atlassian.fisheye.user.action.userlistgenerator.UserListGenerator;
import com.atlassian.fisheye.user.action.view.PersonDO;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.csindex.ChangesetStatsCalculator;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Timer;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GlobalUserListGenerator
extends UserListGenerator {
    public GlobalUserListGenerator(ReviewManager reviewManager, UserManager userManager, CommitterUserMappingManager committerMappingManager, ActivitySearchMonitor monitor, Principal currentUser, List<RepositoryHandle> reps, boolean addLocToPeople) {
        super(reviewManager, userManager, committerMappingManager, monitor, currentUser, reps, addLocToPeople);
    }

    @Override
    List<PersonDO> getAllPeople() {
        return new LinkedList<PersonDO>(this.getUsers().values());
    }

    @Override
    void initUsersAndCommitters() throws DbException {
        Timer timer = new Timer(this.getClass().getName() + ".initUsersAndCommitters");
        this.getUserManager().getLicensedUsers().stream().forEach(user -> this.getUsers().put(user.getUsername(), new UserData((FecruUser)user)));
        timer.end();
    }

    @Override
    protected void updateUsersAndCommitters(List<PersonDO> people) {
        for (PersonDO person : people) {
            if (!(person instanceof UserData)) continue;
            this.getUsers().put(person.getName(), (UserData)person);
        }
    }

    @Override
    protected void addCommitsToPeople() throws DbException {
        Timer timer = new Timer(this.getClass().getName() + ".addCommitsToPeople");
        for (Map.Entry<String, UserData> entry : this.getUsers().entrySet()) {
            Multimap<String, String> committers = this.getCommitterUserMappingManager().getAllCommittersForUser(entry.getKey());
            ChangesetStatsCalculator calculator = new ChangesetStatsCalculator(committers);
            long count = calculator.count(this.getCrossRepLuceneConnection());
            entry.getValue().setNumCommits(count);
        }
        timer.end();
    }

    @Override
    protected void addLocToPeople() throws DbException, RepositoryHandle.StateException {
        Timer timer = new Timer(this.getClass().getName() + ".addLocToPeople");
        Map<String, Object2IntMap<String>> rep2CommitterLoc = this.getLocDataForCommittersByRep();
        for (Map.Entry<String, Object2IntMap<String>> entry : rep2CommitterLoc.entrySet()) {
            String repName = entry.getKey();
            for (Object2IntMap.Entry committerLoc : entry.getValue().object2IntEntrySet()) {
                UserData userData;
                String committer = (String)committerLoc.getKey();
                FecruUser user = this.getCommitterUserMappingManager().getUserForCommitter(repName, committer);
                if (user == null || (userData = this.getUsers().get(user.getUsername())) == null) continue;
                userData.setLoc(userData.getLoc() + (long)committerLoc.getIntValue());
            }
        }
        timer.end();
    }

    @Override
    Path getPath() {
        return null;
    }

    @Override
    String getRepositoryName() {
        return null;
    }

    @Override
    protected Set<String> getUnmappedCommitters() {
        return null;
    }
}

