/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.action;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.bucket.BreakdownOption;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketDataElement;
import com.atlassian.fisheye.bucket.BucketDataTotalled;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.atlassian.fisheye.user.RecentlyVisitedManager;
import com.atlassian.fisheye.user.action.BaseUserPageAction;
import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterDef;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.csindex.ChangesetStatsCalculator;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;

public class UserPageAction
extends BaseUserPageAction {
    @Resource
    private ReviewManager reviewManager;
    @Resource
    private RecentlyVisitedManager recentlyVisitedManager;
    private String name;
    private Date userFirstCommit;
    private Date userLastCommit;
    private long loc = 0L;
    private long totalFileRevisions = 0L;
    private long fileRevisionsThisWeek = 0L;
    private long locThisWeek = 0L;
    private long totalCommits;
    private long totalCommitsThisWeek;
    private boolean ajax;
    private int toReview;
    private int outForReview;
    private int toSummarize;
    private int open;
    private int closed;
    private int total;
    private Multimap<String, String> committers = ArrayListMultimap.create();
    private Multimap<String, String> implicitCommitters = ArrayListMultimap.create();
    private int numMappings;
    private int numReps;
    private Boolean hasVisibleCommitters = null;
    private boolean isLocEnabled;
    private FecruUser cruUser;

    @Override
    public String execute() throws Exception {
        FecruUser user = this.getFeUser();
        if (user == null) {
            ServletUtils.send404(this.getRequest(), this.getResponse(), "user " + this.getUserName() + " not found");
            return "none";
        }
        if (this.isCrucibleUser()) {
            ReviewFilters filter = new ReviewFilters(this.getCruUser());
            this.toReview = this.getCountForFilter(filter.getFilterDefByKey(ReviewFilters.FilterKey.TO_REVIEW));
            this.outForReview = this.getCountForFilter(filter.getFilterDefByKey(ReviewFilters.FilterKey.OUT_FOR_REVIEW));
            this.toSummarize = this.getCountForFilter(filter.getFilterDefByKey(ReviewFilters.FilterKey.TO_SUMMARIZE));
            this.open = this.getCountForFilter(filter.getFilterDefByKey(ReviewFilters.FilterKey.MY_COMPLETED));
            this.closed = this.getCountForFilter(filter.getFilterDefByKey(ReviewFilters.FilterKey.MY_CLOSED));
            this.total = this.getToReview() + this.getToSummarize() + this.getOutForReview();
        }
        if (this.isAjax()) {
            return "ajax";
        }
        this.collectAllStats();
        String result = super.execute();
        if ("success".equals(result) && "true".equals(this.getRequest().getParameter("RSS"))) {
            this.getActivityHandler();
            return "success-rss";
        }
        if ("success".equals(result) && "true".equals(this.getRequest().getParameter("activityAjax"))) {
            this.getActivityHandler();
            return "activity-ajax";
        }
        this.updateRecentlyViewedUsers();
        return result;
    }

    private void updateRecentlyViewedUsers() {
        Principal currentPrincipal = this.getCurrentPrincipal();
        if (!Principal.Anonymous.isAnon((Principal)currentPrincipal)) {
            FecruUser loggedInUser = this.userManager.getUserFor(currentPrincipal);
            this.recentlyVisitedManager.addItemToHistory(RecentlyVisitedItem.Type.USER, loggedInUser, this.getUserName());
        }
    }

    protected int getCountForFilter(ReviewFilterDef filterDef) {
        return this.reviewManager.getMatchingReviewCount(filterDef);
    }

    public int getToReview() {
        return this.toReview;
    }

    public int getOutForReview() {
        return this.outForReview;
    }

    public int getToSummarize() {
        return this.toSummarize;
    }

    public int getOpen() {
        return this.open;
    }

    public int getClosed() {
        return this.closed;
    }

    public int getTotal() {
        return this.total;
    }

    @Override
    protected String resolveTargetUser() {
        return this.name;
    }

    @Override
    protected ActivityItemSearchParams getActivityItemSearchParam(String view) {
        return ActivityItemSearchParams.Builder.fromParams(super.getActivityItemSearchParam(view)).user(this.resolveTargetUser()).build();
    }

    private void accumulateStats(BucketDataCollectionTotalled data, TimeZone tz) {
        int revisionsThisWeek = 0;
        int totalRevisions = 0;
        int loc = 0;
        int locThisWeek = 0;
        BucketDataTotalled bucketData = (BucketDataTotalled)data.getFirst();
        Int2ObjectSortedMap subBranchData = null;
        long subBranchId = 0L;
        if (bucketData != null && !bucketData.getData().isEmpty()) {
            subBranchId = bucketData.getSubBranches().firstLong();
            subBranchData = bucketData.getData(subBranchId);
        }
        if (subBranchData != null) {
            int today = PeriodUnit.DAY.dateToBucket(System.currentTimeMillis(), tz);
            for (Int2ObjectMap.Entry e2 : subBranchData.int2ObjectEntrySet()) {
                BucketDataElement bde = (BucketDataElement)e2.getValue();
                int bucket = e2.getIntKey();
                if (bucket > today - 7) {
                    revisionsThisWeek += bde.getRevcount();
                }
                totalRevisions += bde.getRevcount();
            }
            loc = bucketData.getCumulativeLocAtBucket(subBranchId, today);
            locThisWeek = loc - bucketData.getCumulativeLocAtBucket(subBranchId, today - 7);
        }
        this.loc += (long)loc;
        this.locThisWeek += (long)locThisWeek;
        this.fileRevisionsThisWeek += (long)revisionsThisWeek;
        this.totalFileRevisions += (long)totalRevisions;
    }

    private void collectAllStats() throws DbException {
        Principal currentUser = this.getCurrentPrincipal();
        ArrayList<ChangeSet> latestCommits = new ArrayList<ChangeSet>();
        ArrayList<ChangeSet> earliestCommits = new ArrayList<ChangeSet>();
        for (Map.Entry e2 : this.getRep2CommittersMap().asMap().entrySet()) {
            String rep = (String)e2.getKey();
            ImmutableList committers = ImmutableList.copyOf((Collection)((Collection)e2.getValue()));
            RepositoryHandle repHandle = this.repositoryManager.getRepository(rep);
            if (repHandle == null || !repHandle.isRunning() || !this.userManager.hasPermissionToAccess(currentUser, repHandle)) continue;
            try {
                RepositoryEngine engine = repHandle.acquireEngine();
                BucketGraph bucketGraph = engine.getBucketGraph();
                ParameterSetQuery queryParams = new ParameterSetQuery();
                queryParams.setAuthors((List<String>)committers);
                queryParams.setBreakdown(BreakdownOption.AUTHOR);
                BucketDataCollectionTotalled repData = bucketGraph.getBuckets(queryParams);
                if (repData.collectionCount() > 0) {
                    this.accumulateStats(repData, bucketGraph.getTimeZone());
                }
                this.accumulateChangesetStats(rep, engine, (List<String>)committers, bucketGraph.getTimeZone());
                this.accumulateCommitDateStats(latestCommits, earliestCommits, (List<String>)committers, engine);
            }
            catch (RepositoryHandle.StateException e1) {
                Logs.APP_LOG.warn((Object)("invalid repository handle state in UserPageAction for user " + this.getUserName()), (Throwable)((Object)e1));
            }
        }
        if (!latestCommits.isEmpty()) {
            Collections.sort(latestCommits, ChangeSet.COMPARE_TOWARDS_PAST);
            Collections.sort(earliestCommits, ChangeSet.COMPARE_TOWARDS_FUTURE);
            this.userFirstCommit = ((ChangeSet)earliestCommits.get(0)).getDateValue();
            this.userLastCommit = ((ChangeSet)latestCommits.get(0)).getDateValue();
        }
    }

    private void accumulateCommitDateStats(List<ChangeSet> latestCommits, List<ChangeSet> earliestCommits, List<String> committers, RepositoryEngine engine) throws DbException {
        RevisionCache<? extends ChangeSet> cache = engine.getRevisionCache();
        Map<String, ChangeSet> latestChangesByAuthor = cache.findLatestChangesByAuthor(Path.ROOT, committers);
        Map<String, ChangeSet> earlestChangeByAuthor = cache.findEarliestChangesByAuthor(Path.ROOT, committers);
        for (String committer : committers) {
            this.addIfFound(earliestCommits, earlestChangeByAuthor, committer);
            this.addIfFound(latestCommits, latestChangesByAuthor, committer);
        }
    }

    private void addIfFound(List<ChangeSet> commits, Map<String, ChangeSet> committerToCommits, String committer) {
        if (committerToCommits.containsKey(committer)) {
            commits.add(committerToCommits.get(committer));
        }
    }

    private void accumulateChangesetStats(String repName, RepositoryEngine engine, List<String> committers, TimeZone tz) throws DbException {
        ChangesetStatsCalculator calculator = new ChangesetStatsCalculator(engine.getName(), null, committers, Path.ROOT);
        LuceneConnection<CrossRepLuceneIndexes> luceneConnection = engine.getCrossRepLuceneConnection();
        this.totalCommits += calculator.count(luceneConnection);
        Calendar calendar = Calendar.getInstance(tz);
        calendar.add(3, -1);
        ActivityItemSearchParams.Builder builder = ActivityItemSearchParams.builder();
        builder.includeFisheye();
        builder.anyCommitters(new HashSet<String>(committers), repName);
        builder.timeZone(tz);
        builder.minDate(calendar.getTime());
        builder.maxItems(1);
        calculator = new ChangesetStatsCalculator(builder.build());
        this.totalCommitsThisWeek += calculator.count(luceneConnection);
    }

    public void setName(String name) {
        try {
            this.name = URLDecoder.decode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            Logs.APP_LOG.error((Object)"UTF-8 encode is not supported", (Throwable)e2);
            this.name = name;
        }
    }

    public Date getUserFirstCommit() {
        return this.userFirstCommit;
    }

    public Date getUserLastCommit() {
        return this.userLastCommit;
    }

    public long getLoc() {
        return this.loc;
    }

    public long getTotalFileRevisions() {
        return this.totalFileRevisions;
    }

    public long getFileRevisionsThisWeek() {
        return this.fileRevisionsThisWeek;
    }

    public long getLocThisWeek() {
        return this.locThisWeek;
    }

    public void setTotalCommits(long totalCommits) {
        this.totalCommits = totalCommits;
    }

    public void setTotalCommitsThisWeek(long totalCommitsThisWeek) {
        this.totalCommitsThisWeek = totalCommitsThisWeek;
    }

    public long getTotalCommits() {
        return this.totalCommits;
    }

    public long getTotalCommitsThisWeek() {
        return this.totalCommitsThisWeek;
    }

    public void setAjax(String ajax) {
        this.ajax = !Strings.isNullOrEmpty((String)ajax);
    }

    public boolean isAjax() {
        return this.ajax;
    }

    @Override
    public ActivitySearchMonitor getActivitySearchMonitor() {
        return new ActivitySearchMonitor();
    }

    public boolean getUseGraphael() {
        return false;
    }

    @RequireSecurityToken(value=false)
    public String initThenExecute() throws Exception {
        this.username = this.resolveTargetUser();
        if (this.username != null && this.getFeUser() != null) {
            FecruUser user = this.getFeUser();
            this.committers = this.retainRepositoryMappings(this.committerUserMappingManager.getExplicitCommittersForUser(user));
            this.implicitCommitters = this.retainRepositoryMappings(this.committerUserMappingManager.getImplicitCommittersForUser(user));
            this.numMappings = 0;
            HashSet<String> fromReps = new HashSet<String>();
            for (Map.Entry entry : this.implicitCommitters.asMap().entrySet()) {
                this.numMappings += ((Collection)entry.getValue()).size();
                fromReps.add((String)entry.getKey());
            }
            for (Map.Entry entry : this.committers.asMap().entrySet()) {
                this.numMappings += ((Collection)entry.getValue()).size();
                fromReps.add((String)entry.getKey());
            }
            this.numReps = fromReps.size();
            this.isLocEnabled = this.calcIsLocEnabled(fromReps);
        }
        return this.execute();
    }

    private Multimap<String, String> retainRepositoryMappings(Multimap<String, String> mappings) {
        HashMultimap active = HashMultimap.create();
        for (Map.Entry mapping : mappings.asMap().entrySet()) {
            String repoName = (String)mapping.getKey();
            RepositoryHandle repositoryHandle = this.repositoryManager.getRepository(repoName);
            if (repositoryHandle == null || !RepositoryUtil.hasPermission(this.getCurrentPrincipal(), repositoryHandle)) continue;
            active.putAll((Object)repoName, (Iterable)mapping.getValue());
        }
        return active;
    }

    public Multimap<String, String> getRep2CommittersMap() {
        ArrayListMultimap allCommitters = ArrayListMultimap.create();
        allCommitters.putAll(this.committers);
        allCommitters.putAll(this.implicitCommitters);
        return allCommitters;
    }

    public Map<String, Collection<String>> getCommitters() {
        return this.committers.asMap();
    }

    public Map<String, Collection<String>> getImplicitCommitters() {
        return this.implicitCommitters.asMap();
    }

    public boolean getHasVisibleCommitters() {
        if (this.hasVisibleCommitters == null) {
            final HashSet reps = new HashSet(this.committers.size() + this.implicitCommitters.size());
            reps.addAll(this.committers.keySet());
            reps.addAll(this.implicitCommitters.keySet());
            final AtomicReference<Boolean> hasMappedRepo = new AtomicReference<Boolean>(false);
            this.repositoryManager.visitAccessibleRepositories(new StoppableVisitor<RepositoryHandle>(){

                @Override
                public boolean visit(RepositoryHandle repositoryHandle) {
                    if (reps.contains(repositoryHandle.getName())) {
                        hasMappedRepo.set(true);
                        return false;
                    }
                    return true;
                }
            });
            this.hasVisibleCommitters = hasMappedRepo.get();
        }
        return this.hasVisibleCommitters;
    }

    public void setNumMappings(int numMappings) {
        this.numMappings = numMappings;
    }

    public int getNumMappings() {
        return this.numMappings;
    }

    public void setNumReps(int numReps) {
        this.numReps = numReps;
    }

    public int getNumReps() {
        return this.numReps;
    }

    public boolean calcIsLocEnabled(Set<String> fromReps) {
        for (String repName : fromReps) {
            RepositoryHandle rep = this.repositoryManager.getRepository(repName);
            if (!rep.isRunning() || !rep.getCfg().isLocEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean isLocEnabled() {
        return this.isLocEnabled;
    }

    protected boolean isCrucibleUser() throws DbException {
        String userName = this.getUserName();
        return AppConfig.isCrucible() && userName != null && this.globalPermissionService.hasUserPermissions(userName, GlobalPermissionType.CRUCIBLE_USER);
    }

    public FecruUser getCruUser() {
        if (this.cruUser == null) {
            try {
                this.cruUser = this.crucibleUserManager.findUserByName(this.getUserName());
            }
            catch (DbException e2) {
                Logs.APP_LOG.error((Object)"Error retrieving Crucible user", (Throwable)e2);
            }
        }
        return this.cruUser;
    }
}

