/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.action;

import com.atlassian.fecru.exception.RepositoryNotFoundException;
import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.branch.BranchPreferenceHandler;
import com.atlassian.fisheye.user.action.UserData;
import com.atlassian.fisheye.user.action.userlistgenerator.GlobalUserListGenerator;
import com.atlassian.fisheye.user.action.userlistgenerator.RepUserListGenerator;
import com.atlassian.fisheye.user.action.userlistgenerator.UserListGenerator;
import com.atlassian.fisheye.user.action.view.PersonDO;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.user.UserSearchCriteria;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.FisheyeRepositoryExplorer;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.RepositoryAction;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.SortableListAction;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.dirtree.DirTreeViewParamsImpl;
import com.cenqua.fisheye.web.paging.PagingCalculator;
import com.cenqua.fisheye.web.paging.TotalCountAwarePagingCalculator;
import com.cenqua.fisheye.web.parameterbeans.BaseActionParams;
import com.cenqua.fisheye.web.parameterbeans.DirTreeViewParams;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.webwork.interceptor.ServletResponseAware;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UserListAction
extends SortableListAction
implements ServletRequestAware,
ServletResponseAware {
    private static final String NOTFOUND = "PATH_NOT_FOUND";
    private HttpServletRequest request;
    private FishEyePathInfo pi = new FishEyePathInfo((String)null);
    private List<PersonDO> peopleList;
    private boolean showUserLoc = false;
    private DirTreeViewParams dirTreeViewParams;
    private BaseActionParams baseParams;
    private PagingCalculator pagingData;
    private WaybackSpec waybackSpec;
    private Principal currentUser;
    private List<RepositoryHandle> reps;
    @Resource
    private UserManager userManager;
    @Resource
    private LicenseManager licenseManager;
    private HttpServletResponse response;
    @Resource
    private RootConfig rootConfig;
    @Resource
    private BranchPreferenceHandler branchPreferenceHandler;
    @Resource
    private ReviewManager reviewManager;
    @Resource
    private CommitterUserMappingManager committerMappingManager;

    private boolean isAllowUserListsAnon() {
        return this.rootConfig.getConfig().getSecurity().getAllowUserListsAnon();
    }

    private boolean isEnableUserLists() {
        return this.rootConfig.getConfig().getSecurity().getEnableUserLists();
    }

    protected WaybackSpec parseWaybackSpec(FishEyePathInfo pi) {
        WaybackSpec wbSpec = WaybackSpec.fromPathInfo(pi);
        return wbSpec != null ? wbSpec : new WaybackSpec();
    }

    @RequireSecurityToken(value=false)
    public String doList() throws Exception {
        Path p2;
        CookiePreferences preferences;
        this.monitor = new ActivitySearchMonitor(Long.valueOf(this.timeout));
        this.waybackSpec = this.parseWaybackSpec(this.pi);
        this.currentUser = this.userManager.getCurrentUser(this.request);
        if (this.currentUser == null) {
            this.currentUser = Principal.Anonymous.ANON;
        }
        if (this.handleWaybackJump("/users", preferences = PreferenceManager.getPreferences(this.request))) {
            return "none";
        }
        if (this.isEnableUserLists() && this.currentUser.equals(Principal.Anonymous.ANON) && !this.isAllowUserListsAnon()) {
            return "login";
        }
        String repositoryName = this.pi.getRepname();
        Path path = p2 = this.pi.isEmpty() ? Path.ROOT : this.pi.getLocalPath();
        if (!this.pi.isEmpty()) {
            if (AppConfig.isCrucibleOnly()) {
                return "404";
            }
            try {
                RepositoryHandle h2 = this.getRepositoryHandle(repositoryName);
                RepositoryEngine engine = h2.acquireEngine();
                if (this.handleSvnConflictingBranches(engine)) {
                    return "none";
                }
                this.reps = Collections.singletonList(h2);
                this.baseParams = new BaseActionParams(repositoryName, preferences);
                FisheyeRepositoryExplorer explorer = new FisheyeRepositoryExplorer(engine, this.pi.getLocalPath(), this.waybackSpec, preferences);
                this.dirTreeViewParams = new DirTreeViewParamsImpl(explorer, p2);
            }
            catch (RepositoryAction.RepositoryPermissionException rpe) {
                this.addActionError("You do not have permission to access the repository '" + repositoryName + "'");
                return NOTFOUND;
            }
            catch (RepositoryNotFoundException e2) {
                String message = "FishEye could not find the repository '" + repositoryName + "'.";
                Logs.APP_LOG.debug((Object)message, (Throwable)e2);
                this.addActionError(message);
                return NOTFOUND;
            }
        } else {
            this.reps = RepositoryUtil.repositories(this.currentUser);
        }
        if (!this.pi.isEmpty()) {
            this.pi.initEngine(this.reps.get(0));
            if (!this.pi.pathExists()) {
                return NOTFOUND;
            }
        }
        if (!this.isEnableUserLists()) {
            this.pagingData = TotalCountAwarePagingCalculator.getPagingCalculator(this.request, 0);
            this.addActionError("User listings have been disabled. Please contact your administrator for more details.");
            return "success";
        }
        if (!this.showUserLoc && this.waybackSpec.getBranchOrTag() != null) {
            for (RepositoryHandle rep : this.reps) {
                if (!rep.isRunning() || !rep.getCfg().isAuthorLocEnabled()) continue;
                this.showUserLoc = true;
                break;
            }
        }
        this.peopleList = this.getPeopleData();
        return "success";
    }

    private boolean handleSvnConflictingBranches(RepositoryEngine engine) throws DbException, IOException {
        HttpServletRequest req = this.getRequest();
        if (req.getParameter("brjump") != null) {
            String queryString = req.getQueryString();
            queryString = WaybackSpec.removeParamFromQueryString("brjump", queryString);
            StringBuilder urlBuilder = new StringBuilder();
            String pathUrl = RepositoryUtil.getPhysicalPathUrl(this.pi.getLocalPath(), this.waybackSpec, engine, this.pi.getRepname(), queryString);
            urlBuilder.append(req.getContextPath()).append("/users").append(pathUrl);
            this.getResponse().sendRedirect(urlBuilder.toString());
            return true;
        }
        return false;
    }

    private List<PersonDO> getPeopleData() throws Exception {
        List<PersonDO> people;
        UserListGenerator userListGenerator = this.pi.isEmpty() ? new GlobalUserListGenerator(this.reviewManager, this.userManager, this.committerMappingManager, this.monitor, this.currentUser, this.reps, this.showUserLoc) : new RepUserListGenerator(this.reviewManager, this.userManager, this.committerMappingManager, this.monitor, this.currentUser, this.pi, this.reps, this.showUserLoc);
        if (this.pi.isEmpty()) {
            int numActiveUsers = this.licenseManager.getLicensedUsersCount();
            this.pagingData = TotalCountAwarePagingCalculator.getPagingCalculator(this.request, numActiveUsers);
            Page<FecruUser> usersPage = this.userManager.searchUsers(UserSearchCriteria.create().withPermissions(LicenseManager.getLicensedGlobalPermissionType()), this.pagingData.createPageRequest());
            people = new ArrayList<PersonDO>(this.pagingData.getNumPerPage());
            Iterables.addAll(people, (Iterable)Iterables.transform((Iterable)usersPage.getValues(), UserData::new));
        } else {
            people = userListGenerator.getEveryone();
            this.sort(people);
            this.pagingData = TotalCountAwarePagingCalculator.getPagingCalculator(this.request, people.size());
            people = people.subList(this.pagingData.getCurrentPageStart(), this.pagingData.getCurrentPageEnd());
        }
        userListGenerator.completeUserData(people);
        return people;
    }

    public void setP(String p2) {
        this.pi = new FishEyePathInfo(ServletUtils.decodeString(p2));
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public List<PersonDO> getPeopleList() {
        return this.peopleList;
    }

    public FishEyePathInfo getPi() {
        return this.pi;
    }

    private void setPi(FishEyePathInfo pi) {
        this.pi = pi;
    }

    public WaybackSpec getWaybackSpec() {
        return this.waybackSpec;
    }

    public boolean getShowUserLoc() {
        return this.showUserLoc;
    }

    public PagingCalculator getPagingCalculator() {
        return this.pagingData;
    }

    public DirTreeViewParams getDirTreeViewParams() {
        return this.dirTreeViewParams;
    }

    public BaseActionParams getBaseParams() {
        return this.baseParams;
    }

    public String getRepositoryName() {
        return this.pi.getRepname();
    }

    protected boolean handleWaybackJump(String mmodeUrl, CookiePreferences preferences) throws IOException {
        HttpServletRequest req = this.getRequest();
        this.branchPreferenceHandler.handleLastSelectedBranch(preferences, req, this.pi.getRepname());
        if (req.getParameter("wbjump") != null) {
            WaybackSpec wbSpec = WaybackSpec.fromRequest(req, this.waybackSpec);
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(req.getContextPath()).append(mmodeUrl).append(wbSpec.getUrlCommand()).append("/").append(this.pi.getFullPath().getAsUrl());
            String queryString = req.getQueryString();
            if (!Strings.isNullOrEmpty((String)queryString)) {
                queryString = wbSpec.removeWbFromQueryString(queryString);
            }
            if (!Strings.isNullOrEmpty((String)req.getParameter("brjump"))) {
                queryString = !Strings.isNullOrEmpty((String)(queryString = WaybackSpec.removeParamFromQueryString("brjump", queryString))) ? queryString + "&" : "";
                queryString = queryString + "brjump=" + req.getParameter("brjump");
            }
            if (!Strings.isNullOrEmpty((String)queryString)) {
                urlBuilder.append("?").append(queryString);
            }
            this.getResponse().sendRedirect(urlBuilder.toString());
            return true;
        }
        return false;
    }

    public boolean isShowCommitGraph() {
        return this.baseParams.getRepositoryConfig().isSupportsCommitGraph();
    }
}

