/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.action;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.user.action.view.PersonDO;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class UserData
extends PersonDO {
    public static final Function<FecruUser, UserData> USER_TO_USER_DATA = new Function<FecruUser, UserData>(){

        public UserData apply(FecruUser input) {
            Preconditions.checkNotNull((Object)input);
            return new UserData(input);
        }
    };
    private FecruUser currentUser;

    public UserData(FecruUser user, long loc, long numReviews, long numCommits) {
        super(user.getDisplayName(), (Long)loc, (Long)numCommits, numReviews);
        this.currentUser = user;
    }

    public UserData(String userName) {
        super(userName, (Long)0L, (Long)0L, 0L);
    }

    public UserData(FecruUser user) {
        this(user.getUsername());
        this.currentUser = user;
    }

    @Override
    public boolean isRepresentingCommitter() {
        return false;
    }

    @Override
    public String getDisplayName() {
        String displayName = this.currentUser.getDisplayName();
        if (Strings.isNullOrEmpty((String)displayName)) {
            displayName = this.currentUser.getUsername();
        }
        return displayName;
    }

    @Override
    public boolean isRepresentingUser() {
        return true;
    }

    public void setUser(FecruUser user) {
        this.currentUser = user;
    }

    @Override
    public FecruUser getUser() {
        return this.currentUser;
    }
}

