/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.action;

import com.atlassian.fecru.analytics.AnalyticsEvent;
import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.user.action.BaseUserPageAction;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.view.ReviewsToDo;
import com.cenqua.fisheye.user.UserLogin;
import org.springframework.beans.factory.annotation.Autowired;

public class UserDashboardAction
extends BaseUserPageAction {
    private ReviewManager reviewManager;
    private CurrentUserPermissions currentUserPermissions;
    private ReviewsToDo reviewsTodo;
    public static final int TODO_PANEL_NUM_REVIEWS = 10;
    private String requestType = "normal";

    @Autowired
    public void setReviewManager(ReviewManager reviewManager) {
        this.reviewManager = reviewManager;
    }

    @Autowired
    public void setCurrentUserPermissions(CurrentUserPermissions currentUserPermissions) {
        this.currentUserPermissions = currentUserPermissions;
    }

    @Override
    public String execute() throws Exception {
        if (Principal.Anonymous.isAnon((Principal)this.effectiveUserProvider.getEffectivePrincipal())) {
            return "login";
        }
        this.setFeUser(this.effectiveUserProvider.getEffectiveUser());
        String result = super.execute();
        if ("success".equals(result) && "true".equals(this.getRequest().getParameter("RSS"))) {
            this.requestType = "rss";
            this.getActivityHandler();
            return "success-rss";
        }
        if ("success".equals(result) && "true".equals(this.getRequest().getParameter("activityAjax"))) {
            this.requestType = "ajax";
            this.getActivityHandler();
            return "activity-ajax";
        }
        this.eventPublisher.publish((Object)new AnalyticsEvent("fecru.view.dashboard"));
        return result;
    }

    @Override
    protected ActivityItemSearchParams getActivityItemSearchParam(String view) {
        ActivityItemSearchParams.Builder param = ActivityItemSearchParams.Builder.fromParams(super.getActivityItemSearchParam(view));
        if (this.requestType.equals("normal")) {
            param.maxItems(0);
        }
        return param.downstream().build();
    }

    @Override
    protected String resolveTargetUser() {
        UserLogin userLogin = this.effectiveUserProvider.getEffectiveUserLogin();
        if (userLogin != null) {
            return userLogin.getUserName();
        }
        return null;
    }

    public ReviewsToDo getReviewsToDo() {
        if (this.reviewsTodo == null) {
            this.reviewsTodo = ReviewsToDo.forCurrentUser(this.effectiveUserProvider, this.currentUserPermissions, this.reviewManager, 10);
        }
        return this.reviewsTodo;
    }

    @RequireSecurityToken(value=false)
    public String initThenExecute() throws Exception {
        return this.execute();
    }
}

