/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.action;

import com.atlassian.crucible.spi.services.GlobalPermissionService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.user.UserProfileManager;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivityRequestConstants;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.activity.ActivityStreamHandler;
import com.atlassian.fisheye.activity.ActivityStreamTabViewParams;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.PreferenceManager;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.webwork.interceptor.ServletResponseAware;
import com.opensymphony.xwork.ActionSupport;
import java.io.IOException;
import java.util.TimeZone;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseUserPageAction
extends ActionSupport
implements ServletRequestAware,
ServletResponseAware {
    @Resource
    protected CrucibleUserManager crucibleUserManager;
    @Resource
    protected UserManager userManager;
    @Resource
    protected EffectiveUserProvider effectiveUserProvider;
    @Resource
    protected CommitterUserMappingManager committerUserMappingManager;
    @Resource
    protected RepositoryManager repositoryManager;
    @Resource
    protected EventPublisher eventPublisher;
    @Resource
    protected GlobalPermissionService globalPermissionService;
    protected String username;
    private HttpServletResponse response;
    private HttpServletRequest request;
    private ActivityStreamHandler activityHandler;
    private boolean RSS = false;
    private long timeout = ActivityRequestConstants.DEFAULT_TIMEOUT_SHORT;
    private ActivitySearchMonitor activitySearchMonitor;
    @Resource
    private CommitterUserMappingManager commmitterUserMappingManager;
    private FecruUser feUser;

    public boolean isRSS() {
        return this.RSS;
    }

    public void setRSS(boolean RSS) {
        this.RSS = RSS;
    }

    public String execute() throws Exception {
        return super.execute();
    }

    protected abstract String resolveTargetUser();

    private ActivityStreamHandler computeActivityStream() throws IOException, ServletException {
        ActivityStreamHandler handler = new ActivityStreamHandler(this.globalPermissionService, this.repositoryManager, null, null, null, false, false, this.getActivitySearchMonitor(), this.commmitterUserMappingManager);
        String view = this.getView();
        handler.handleActivityStream(this.getRequest(), this.getResponse(), this.getActivityItemSearchParam(view), this.getCurrentPrincipal(), this.getUserProfile().getChangesetsPerPage(), view, false);
        return handler;
    }

    private String getView() {
        String view = this.getRequest().getParameter("view");
        return view == null ? PreferenceManager.getPreference(this.request, "activityStreamView") : view;
    }

    private UserProfile getUserProfile() {
        FecruUser user = this.effectiveUserProvider.getEffectiveUser();
        return user != null ? user.getUserProfile() : UserProfileManager.DEFAULT_PROFILE;
    }

    protected ActivityItemSearchParams getActivityItemSearchParam(String view) {
        TimeZone timezone = AppConfig.getsConfig().getTimezone();
        return ActivityStreamHandler.constructSearchParams(this.getRequest(), this.getUserProfile().getChangesetsPerPage(), timezone, view);
    }

    protected Principal getCurrentPrincipal() {
        return this.effectiveUserProvider.getEffectivePrincipal();
    }

    public ActivityStreamHandler getActivityHandler() throws IOException, ServletException {
        if (this.activityHandler == null) {
            this.activityHandler = this.computeActivityStream();
        }
        this.request.setAttribute("activityStreamHandler", (Object)this.activityHandler);
        return this.activityHandler;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public ActivitySearchMonitor getActivitySearchMonitor() {
        if (this.activitySearchMonitor == null) {
            this.activitySearchMonitor = new ActivitySearchMonitor(this.timeout);
        }
        return this.activitySearchMonitor;
    }

    public ActivityStreamTabViewParams getTabViewParams() throws ServletException {
        String view = this.getView();
        return ActivityStreamTabViewParams.create(this.request, this.getUserProfile().getChangesetsPerPage(), this.getView(), this.getActivityItemSearchParam(view), false);
    }

    public String getUserName() {
        return this.username;
    }

    public FecruUser getFeUser() {
        if (this.feUser == null) {
            try {
                this.feUser = this.userManager.getLicensedUser(this.getUserName());
            }
            catch (DbException e2) {
                Logs.APP_LOG.error((Object)"Error retrieving FishEye user", (Throwable)e2);
            }
        }
        return this.feUser;
    }

    protected void setFeUser(FecruUser user) {
        this.feUser = user;
        this.username = user.getUsername();
    }
}

