/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.action;

import com.atlassian.crucible.spi.services.GlobalPermissionService;
import com.atlassian.fecru.user.UserProfileManager;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivityRequestConstants;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.activity.ActivityStreamHandler;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.PreferenceManager;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.webwork.interceptor.ServletResponseAware;
import com.opensymphony.xwork.ActionSupport;
import java.io.IOException;
import java.util.TimeZone;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class AnonHomePageAction
extends ActionSupport
implements ServletRequestAware,
ServletResponseAware {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ActivityStreamHandler activityHandler;
    private ActivitySearchMonitor activitySearchMonitor;
    private long timeout = ActivityRequestConstants.DEFAULT_TIMEOUT_SHORT;
    @Autowired
    protected TxTemplate txTemplate;
    @Resource
    private UserManager userManager;
    @Resource
    private RepositoryManager repositoryManager;
    @Resource
    private CommitterUserMappingManager commmitterUserMappingManager;
    @Resource
    private GlobalPermissionService globalPermissionService;

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        if (!Principal.Anonymous.isAnon((Principal)this.txTemplate.getEffectivePrincipal())) {
            return "loggedIn";
        }
        String result = super.execute();
        if ("success".equals(result) && "true".equals(this.getRequest().getParameter("RSS"))) {
            this.getActivityHandler();
            return "success-rss";
        }
        if ("success".equals(result) && "true".equals(this.getRequest().getParameter("activityAjax"))) {
            this.getActivityHandler();
            return "activity-ajax";
        }
        return result;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ActivityStreamHandler getActivityHandler() throws IOException, ServletException {
        if (this.activityHandler == null) {
            this.activityHandler = this.computeActivityStream();
        }
        return this.activityHandler;
    }

    private ActivityStreamHandler computeActivityStream() throws IOException, ServletException {
        ActivityStreamHandler handler = new ActivityStreamHandler(this.globalPermissionService, this.repositoryManager, null, null, null, false, false, this.getActivitySearchMonitor(), this.commmitterUserMappingManager);
        String view = this.getRequest().getParameter("view");
        view = view == null ? PreferenceManager.getPreference(this.request, "activityStreamView") : view;
        handler.handleActivityStream(this.getRequest(), this.getResponse(), this.getActivityItemSearchParam(view), (Principal)Principal.Anonymous.ANON, UserProfileManager.DEFAULT_PROFILE.getChangesetsPerPage(), view, false);
        return handler;
    }

    protected ActivityItemSearchParams getActivityItemSearchParam(String view) {
        TimeZone timezone = AppConfig.getsConfig().getTimezone();
        return ActivityStreamHandler.constructSearchParams(this.getRequest(), UserProfileManager.DEFAULT_PROFILE.getChangesetsPerPage(), timezone, view);
    }

    public ActivitySearchMonitor getActivitySearchMonitor() {
        if (this.activitySearchMonitor == null) {
            this.activitySearchMonitor = new ActivitySearchMonitor(this.timeout);
        }
        return this.activitySearchMonitor;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

