/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user;

import com.atlassian.crucible.resource.ThreadPool;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.event.UserRenamedEvent;
import com.atlassian.fisheye.user.RecentlyVisitedManager;
import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.atlassian.fisheye.user.model.RecentlyVisitedItemFactory;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@AvailableToPlugins
@Service(value="userHistoryManager")
public class DefaultRecentlyVisitedManager
implements RecentlyVisitedManager {
    private static int HISTORY_TYPE_MAX_COUNT = 5;
    private final Executor executor;
    private final CurrentSessionProvider currentSessionProvider;
    private Map<RecentlyVisitedItem.Type, RecentlyVisitedItemFactory> factories = new HashMap<RecentlyVisitedItem.Type, RecentlyVisitedItemFactory>();
    private final EventPublisher eventPublisher;

    @Autowired
    public DefaultRecentlyVisitedManager(ThreadPool threadPool, CurrentSessionProvider currentSessionProvider, EventPublisher eventPublisher) {
        this(threadPool.getExecutor(), currentSessionProvider, eventPublisher);
    }

    @VisibleForTesting
    public DefaultRecentlyVisitedManager(Executor executor, CurrentSessionProvider currentSessionProvider, EventPublisher eventPublisher) {
        this.currentSessionProvider = currentSessionProvider;
        this.executor = executor;
        this.eventPublisher = eventPublisher;
    }

    @Autowired
    public void setFactories(RecentlyVisitedItemFactory[] factoryArray) {
        for (RecentlyVisitedItemFactory f2 : factoryArray) {
            this.factories.put(f2.getType(), f2);
        }
    }

    @PostConstruct
    public void registerListener() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void unregisterListener() {
        this.eventPublisher.unregister((Object)this);
    }

    public RecentlyVisitedItemFactory getFactory(RecentlyVisitedItem.Type type) {
        RecentlyVisitedItemFactory f2 = this.factories.get((Object)type);
        if (f2 == null) {
            throw new RuntimeException("No such history type '" + (Object)((Object)type) + "'");
        }
        return f2;
    }

    private RecentlyVisitedItemFactory getFactory(String type) {
        return this.getFactory(RecentlyVisitedItem.Type.getByType(type));
    }

    @Override
    public void addItemToHistory(RecentlyVisitedItem.Type type, FecruUser user, int entityId) {
        this.addItemToHistory(type, user, String.valueOf(entityId));
    }

    @Override
    public void addItemToHistory(final RecentlyVisitedItem.Type type, final FecruUser user, final String entityId) {
        if (Strings.isNullOrEmpty((String)entityId) || type == null || user == null) {
            throw new IllegalArgumentException("entityId, type and user must all be present: " + (Object)((Object)type) + ", " + user + ", " + entityId);
        }
        final String username = user.getUsername();
        final long lastViewed = System.currentTimeMillis();
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List items = DefaultRecentlyVisitedManager.this.getUnfilteredHistory(type, username);
                try {
                    int i2 = 1;
                    HibernateUtil.beginTransaction();
                    RecentlyVisitedItem<Object> historyItem = DefaultRecentlyVisitedManager.this.getHistoryItem(type, user, entityId);
                    if (historyItem == null) {
                        for (RecentlyVisitedItem item : items) {
                            if (i2 >= HISTORY_TYPE_MAX_COUNT) {
                                DefaultRecentlyVisitedManager.this.session().delete((Object)item);
                            }
                            ++i2;
                        }
                        historyItem = DefaultRecentlyVisitedManager.this.getFactory(type).createItem(username, entityId, lastViewed);
                    } else {
                        historyItem.setLastViewed(lastViewed);
                    }
                    if (historyItem != null) {
                        DefaultRecentlyVisitedManager.this.session().saveOrUpdate((Object)historyItem);
                    }
                    HibernateUtil.commitTransaction();
                }
                catch (HibernateException e2) {
                    if (!(e2 instanceof ConstraintViolationException)) {
                        Logs.APP_LOG.error((Object)("Could not add history item " + entityId + " type " + (Object)((Object)type) + " for user " + user.getUsername()), (Throwable)e2);
                    }
                }
                finally {
                    HibernateUtil.rollbackTransactionIfNotCommitted();
                    HibernateUtil.closeSession();
                }
            }
        });
    }

    private <T extends RecentlyVisitedItem> void loadHistory(List<T> historyItems, Principal principal) {
        Iterator<T> it = historyItems.iterator();
        while (it.hasNext()) {
            RecentlyVisitedItem item = (RecentlyVisitedItem)it.next();
            this.getFactory(item.getEntityType()).load(item, principal);
            if (item.getEntity() != null) continue;
            it.remove();
        }
    }

    @Override
    public <T extends RecentlyVisitedItem> List<T> getHistory(RecentlyVisitedItem.Type type, Principal principal) {
        return this.getLoadedHistory(type, principal);
    }

    private <T extends RecentlyVisitedItem> List<T> getUnfilteredHistory(RecentlyVisitedItem.Type type, String username) {
        Query q2 = this.session().createQuery("from RecentlyVisitedItem where username = :username and entityType = :entityType order by lastViewed desc");
        q2.setString("username", UserManager.USERNAME_NORMALIZATION.apply(username));
        q2.setString("entityType", type.getType());
        return q2.list();
    }

    private <T extends RecentlyVisitedItem> List<T> getLoadedHistory(RecentlyVisitedItem.Type type, Principal principal) {
        List<T> history = this.getUnfilteredHistory(type, principal.getUserName());
        this.loadHistory(history, principal);
        return history;
    }

    @Override
    public <T extends RecentlyVisitedItem> List<T> getAllHistory(String username) {
        Query q2 = this.session().createQuery("from RecentlyVisitedItem where username = :username order by lastViewed desc");
        q2.setString("username", UserManager.USERNAME_NORMALIZATION.apply(username));
        return q2.list();
    }

    private RecentlyVisitedItem getHistoryItem(RecentlyVisitedItem.Type type, FecruUser user, String entityId) {
        Query q2 = this.session().createQuery("from RecentlyVisitedItem where username = :username and entityType = :entityType and entityId = :entityId");
        q2.setString("username", UserManager.USERNAME_NORMALIZATION.apply(user.getUsername()));
        q2.setString("entityType", type.getType());
        q2.setString("entityId", entityId);
        return (RecentlyVisitedItem)q2.uniqueResult();
    }

    @Override
    public void removeHistoryForUser(String username) {
        try {
            HibernateUtil.beginTransaction();
            Query q2 = this.session().createQuery("delete from RecentlyVisitedItem where username = :username");
            q2.setString("username", UserManager.USERNAME_NORMALIZATION.apply(username));
            q2.executeUpdate();
            HibernateUtil.commitTransaction();
            this.session().flush();
        }
        catch (HibernateException e2) {
            Logs.APP_LOG.error((Object)("Could not remove history for user " + username), (Throwable)e2);
        }
        finally {
            HibernateUtil.rollbackTransactionIfNotCommitted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onUserRenamedEvent(UserRenamedEvent userRenamedEvent) {
        String normalizedOldUsername = UserManager.USERNAME_NORMALIZATION.apply(userRenamedEvent.getOldUsername());
        String normalizedNewUsername = UserManager.USERNAME_NORMALIZATION.apply(userRenamedEvent.getNewUsername());
        try {
            HibernateUtil.beginTransaction();
            Query q2 = this.session().createQuery("delete RecentlyVisitedItem where username = :newUsername");
            q2.setString("newUsername", normalizedNewUsername);
            q2.executeUpdate();
            q2 = this.session().createQuery("delete RecentlyVisitedItem where entityId = :newUsername and entityType = :userType");
            q2.setString("newUsername", normalizedNewUsername);
            q2.setString("userType", RecentlyVisitedItem.Type.USER.getType());
            q2.executeUpdate();
            q2 = this.session().createQuery("update RecentlyVisitedItem set username = :newUsername where username = :oldUsername");
            q2.setString("newUsername", normalizedNewUsername);
            q2.setString("oldUsername", normalizedOldUsername);
            q2.executeUpdate();
            q2 = this.session().createQuery("update RecentlyVisitedItem set entityId = :newUsername where entityId = :oldUsername and entityType = :userType");
            q2.setString("newUsername", normalizedNewUsername);
            q2.setString("oldUsername", normalizedOldUsername);
            q2.setString("userType", RecentlyVisitedItem.Type.USER.getType());
            q2.executeUpdate();
            HibernateUtil.commitTransaction();
        }
        catch (HibernateException e2) {
            Logs.APP_LOG.error((Object)("Could not rename user history for user " + userRenamedEvent.getOldUsername() + " to " + userRenamedEvent.getNewUsername()), (Throwable)e2);
        }
        finally {
            HibernateUtil.rollbackTransactionIfNotCommitted();
        }
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }
}

