/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.trustedapplications;

import com.atlassian.security.auth.trustedapps.filter.AuthenticationListener;
import com.atlassian.security.auth.trustedapps.filter.Authenticator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.springframework.stereotype.Component;

@Component(value="trustedApplicationsAuthenticationListener")
public class FisheyeAuthenticationListener
implements AuthenticationListener {
    private static Logger log = Logger.getLogger(FisheyeAuthenticationListener.class);
    public static final String TRUSTED_APPS_USER_LOGIN = "fisheye.trusted.apps.user.login";
    private volatile boolean muteFailureLogging = false;

    public void muteFailureLogging() {
        this.muteFailureLogging = true;
    }

    public void unmuteFailureLogging() {
        this.muteFailureLogging = false;
    }

    public void authenticationSuccess(Authenticator.Result result, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.markRequestAsAuthAttempted(httpServletRequest);
        httpServletRequest.setAttribute(TRUSTED_APPS_USER_LOGIN, (Object)result.getUser());
    }

    public void authenticationFailure(Authenticator.Result result, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.markRequestAsAuthAttempted(httpServletRequest);
        Level level = this.muteFailureLogging ? Level.DEBUG : Level.WARN;
        log.log((Priority)level, (Object)("Failed trusted applications authentication attempt:" + this.getMessage(result) + this.remoteHost(httpServletRequest)));
    }

    public void authenticationError(Authenticator.Result result, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (!(result instanceof Authenticator.Result.NoAttempt)) {
            this.markRequestAsAuthAttempted(httpServletRequest);
            log.error((Object)("Error handling trusted applications authentication attempt:" + this.getMessage(result) + this.remoteHost(httpServletRequest)));
        }
    }

    private String remoteHost(HttpServletRequest request) {
        return " remote host:" + request.getRequestURL() + " remote port:" + request.getRemotePort() + this.forwardedFor(request);
    }

    private String forwardedFor(HttpServletRequest request) {
        String s2 = request.getHeader("X-Forwarded-For");
        return s2 != null ? " X-Forwarded-For: " + s2 : "";
    }

    public void authenticationNotAttempted(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
    }

    private void markRequestAsAuthAttempted(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute("fisheye.trusted.apps.auth.attempted", (Object)true);
    }

    private String getMessage(Authenticator.Result result) {
        try {
            return result.getMessage();
        }
        catch (NullPointerException npe) {
            return "";
        }
    }
}

