/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.trustedapplications;

import com.atlassian.fisheye.trustedapplications.FisheyeCurrentApplication;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.security.auth.trustedapps.Application;
import com.atlassian.security.auth.trustedapps.ApplicationRetriever;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.atlassian.security.auth.trustedapps.DefaultTrustedApplication;
import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import com.atlassian.security.auth.trustedapps.RequestConditions;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsConfigurationManager;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.CurrentApplicationType;
import com.cenqua.fisheye.config1.TrustedApplicationType;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="trustedApplicationsManager")
@AvailableToPlugins
public class DefaultFisheyeTrustedApplicationsManager
implements TrustedApplicationsConfigurationManager,
TrustedApplicationsManager {
    private EncryptionProvider encryptionProvider;
    private FisheyeCurrentApplication cachedCurrentApplication = null;
    private Map<String, TrustedApplication> cachedTrustedApplications = null;

    @Autowired
    public DefaultFisheyeTrustedApplicationsManager(EncryptionProvider encryptionProvider) {
        this.encryptionProvider = encryptionProvider;
    }

    public TrustedApplication addTrustedApplication(Application application, RequestConditions requestConditions) {
        DefaultTrustedApplication fisheyeTrustedApplication = new DefaultTrustedApplication(this.encryptionProvider, application.getPublicKey(), application.getID(), requestConditions);
        this.addTrustedApplication((TrustedApplication)fisheyeTrustedApplication);
        return fisheyeTrustedApplication;
    }

    public Application getApplicationCertificate(String url) throws ApplicationRetriever.RetrievalException {
        return this.getEncryptionProvider().getApplicationCertificate(url);
    }

    private synchronized void addTrustedApplication(TrustedApplication trustedApp) {
        this.getTrustedApplicationsMap().put(trustedApp.getID(), trustedApp);
        TrustedApplicationType app = this.getCfg().addNewTrustedApplication();
        this.createTrustedApplicationType(trustedApp, app);
        try {
            this.saveCfg();
        }
        catch (IOException e2) {
            throw new Error("Error saving trusted applications configuration", e2);
        }
    }

    public synchronized TrustedApplication getTrustedApplication(String id) {
        return this.getTrustedApplicationsMap().get(id);
    }

    public Iterable<TrustedApplication> getTrustedApplications() {
        return Lists.newArrayList(this.getTrustedApplicationsMap().values());
    }

    private Map<String, TrustedApplication> getTrustedApplicationsMap() {
        if (this.cachedTrustedApplications == null) {
            this.cachedTrustedApplications = new HashMap<String, TrustedApplication>();
            for (TrustedApplicationType ta : this.getCfg().getTrustedApplicationArray()) {
                try {
                    this.cachedTrustedApplications.put(ta.getId(), this.createTrustedApplication(ta));
                }
                catch (Exception e2) {
                    throw new Error("Error reading application " + ta.getId() + " from configuration", e2);
                }
            }
        }
        return this.cachedTrustedApplications;
    }

    private TrustedApplication createTrustedApplication(TrustedApplicationType ta) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        return new DefaultTrustedApplication(this.encryptionProvider, this.encryptionProvider.toPublicKey(ta.getPublicKey()), ta.getId(), ta.getName(), RequestConditions.builder().setCertificateTimeout(ta.getCertificateTimeout()).addURLPattern(ta.getUrlPatternArray()).addIPPattern(ta.getIpPatternArray()).build());
    }

    private void createTrustedApplicationType(TrustedApplication app, TrustedApplicationType ta) {
        ta.setName(app.getName() != null ? app.getName() : app.getID());
        ta.setId(app.getID());
        ta.setPublicKey(app.getPublicKey().getEncoded());
        ta.setCertificateTimeout(app.getRequestConditions().getCertificateTimeout());
        ta.setIpPatternArray(this.toArray(app.getRequestConditions().getIPPatterns()));
        ta.setUrlPatternArray(this.toArray(app.getRequestConditions().getURLPatterns()));
    }

    private String[] toArray(Iterable<String> iterable) {
        ArrayList list = Lists.newArrayList(iterable);
        return list.toArray(new String[list.size()]);
    }

    public synchronized CurrentApplication getCurrentApplication() {
        if (this.cachedCurrentApplication == null) {
            if (this.getCfg().isSetCurrentApplication()) {
                try {
                    this.cachedCurrentApplication = new FisheyeCurrentApplication(this.encryptionProvider, this.encryptionProvider.toPublicKey(this.getCfg().getCurrentApplication().getPublicKey()), this.encryptionProvider.toPrivateKey(this.getCfg().getCurrentApplication().getPrivateKey()), this.getCfg().getCurrentApplication().getId());
                }
                catch (Exception e2) {
                    throw new Error("Error reading key", e2);
                }
            }
            KeyPair keyPair = null;
            try {
                keyPair = this.encryptionProvider.generateNewKeyPair();
            }
            catch (Exception e3) {
                throw new Error("Error generating key pair", e3);
            }
            this.cachedCurrentApplication = new FisheyeCurrentApplication(this.encryptionProvider, keyPair.getPublic(), keyPair.getPrivate(), this.encryptionProvider.generateUID());
            CurrentApplicationType currentAppType = this.getCfg().addNewCurrentApplication();
            currentAppType.setId(this.cachedCurrentApplication.getID());
            currentAppType.setPublicKey(this.cachedCurrentApplication.getPublicKey().getEncoded());
            currentAppType.setPrivateKey(this.cachedCurrentApplication.getPrivateKey().getEncoded());
            try {
                this.saveCfg();
            }
            catch (IOException e4) {
                throw new Error("Error writing current application configuration", e4);
            }
        }
        return this.cachedCurrentApplication;
    }

    private ConfigDocument.Config getCfg() {
        return AppConfig.getsConfig().getConfig();
    }

    private void saveCfg() throws IOException {
        AppConfig.getsConfig().saveConfig();
    }

    public EncryptionProvider getEncryptionProvider() {
        return this.encryptionProvider;
    }

    public boolean deleteApplication(String id) {
        this.cachedTrustedApplications.remove(id);
        TrustedApplicationType[] apps = this.getCfg().getTrustedApplicationArray();
        for (int i2 = 0; i2 < apps.length; ++i2) {
            if (!apps[i2].getId().equals(id)) continue;
            this.getCfg().removeTrustedApplication(i2);
            return true;
        }
        return false;
    }
}

