/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fisheye.event.InitialRepositoryIndexCompleteEventImpl;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.DbTask;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.LineCountState;
import com.cenqua.fisheye.svn.SvnChangeSet;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.db.SvnChangeSetDAO;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.svn.db.SvnRevInfoDAO;
import com.cenqua.fisheye.util.CustomFileNameMap;
import com.cenqua.obfuscate.idb.ac;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class Svn2WrapUpProcessor {
    public static final long WRAPUP_VERSION = 1L;
    private static final int WRAPUP_BATCH_SIZE = 1000;
    private final CustomFileNameMap mimeMap;
    private final Svn2RepositoryEngine engine;
    private final SvnRepositoryInfo repositoryInfo;
    private final RepositoryStatus status;

    public Svn2WrapUpProcessor(Svn2RepositoryEngine engine) {
        this.engine = engine;
        this.repositoryInfo = engine.getRepositoryInfo();
        this.mimeMap = this.repositoryInfo.getSvnConfig().getRootConfig().getRawMimeMap();
        this.status = engine.getStatus();
    }

    public Long process(long timeLimit, long initialIndexingTarget) {
        long startRevision;
        Svn2Cache cache = (Svn2Cache)this.engine.getInternalRevisionCache();
        SvnChangeSetDAO changeSetDAO = cache.getChangeSetDAO();
        if (cache.hasScanProperty(CommonProperties.LAST_WRAPUP.value)) {
            startRevision = cache.getScanProperty(CommonProperties.LAST_WRAPUP.value, 0L) + 1L;
        } else {
            startRevision = this.repositoryInfo.getStartRev();
            if (startRevision > 0L) {
                --startRevision;
            }
        }
        long lastScannedCsid = cache.getChangeSetDAO().getLastCsid();
        Logs.APP_LOG.debug((Object)("Started wrapup processing: startRevision=" + startRevision + ", lastScannedCsid=" + lastScannedCsid));
        AtomicLong lastCsProcessed = new AtomicLong(-1L);
        do {
            Iterator changesetIds = changeSetDAO.getCsidsFrom(startRevision).iterator();
            LongArrayList wrappable = new LongArrayList();
            int alreadyWrapped = 0;
            boolean candidatesForWrapping = changesetIds.hasNext();
            while (changesetIds.hasNext() && wrappable.size() < 1000) {
                Long csid = (Long)changesetIds.next();
                ChangeSetIndexingState indexingState = changeSetDAO.getIndexingState(csid.toString());
                if (indexingState != ChangeSetIndexingState.COMPLETE) {
                    if (indexingState != ChangeSetIndexingState.CONTENT_INDEXED) {
                        Logs.APP_LOG.debug((Object)("While performing wrapup processing " + csid + " is in state " + (Object)((Object)indexingState) + " - skipping"));
                        break;
                    }
                    wrappable.add(csid);
                    continue;
                }
                ++alreadyWrapped;
            }
            if (wrappable.isEmpty()) {
                if (!candidatesForWrapping) break;
                Logs.APP_LOG.debug((Object)"No changesets in the batch are wrappable.");
                if (alreadyWrapped <= 0) break;
                Logs.APP_LOG.debug((Object)("Skipped " + alreadyWrapped + " changesets already wrapped."));
                break;
            }
            this.engine.getStatus().setMessage("Completing changesets " + wrappable.get(0) + " to " + Iterables.getLast((Iterable)wrappable));
            cache.withDbWriteLock(40, new DbTask<Void>((List)wrappable, cache, lastScannedCsid, changeSetDAO, initialIndexingTarget, lastCsProcessed, timeLimit){
                final /* synthetic */ List val$wrappable;
                final /* synthetic */ Svn2Cache val$cache;
                final /* synthetic */ long val$lastScannedCsid;
                final /* synthetic */ SvnChangeSetDAO val$changeSetDAO;
                final /* synthetic */ long val$initialIndexingTarget;
                final /* synthetic */ AtomicLong val$lastCsProcessed;
                final /* synthetic */ long val$timeLimit;
                {
                    this.val$wrappable = list;
                    this.val$cache = svn2Cache;
                    this.val$lastScannedCsid = l2;
                    this.val$changeSetDAO = svnChangeSetDAO;
                    this.val$initialIndexingTarget = l3;
                    this.val$lastCsProcessed = atomicLong;
                    this.val$timeLimit = l4;
                }

                @Override
                public Void perform(ac itemSpace) {
                    for (Long csid : this.val$wrappable) {
                        Svn2WrapUpProcessor.this.status.throwOnStopRequested();
                        Svn2WrapUpProcessor.this.engine.getStatus().setMessage("Finalising changeset " + csid);
                        Svn2WrapUpProcessor.this.processChangeset(this.val$cache, Svn2WrapUpProcessor.this.repositoryInfo, csid);
                        if (csid >= this.val$lastScannedCsid) {
                            Svn2WrapUpProcessor.this.engine.getLinecountCalculator().calcBlame(false);
                        }
                        this.val$changeSetDAO.updateIndexingState(Long.toString(csid), 1L, ChangeSetIndexingState.COMPLETE);
                        if (!Svn2WrapUpProcessor.this.status.isInitialIndexingComplete() && csid >= this.val$initialIndexingTarget) {
                            Svn2WrapUpProcessor.this.markIndexingComplete(this.val$cache, this.val$initialIndexingTarget);
                        }
                        this.val$lastCsProcessed.set(csid);
                        Svn2WrapUpProcessor.this.status.setMessage("");
                        if (System.currentTimeMillis() <= this.val$timeLimit) continue;
                        break;
                    }
                    return null;
                }
            });
        } while ((startRevision = lastCsProcessed.get() + 1L) > 0L && System.currentTimeMillis() < timeLimit);
        Logs.APP_LOG.debug((Object)("Completed wrapup processing: lastCsProcessed=" + lastCsProcessed.get()));
        return lastCsProcessed.get();
    }

    private void processChangeset(Svn2Cache cache, SvnRepositoryInfo repositoryInfo, long csid) {
        SvnChangeSetDAO changeSetDAO = cache.getChangeSetDAO();
        SvnRevInfoDAO fileRevisionDAO = cache.getFileRevisionDAO();
        SvnChangeSet changeset = (SvnChangeSet)changeSetDAO.getChangeSet(Long.toString(csid));
        SvnLogicalPathMatcher pathMatcher = repositoryInfo.getPathMatcher();
        Long changesetProcessedVersion = changeset.getIndexingStateVersion(ChangeSetIndexingState.COMPLETE);
        if (changesetProcessedVersion != null && changesetProcessedVersion == 1L) {
            changeSetDAO.setIndexingState(Long.toString(csid), ChangeSetIndexingState.COMPLETE);
            return;
        }
        ArrayList<Integer> tagDeletionRevIds = new ArrayList<Integer>();
        for (SvnRevInfo svnRevInfo : changeset.getRevisionsIterable()) {
            if (pathMatcher.isTag(svnRevInfo.getPath())) {
                if (svnRevInfo.isDead()) {
                    tagDeletionRevIds.add(svnRevInfo.getRevID());
                } else if (svnRevInfo.getCopySourcePath() != null) {
                    Path srcLogicalPath;
                    Path destLogicalPath = svnRevInfo.getLogicalPath();
                    if (destLogicalPath.equals(srcLogicalPath = pathMatcher.getLogicalPath(svnRevInfo.getCopySourcePath()))) {
                        this.processTagOperation(cache, svnRevInfo);
                    } else {
                        this.processFileRevision(fileRevisionDAO, pathMatcher, svnRevInfo);
                    }
                } else {
                    this.processFileRevision(fileRevisionDAO, pathMatcher, svnRevInfo);
                }
            } else {
                this.processFileRevision(fileRevisionDAO, pathMatcher, svnRevInfo);
            }
            int revid = svnRevInfo.getRevID();
            fileRevisionDAO.getCommonRevInfoDAO().updateLineCount(svnRevInfo.getRevID(), svnRevInfo.getLineCount(), svnRevInfo.getLinesAdded(), svnRevInfo.getLinesRemoved(), LineCountState.FULL);
            fileRevisionDAO.updateRevisionRelationships(revid, svnRevInfo);
            fileRevisionDAO.setHunks(revid, svnRevInfo.getHunks());
        }
        for (Integer revId : tagDeletionRevIds) {
            this.processTagDeletion(fileRevisionDAO, revId);
        }
        cache.setScanProperty(CommonProperties.LAST_WRAPUP.value, csid);
    }

    public void markIndexingComplete(Svn2Cache cache, long initialIndexingTarget) {
        cache.setInitialIndexingComplete(false);
        this.engine.getIndexingContext().getEventPublisher().publish((Object)new InitialRepositoryIndexCompleteEventImpl(this.engine.getName(), Long.toString(initialIndexingTarget)));
        Logs.APP_LOG.info((Object)("Initial index of repository " + this.engine.getName() + " is complete."));
    }

    private void processFileRevision(SvnRevInfoDAO fileRevisionDAO, SvnLogicalPathMatcher pathMatcher, SvnRevInfo fileRevision) {
        Path destPath = fileRevision.getPath();
        if (fileRevision.isAdded()) {
            if (!fileRevision.isCopy() && !fileRevision.isMove()) {
                fileRevision.setLineCount(fileRevision.getLinesAdded());
            } else {
                int ancestorRevid = -1;
                AncestorLink link = null;
                Path srcPath = fileRevision.getCopySourcePath();
                if (srcPath != null) {
                    long srcRevision = fileRevision.getCopySourceRevision();
                    long copiedCsid = fileRevisionDAO.getLatestPathChangeUpto(srcPath, srcRevision, true);
                    ancestorRevid = fileRevisionDAO.getRevId(srcPath, copiedCsid);
                    if (ancestorRevid == -1) {
                        Logs.APP_LOG.info((Object)("Unable to find ancestor for " + fileRevision.getRevInfoKey()));
                    } else if (fileRevision.isCopy()) {
                        Path destLogicalPath = pathMatcher.getLogicalPath(destPath);
                        Path srcLogicalPath = pathMatcher.getLogicalPath(srcPath);
                        if (destLogicalPath != null && destLogicalPath.equals(srcLogicalPath)) {
                            String srcBranch = pathMatcher.getBranch(srcPath);
                            String destBranch = pathMatcher.getBranch(destPath);
                            if (destBranch != null && !destBranch.equals(srcBranch)) {
                                link = new AncestorLink(AncestorLink.Type.BRANCHPOINT, ancestorRevid);
                            }
                        }
                        if (link == null) {
                            link = new AncestorLink(AncestorLink.Type.COPY, ancestorRevid);
                        }
                    } else {
                        link = new AncestorLink(AncestorLink.Type.MOVE, ancestorRevid);
                    }
                }
                if (link != null) {
                    fileRevision.setAncestorLink(link);
                }
                if (fileRevision.isFile()) {
                    int lineCount = 0;
                    if (fileRevision.getLinesAdded() != 0) {
                        lineCount = fileRevision.getLinesAdded();
                    } else if (ancestorRevid != -1) {
                        lineCount = fileRevisionDAO.getLineCount(ancestorRevid);
                    }
                    fileRevision.setLineCount(lineCount);
                    fileRevision.setLinesAdded(lineCount);
                    fileRevision.setLinesRemoved(0);
                }
            }
            long predecessorCsid = fileRevisionDAO.getLatestPathChangeUpto(destPath, fileRevision.getSvnRevision() - 1L, false);
            int predecessorRevid = -1;
            if (predecessorCsid != -1L) {
                predecessorRevid = fileRevisionDAO.getRevId(destPath, predecessorCsid);
            }
            if (predecessorRevid != -1) {
                int predecessorCount = fileRevisionDAO.getLineCount(predecessorRevid);
                int newLineCount = fileRevision.isDiffValid() ? predecessorCount + fileRevision.getLinesAdded() - fileRevision.getLinesRemoved() : fileRevision.getLinesAdded();
                fileRevision.setLineCount(newLineCount);
                fileRevision.setLinesRemoved(predecessorCount);
                fileRevision.setLinesAdded(newLineCount);
                RevInfoKey predecessorKey = fileRevisionDAO.getKey(predecessorRevid);
                fileRevision.setPredecessor(predecessorKey);
            }
            if (!fileRevision.isBinaryOrOversize()) {
                fileRevision.createAdditionHunk();
            }
        } else {
            long ancestorCsid = fileRevisionDAO.getLatestPathChangeUpto(destPath, fileRevision.getSvnRevision() - 1L, true);
            int ancestorRevId = -1;
            if (ancestorCsid != -1L) {
                ancestorRevId = fileRevisionDAO.getRevId(destPath, ancestorCsid);
            }
            if (ancestorRevId == -1 && pathMatcher.isTag(destPath)) {
                String tag = pathMatcher.getTag(destPath);
                Path logicalPath = fileRevision.getLogicalPath();
                ancestorRevId = fileRevisionDAO.getTaggedPathRevid(logicalPath, tag, fileRevision.getSvnRevision() - 1L);
            }
            SvnRevInfoDAO.SvnRevisionSummary ancestor = null;
            if (ancestorRevId != -1) {
                ancestor = fileRevisionDAO.loadSummary(ancestorRevId);
                fileRevision.setAncestorLink(new AncestorLink(AncestorLink.Type.DIRECT, ancestorRevId));
            } else {
                Logs.APP_LOG.info((Object)("Unable to find ancestor for non-add operation " + fileRevision.getPath() + "@" + fileRevision.getChangeSetId()));
            }
            if (ancestor != null) {
                if ((fileRevision.isDead() || fileRevision.isBinaryOrOversize()) && fileRevision.isFile()) {
                    fileRevision.setLineCount(0);
                    fileRevision.setLinesRemoved(ancestor.getLineCount());
                    fileRevision.createDeletedHunk();
                    if (fileRevision.isDead()) {
                        fileRevision.setBinary(ancestor.isBinary());
                    }
                } else if (ancestor.isBinaryOrOversize() && !fileRevision.isBinaryOrOversize()) {
                    fileRevision.setLineCount(fileRevision.getLinesAdded());
                    fileRevision.createAdditionHunk();
                } else {
                    Map<String, String> properties;
                    int newCount = ancestor.getLineCount() + fileRevision.getLinesAdded() - fileRevision.getLinesRemoved();
                    if (newCount != fileRevision.getLineCount()) {
                        fileRevision.setLineCount(newCount);
                    }
                    if ((properties = fileRevision.getProperties()).isEmpty()) {
                        Set<String> removedProperties = fileRevisionDAO.loadRemovedSvnProperties(fileRevision.getRevID());
                        properties = new HashMap<String, String>(ancestor.getProperties());
                        properties.keySet().removeAll(removedProperties);
                        if (!properties.isEmpty()) {
                            fileRevision.setStringProperties(properties, this.mimeMap);
                        }
                    }
                }
                fileRevision.setPredecessor(ancestor.getRevInfoKey());
            }
        }
    }

    private void processTagDeletion(final SvnRevInfoDAO fileRevisionDAO, Integer revId) {
        final SvnRevInfoDAO.SvnRevisionSummary fileRevision = fileRevisionDAO.loadSummary(revId);
        if (fileRevision != null) {
            final String tag = this.repositoryInfo.getPathMatcher().getTag(fileRevision.getPath());
            fileRevisionDAO.visitDirectoryTree(fileRevision.getPath(), fileRevision.getSvnRevision() - 1L, new CommonRevInfoDAO.DirectoryTreeVisitor(){

                @Override
                public void visit(long pathId, long changesetid) throws DbException {
                    Path path = fileRevisionDAO.getPath(pathId);
                    Path logicalPath = Svn2WrapUpProcessor.this.repositoryInfo.getPathMatcher().getLogicalPath(path);
                    int taggedRevId = fileRevisionDAO.getTaggedPathRevid(logicalPath, tag, fileRevision.getSvnRevision() - 1L);
                    fileRevisionDAO.removeTag(taggedRevId, tag);
                }
            });
            fileRevisionDAO.addTag(fileRevision.getRevID(), tag);
        } else {
            Logs.APP_LOG.error((Object)("tag deletion revision not found, revid='" + revId + "'"));
        }
    }

    private void processTagOperation(Svn2Cache cache, final SvnRevInfo fileRevision) {
        final Path sourcePath = fileRevision.getCopySourcePath();
        final Path destPath = fileRevision.getPath();
        long sourceRevision = fileRevision.getCopySourceRevision();
        final SvnRevInfoDAO fileRevisionDAO = cache.getFileRevisionDAO();
        final SvnLogicalPathMatcher pathMatcher = this.repositoryInfo.getPathMatcher();
        final String tag = pathMatcher.getTag(fileRevision.getPath());
        fileRevisionDAO.visitDirectoryTree(sourcePath, sourceRevision, new CommonRevInfoDAO.DirectoryTreeVisitor(){

            @Override
            public void visit(long subPathId, long changesetid) throws DbException {
                Path destSubPath;
                int sourceRevId;
                Svn2WrapUpProcessor.this.status.throwOnStopRequested();
                Path sourceSubPath = fileRevisionDAO.getPath(subPathId);
                if (sourceSubPath.equals(sourcePath) && (sourceRevId = fileRevisionDAO.getRevId(sourcePath, changesetid)) != -1) {
                    SvnRevInfoDAO.SvnRevisionSummary sourceRev = fileRevisionDAO.loadSummary(sourceRevId);
                    fileRevision.setLineCount(sourceRev.getLineCount());
                    fileRevision.setLinesAdded(sourceRev.getLineCount());
                }
                Path relativePath = sourceSubPath.getRelativePath(sourcePath);
                Path traversalPath = destSubPath = new Path(destPath, relativePath.toString());
                while (!traversalPath.equals(destPath) && !traversalPath.equals(Path.ROOT)) {
                    int traversalId = fileRevisionDAO.getPureRevId(traversalPath, fileRevision.getSvnRevision());
                    if (traversalId != -1) {
                        return;
                    }
                    traversalPath = traversalPath.getParent();
                }
                Svn2WrapUpProcessor.this.applyTag(fileRevisionDAO, pathMatcher, tag, sourceSubPath, destSubPath, changesetid, fileRevision.getSvnRevision());
            }
        });
    }

    private void applyTag(SvnRevInfoDAO fileRevDAO, SvnLogicalPathMatcher pathMatcher, String tag, Path sourcePath, Path destPath, long taggedChangesetId, long taggingChangesetId) {
        Path logicalPath;
        int realSourceRevId;
        String sourceTag = pathMatcher.getTag(sourcePath);
        while (sourceTag != null && (realSourceRevId = fileRevDAO.getTaggedPathRevid(logicalPath = pathMatcher.getLogicalPath(sourcePath), sourceTag, taggedChangesetId)) != -1) {
            RevInfoKey realSrcKey = fileRevDAO.getKey(realSourceRevId);
            sourcePath = realSrcKey.getPath();
            taggedChangesetId = Long.parseLong(realSrcKey.getRev());
            String newSourceTag = pathMatcher.getTag(sourcePath);
            if (sourceTag.equals(newSourceTag)) break;
            sourceTag = newSourceTag;
        }
        fileRevDAO.storeTagRevision(tag, destPath, taggingChangesetId, sourcePath, taggedChangesetId);
        int taggedRevId = fileRevDAO.getRevId(sourcePath, taggedChangesetId);
        if (taggedRevId != -1) {
            fileRevDAO.addTag(taggedRevId, tag);
        }
    }
}

