/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2MessageContext;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.IndexingFeatures;
import com.cenqua.fisheye.svn.SvnChangePath;
import com.cenqua.fisheye.svn.SvnChangeSet;
import com.cenqua.fisheye.svn.SvnLogMessage;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.subversion.javahl.DiffSummary;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;

public class Svn2Utils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiffTextCache getDiffTextCache(Svn2RepositoryEngine engine, long csid, boolean clear) {
        Svn2Cache cache = (Svn2Cache)engine.getInternalRevisionCache();
        IndexingFeatures features = cache.loadIndexingFeatures();
        boolean enabled = features.isStoreDiffs();
        File diffTextDir = Svn2Utils.getDiffTextDir(engine, csid);
        ReentrantLock diffTextLock = cache.getDiffTextLock();
        try {
            diffTextLock.lock();
            if (clear) {
                IOHelper.recursiveDelete(diffTextDir, 1, false);
            }
            DiffTextCache diffTextCache = new DiffTextCache(diffTextDir, enabled);
            return diffTextCache;
        }
        finally {
            if (diffTextLock.isHeldByCurrentThread()) {
                diffTextLock.unlock();
            }
        }
    }

    private static File getDiffTextDir(Svn2RepositoryEngine engine, long csid) {
        String changesetDiffTextName = String.format("%s/%d/%d", "DiffTextCache", csid / 1000L, csid);
        return new File(engine.getCacheDir(), changesetDiffTextName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDiffText(Svn2RepositoryEngine engine, long csid) {
        File diffTextDir = Svn2Utils.getDiffTextDir(engine, csid);
        Svn2Cache cache = (Svn2Cache)engine.getInternalRevisionCache();
        ReentrantLock diffTextLock = cache.getDiffTextLock();
        try {
            diffTextLock.lock();
            IOHelper.recursiveDelete(diffTextDir, 1, true);
            File parentDir = diffTextDir.getParentFile();
            if (parentDir.list().length == 0) {
                parentDir.delete();
            }
        }
        finally {
            if (diffTextLock.isHeldByCurrentThread()) {
                diffTextLock.unlock();
            }
        }
    }

    public static Svn2MessageContext recreateMessageContext(Svn2RepositoryEngine engine, final SvnChangeSet changeset) {
        Svn2Cache cache = (Svn2Cache)engine.getInternalRevisionCache();
        final SvnRepositoryInfo repositoryInfo = engine.getRepositoryInfo();
        DiffTextCache diffTextCache = Svn2Utils.getDiffTextCache(engine, changeset.getLongId(), true);
        final ArrayList<SvnChangePath> changePaths = new ArrayList<SvnChangePath>();
        cache.getFileRevisionDAO().visitChangeSetRevisions(changeset.getId(), new StoppableVisitor<FileRevision>(){

            @Override
            public boolean visit(FileRevision rev) {
                SvnRevInfo svnRev = (SvnRevInfo)rev;
                String serverPath = repositoryInfo.getServerPath(svnRev.getPath(), svnRev.getSvnRevision());
                String copySrcPath = null;
                long copySrcRevision = -1L;
                if (svnRev.getCopySourcePath() != null) {
                    copySrcRevision = svnRev.getCopySourceRevision();
                    copySrcPath = repositoryInfo.getServerPath(svnRev.getCopySourcePath(), copySrcRevision);
                }
                ChangePath.Action action = svnRev.isAdded() ? ChangePath.Action.add : (svnRev.isDead() ? ChangePath.Action.delete : (svnRev.isModify() ? ChangePath.Action.modify : ChangePath.Action.modify));
                if (repositoryInfo.getStartRev() == changeset.getLongId() && Path.ROOT.equals(svnRev.getPath()) && action == ChangePath.Action.add) {
                    Logs.APP_LOG.debug((Object)("skipping artificially added root path for start revision " + repositoryInfo.getStartRev()));
                    return true;
                }
                NodeKind nodeKind = svnRev.isFile() ? NodeKind.file : (svnRev.isDir() ? NodeKind.dir : NodeKind.unknown);
                SvnChangePath changePath = new SvnChangePath(serverPath, copySrcRevision, copySrcPath, action, nodeKind);
                changePaths.add(changePath);
                return true;
            }
        });
        Map<String, String> csRevProps = changeset.getRevProps();
        HashMap<String, String> revProps = new HashMap<String, String>(csRevProps.size() + 3);
        revProps.putAll(csRevProps);
        revProps.put("svn:author", changeset.getAuthor());
        revProps.put("svn:log", changeset.getComment());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'000Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        revProps.put("svn:date", formatter.format(new Date(changeset.getDate())));
        SvnLogMessage message = new SvnLogMessage(changePaths, changeset.getLongId(), revProps);
        return new Svn2MessageContext(engine, diffTextCache, message);
    }

    public static void doSleep(long delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static DiffSummary.DiffKind getDiffKindFromAction(ChangePath.Action action) {
        switch (action) {
            case add: {
                return DiffSummary.DiffKind.added;
            }
            case delete: {
                return DiffSummary.DiffKind.deleted;
            }
            case modify: {
                return DiffSummary.DiffKind.modified;
            }
            case replace: {
                return DiffSummary.DiffKind.added;
            }
        }
        return DiffSummary.DiffKind.normal;
    }

    public static List<RevisionRange> createRevisionRange(Revision start, Revision end) {
        return Collections.singletonList(new RevisionRange(start, end));
    }
}

