/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fisheye.svn.Svn2Cache;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RevisionCacheProperties;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.upgrade.AbstractRepositoryVersionUpgradeTask;
import com.cenqua.fisheye.svn.SvnChangeSet;
import com.cenqua.fisheye.svn.db.SvnChangeSetDAO;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;

public class Svn2UpgradeTask
extends AbstractRepositoryVersionUpgradeTask {
    public Svn2UpgradeTask() {
        super((Map<ScmType, Integer>)ImmutableMap.of((Object)((Object)ScmType.SVN), (Object)25));
    }

    @Override
    public void upgradeRepository(RepositoryEngine engine, RevisionCacheProperties props) throws IOException {
        Svn2Cache cache = (Svn2Cache)engine.getInternalRevisionCache();
        long phase1 = cache.getScanProperty(CommonProperties.PHASE1_SLURP.value, -1L);
        long phase2 = cache.getScanProperty(CommonProperties.PHASE2_SLURP.value, -1L);
        SvnChangeSetDAO changeSetDAO = cache.getChangeSetDAO();
        long currentMetadataVersion = cache.getMetadataVersion();
        for (SvnChangeSet changeSet : changeSetDAO.getChangeSets()) {
            if (phase2 != -1L && changeSet.getLongId() <= phase2) {
                changeSetDAO.setIndexingStateVersion(changeSet.getId(), ChangeSetIndexingState.METADATA_INDEXED, currentMetadataVersion);
                changeSetDAO.setIndexingStateVersion(changeSet.getId(), ChangeSetIndexingState.CONTENT_INDEXED, currentMetadataVersion);
                changeSetDAO.setIndexingStateVersion(changeSet.getId(), ChangeSetIndexingState.COMPLETE, 1L);
                changeSetDAO.setIndexingState(changeSet.getId(), ChangeSetIndexingState.COMPLETE);
            } else if (phase1 != -1L && changeSet.getLongId() <= phase1) {
                changeSetDAO.setIndexingState(changeSet.getId(), ChangeSetIndexingState.INFILLED);
            }
            changeSetDAO.storeCsid(changeSet);
        }
        if (phase1 != -1L) {
            cache.setScanProperty(CommonProperties.COUNT_EMPTY_FLAG.value, 1L);
            cache.setScanProperty(CommonProperties.LAST_INFILL.value, phase1);
            cache.setScanProperty(CommonProperties.INITIAL_INDEX_TARGET.value, phase1);
        }
        if (phase2 != -1L) {
            cache.setScanProperty(CommonProperties.LAST_WRAPUP.value, phase2);
            cache.setScanProperty(CommonProperties.CONTENT_LAST_INDEXED.value, phase2);
        }
        cache.commit();
        this.markUpgradeTaskComplete(cache, props);
    }

    @Override
    public String getName() {
        return "Svn Upgrade";
    }
}

