/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fecru.util.EggTimer;
import com.atlassian.fisheye.RuntimeWrappedException;
import com.atlassian.fisheye.event.ChangesetsIndexedEvent;
import com.atlassian.fisheye.event.InitialRepositoryScanCompleteEventImpl;
import com.atlassian.fisheye.pipeline.ChangeSetEntry;
import com.atlassian.fisheye.spi.admin.data.ImportMode;
import com.atlassian.fisheye.svn.Svn2AncestryProcessor;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2ClientPool;
import com.atlassian.fisheye.svn.Svn2Infill2Processor;
import com.atlassian.fisheye.svn.Svn2InitialImportVisitor;
import com.atlassian.fisheye.svn.Svn2MessageContext;
import com.atlassian.fisheye.svn.Svn2RepositoryClient;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.atlassian.fisheye.svn.Svn2RescanProcessor;
import com.atlassian.fisheye.svn.Svn2Utils;
import com.atlassian.fisheye.svn.Svn2WrapUpProcessor;
import com.atlassian.util.IndexingStats;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.infinitydb.DbTask;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.BaseRepositoryScanner;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.ChangeSetResolver;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.RepositoryWalker;
import com.cenqua.fisheye.svn.SvnChangePath;
import com.cenqua.fisheye.svn.SvnChangeSet;
import com.cenqua.fisheye.svn.SvnConstants;
import com.cenqua.fisheye.svn.SvnLogMessage;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnRepositoryTester;
import com.cenqua.fisheye.svn.SvnScmConfig;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.svn.db.SvnChangeSetDAO;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.svn.db.SvnRevInfoDAO;
import com.cenqua.fisheye.util.ReversedLongSortedSet;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idb.ac;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;

public class Svn2Scanner
extends BaseRepositoryScanner<Svn2Cache> {
    private final Svn2RepositoryEngine engine;
    private final SvnRepositoryInfo repositoryInfo;
    private final Svn2ClientPool clientPool;
    private final IndexingContext indexingContext;
    private final Svn2Infill2Processor infillProcessor;
    private long pollPeriod;
    private static final int MIN_BLOCK_SIZE = 100;
    private static final int TARGET_NUM_BLOCKS = 5;
    private Svn2MessageContext context;
    private final Svn2WrapUpProcessor wrapUpProcessor;
    private final Svn2AncestryProcessor ancestryProcessor;
    private long initialIndexingTarget;
    private boolean validated = false;

    protected Svn2Scanner(Svn2RepositoryEngine engine) throws ConfigException {
        super(engine);
        this.engine = engine;
        this.repositoryInfo = engine.getRepositoryInfo();
        this.clientPool = engine.getClientPool();
        this.indexingContext = engine.getIndexingContext();
        this.pollPeriod = engine.getPollPeriod();
        if (this.pollPeriod == 0L) {
            this.pollPeriod = 60000L;
        }
        this.wrapUpProcessor = new Svn2WrapUpProcessor(engine);
        this.ancestryProcessor = new Svn2AncestryProcessor(engine, false);
        this.infillProcessor = new Svn2Infill2Processor(engine);
        SvnThrottledClient client = this.clientPool.allocateClient();
        try {
            this.repositoryInfo.fillInRepositoryBasePathHistory(client);
        }
        finally {
            this.clientPool.returnClient(client);
        }
    }

    @Override
    public void start(Svn2Cache cache) throws DbException, ConfigException {
        super.start(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void validateRepository() throws ConfigException {
        SvnScmConfig svnConfig = (SvnScmConfig)this.getRepositoryConfig().getScmConfig();
        SvnThrottledClient client = this.clientPool.allocateClient();
        try {
            SvnRepositoryTester tester = new SvnRepositoryTester(client, this.repositoryInfo, svnConfig.getAccessKey());
            tester.testConnection();
        }
        finally {
            this.clientPool.returnClient(client);
        }
    }

    @Override
    protected boolean updateLocalRepoClone() throws ConfigException {
        return false;
    }

    @Override
    protected void resetScmMetaData() throws DbException {
        final SvnChangeSetDAO changesetDAO = ((Svn2Cache)this.getCache()).getChangeSetDAO();
        ((Svn2Cache)this.getCache()).withDbWriteLock(100, new DbTask<Void>(){

            @Override
            public Void perform(ac itemSpace) {
                for (SvnChangeSet changeSet : changesetDAO.getChangeSets()) {
                    changesetDAO.setIndexingState(changeSet.getId(), ChangeSetIndexingState.SCANNED);
                }
                return null;
            }
        });
    }

    @Override
    public void stop() {
    }

    @Override
    public String updateRevisions(String start, String end) throws RepositoryClientException, DbException, LicensePolicyException {
        Svn2RescanProcessor rescanProcessor = new Svn2RescanProcessor((Svn2Cache)this.getCache(), this.clientPool, this.repositoryInfo, this.getIndexer(), this.getChangesetIndexer(), this.getPathCrossRepoIndexer(), this.getBranchCrossRepoIndexer(), this.getStatus());
        return rescanProcessor.updateChangesets(Long.parseLong(start), Long.parseLong(end));
    }

    @Override
    protected void doSlurpTransaction(boolean updateOccurred) throws DbException, ConfigException {
        block4: {
            try {
                this.getStatus().throwOnStopRequested();
                this.updatePauseStatus();
                if (!this.getStatus().isPaused()) {
                    Logs.APP_LOG.info((Object)("Starting slurp of " + this.getRepoName()));
                    if (!this.validated) {
                        this.validateRepository();
                        this.validated = true;
                    }
                    this.slurpRepository();
                    this.getStatus().setMessage(" ");
                }
            }
            catch (Exception e2) {
                if (this.isUserInitiatedException(e2)) break block4;
                this.handleSlurpException(e2);
            }
        }
    }

    private void slurpRepository() throws RepositoryClientException, IOException {
        long timeLimitMillis = System.currentTimeMillis() + this.pollPeriod;
        RepositoryStatus status = this.getStatus();
        try {
            long lastCSID;
            Svn2Cache cache = (Svn2Cache)this.getCache();
            if (cache.getScanProperty(CommonProperties.COUNT_EMPTY_FLAG.value, 0L) != 0L) {
                status.setUpgrading(true);
                this.upgradeCountEmptyChangesets();
            }
            status.setUpgrading(false);
            boolean newChangesetsScanned = this.doChangesetScan();
            if (newChangesetsScanned) {
                this.indexingContext.getEventPublisher().publish((Object)new ChangesetsIndexedEvent(this.getRepoName()));
            }
            if ((lastCSID = cache.getChangeSetDAO().getLastCsid()) == -1L) {
                return;
            }
            if (System.currentTimeMillis() < timeLimitMillis) {
                this.infillRepository(timeLimitMillis);
            }
            if (System.currentTimeMillis() < timeLimitMillis) {
                this.wrapupRepository(timeLimitMillis, status, cache, lastCSID);
            }
        }
        catch (LicensePolicyException e2) {
            this.setLicensePolicyReached(e2);
        }
        status.setMessage("");
    }

    @VisibleForTesting
    protected void infillRepository(long timeLimitMillis) throws RepositoryClientException, IOException, LicensePolicyException {
        this.infillProcessor.process(timeLimitMillis);
    }

    @VisibleForTesting
    protected void wrapupRepository(long timeLimitMillis, RepositoryStatus status, Svn2Cache cache, long lastCSID) {
        long lastWrapped = this.wrapUpProcessor.process(timeLimitMillis, this.initialIndexingTarget);
        if (lastWrapped != -1L && lastWrapped >= lastCSID) {
            status.setIndexingUpToDate(true);
            this.notifyUpdate();
            IndexingStats stats = new IndexingStats();
            stats.addStats(cache.getIndexingStats());
            stats.addStats(this.clientPool.getIndexingStats());
            stats.dump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doChangesetScan() throws RepositoryClientException, LicensePolicyException {
        SvnThrottledClient client = this.clientPool.allocateClient();
        try {
            SortedIntSet changesetIds;
            final RepositoryStatus status = this.getStatus();
            Svn2RepositoryClient repoClient = new Svn2RepositoryClient(this.repositoryInfo, status, client);
            Svn2Cache cache = (Svn2Cache)this.getCache();
            long latestRevision = repoClient.getLatestRevision();
            cache.setLatestRevision(latestRevision);
            if (!cache.hasScanProperty(CommonProperties.PHASE1_SLURP.value)) {
                this.engine.getStatus().setMessage("Obtaining initial changeset list");
                Svn2EffectiveStartRevision indexInfo = this.getEffectiveStartRevision(repoClient);
                if (repoClient.isEmptyRepo()) {
                    status.setTotalChangesets(0);
                    boolean bl = false;
                    return bl;
                }
                changesetIds = repoClient.getChangesetIds(indexInfo.getEffectiveStartRevision());
                status.setTotalChangesets(changesetIds.cardinality());
                this.setInitialIndexingTarget(changesetIds.prevSetBit(Integer.MAX_VALUE));
                if (changesetIds.cardinality() == 0) {
                    boolean bl = false;
                    return bl;
                }
                if (indexInfo.isIndexingFromMiddleOfTheHistory() && this.repositoryInfo.getImportMode() == ImportMode.IMPORT_WITHOUT_TAGS) {
                    this.doInitialImport(client, indexInfo.getEffectiveStartRevision());
                }
            } else {
                long startRevision;
                this.engine.getStatus().setMessage("Obtaining changeset list");
                this.initialIndexingTarget = cache.getScanProperty(CommonProperties.INITIAL_INDEX_TARGET.value, -1L);
                if (this.initialIndexingTarget == -1L || !status.isInitialIndexingComplete() && status.getTotalChangesets() == -1) {
                    Svn2EffectiveStartRevision indexInfo = this.getEffectiveStartRevision(repoClient);
                    SortedIntSet allChangesets = repoClient.getChangesetIds(indexInfo.getEffectiveStartRevision());
                    if (!status.isInitialIndexingComplete() && status.getTotalChangesets() == -1) {
                        status.setTotalChangesets(allChangesets.cardinality());
                    }
                    if (this.initialIndexingTarget == -1L) {
                        this.setInitialIndexingTarget(allChangesets.prevSetBit(Integer.MAX_VALUE));
                    }
                }
                if (status.isInitialIndexingComplete()) {
                    status.setTotalChangesets(-1);
                }
                if ((startRevision = cache.getScanProperty(CommonProperties.PHASE1_SLURP.value, 0L) + 1L) > latestRevision) {
                    boolean bl = false;
                    return bl;
                }
                changesetIds = repoClient.getChangesetIds(startRevision);
            }
            int blockSize = this.determineBlockSize();
            cache.setLatestRevision(latestRevision);
            final ArrayList<SvnLogMessage> messages = new ArrayList<SvnLogMessage>();
            final AtomicReference lastMessage = new AtomicReference();
            while (changesetIds.cardinality() != 0) {
                messages.clear();
                int blockStart = changesetIds.nextSetBit(0);
                int blockEnd = this.getBlockEnd(changesetIds, blockSize);
                Revision.Number startRev = new Revision.Number((long)blockStart);
                Revision.Number endRev = new Revision.Number((long)blockEnd);
                int startCardinality = changesetIds.cardinality();
                try {
                    client.setFailOnTimeout(false);
                    List<RevisionRange> revRanges = Svn2Utils.createRevisionRange((Revision)startRev, (Revision)endRev);
                    client.logMessages(this.repositoryInfo.getRepositoryRoot(blockEnd), (Revision)endRev, revRanges, !this.repositoryInfo.isFollowBaseHistory(), true, false, SvnConstants.STD_REVPROPS, 0L, new LogMessageCallback(){
                        private int messageCount = 0;

                        public void singleMessage(Set<ChangePath> changePaths, long revision, Map<String, byte[]> revProps, boolean hasChildren) {
                            status.throwOnStopRequested();
                            if (revision == 0L) {
                                return;
                            }
                            SvnLogMessage message = new SvnLogMessage(changePaths, revision, revProps);
                            lastMessage.set(message);
                            messages.add(message);
                            this.messageCount += message.getNumChangePaths();
                            changesetIds.clear((int)revision);
                            if (this.messageCount >= FishEyeSysProps.PIPELINE_BATCH_PATHLIMIT) {
                                throw new SvnThrottledClient.BreakException();
                            }
                        }
                    });
                }
                catch (RuntimeWrappedException e2) {
                    e2.rethrowCause(RepositoryClientException.class);
                    e2.rethrowCause(LicensePolicyException.class);
                    throw new RepositoryClientException(e2.getCause());
                }
                if (!messages.isEmpty()) {
                    this.processChangesetBlock(messages);
                }
                if (startCardinality != changesetIds.cardinality()) continue;
                throw new RepositoryClientException("No changesets were processed from " + startRev + " to " + endRev);
            }
        }
        finally {
            this.clientPool.returnClient(client);
        }
        return true;
    }

    private void setInitialIndexingTarget(final long targetRevision) {
        ((Svn2Cache)this.getCache()).withDbWriteLock(100, new DbTask<Object>(){

            @Override
            public Void perform(ac itemSpace) {
                ((Svn2Cache)Svn2Scanner.this.getCache()).setScanProperty(CommonProperties.INITIAL_INDEX_TARGET.value, targetRevision);
                return null;
            }
        });
        this.initialIndexingTarget = targetRevision;
    }

    private int determineBlockSize() {
        int total = this.getStatus().getTotalChangesets();
        if (total == -1) {
            return FishEyeSysProps.PIPELINE_BATCH_CSLIMIT;
        }
        int blockSize = Math.min(total / 5, FishEyeSysProps.PIPELINE_BATCH_CSLIMIT);
        blockSize = Math.max(blockSize, 100);
        return blockSize;
    }

    private int getBlockEnd(SortedIntSet changesetIds, int scanBlockSize) {
        int count = 0;
        if (changesetIds.cardinality() < scanBlockSize) {
            return changesetIds.length() - 1;
        }
        int csid = changesetIds.nextSetBit(0);
        while (csid >= 0 && ++count < scanBlockSize) {
            csid = changesetIds.nextSetBit(csid + 1);
        }
        return csid;
    }

    private void doInitialImport(SvnThrottledClient client, long startRevision) throws LicensePolicyException, RepositoryClientException {
        final long importRevision = startRevision - 1L;
        HashMap<String, String> revProps = new HashMap<String, String>();
        revProps.put("svn:author", "no_author");
        revProps.put("svn:log", "Created by FishEye for initial repository import");
        revProps.put("svn:date", "1970-01-01T00:00:00.000000Z");
        final SvnLogMessage importMessage = new SvnLogMessage(importRevision, revProps);
        DiffTextCache diffTextCache = Svn2Utils.getDiffTextCache(this.engine, importRevision, true);
        this.context = new Svn2MessageContext(this.engine, diffTextCache, importMessage);
        try {
            final RepositoryWalker walker = new RepositoryWalker(this.repositoryInfo, client, importRevision);
            walker.setSkipTags(true);
            final Svn2Cache cache = (Svn2Cache)this.getCache();
            cache.withDbWriteLock(100, new DbTask<Void>(){

                @Override
                public Void perform(ac itemSpace) {
                    try {
                        Svn2Scanner.this.context.setDb(itemSpace);
                        Svn2InitialImportVisitor initialImportVisitor = new Svn2InitialImportVisitor(Svn2Scanner.this.context, Svn2Scanner.this.context.getDiffTextCache(), Svn2Scanner.this.getStatus());
                        walker.walkDir(Path.ROOT, initialImportVisitor);
                        cache.setScanProperty(CommonProperties.PHASE1_SLURP.value, importRevision);
                        cache.setScanProperty(CommonProperties.LAST_INFILL.value, importRevision);
                        Svn2Scanner.this.createChangeset(cache, initialImportVisitor.getBranches());
                        Svn2Scanner.this.indexChangeSets(importRevision, importRevision, false);
                        String csid = Long.toString(importRevision);
                        cache.getChangeSetDAO().setIndexingState(csid, ChangeSetIndexingState.INFILLED);
                        Svn2Scanner.this.engine.getIndexingContext().getChangeSetPipeline().put(new ChangeSetEntry(Svn2Scanner.this.engine.getName(), importMessage.getDate().getTime(), csid, csid));
                    }
                    catch (RepositoryClientException e2) {
                        throw new RuntimeWrappedException(e2);
                    }
                    catch (IOException e3) {
                        throw new RuntimeWrappedException(e3);
                    }
                    catch (LicensePolicyException e4) {
                        throw new RuntimeWrappedException(e4);
                    }
                    finally {
                        Svn2Scanner.this.context.setDb(null);
                    }
                    return null;
                }
            });
        }
        catch (RuntimeWrappedException e2) {
            e2.rethrowCause(LicensePolicyException.class);
            e2.rethrowCause(RepositoryClientException.class);
            throw new DbException(e2.getCause());
        }
    }

    private void processChangesetBlock(final List<SvnLogMessage> messages) throws RepositoryClientException, LicensePolicyException {
        try {
            ((Svn2Cache)this.getCache()).withDbWriteLock(100, new DbTask<Object>(){

                @Override
                public Object perform(ac itemSpace) {
                    try {
                        for (SvnLogMessage message : messages) {
                            Svn2Scanner.this.getStatus().throwOnStopRequested();
                            Svn2Scanner.this.processChangeset(itemSpace, message);
                        }
                        Svn2Scanner.this.clearLicensePolicyReached();
                        long endCsid = ((SvnLogMessage)Iterables.getLast((Iterable)messages)).getRevisionNumber();
                        Svn2Scanner.this.indexChangeSets(((SvnLogMessage)messages.get(0)).getRevisionNumber(), endCsid, false);
                        ((Svn2Cache)Svn2Scanner.this.getCache()).setScanProperty(CommonProperties.PHASE1_SLURP.value, endCsid);
                    }
                    catch (Exception e2) {
                        throw new RuntimeWrappedException(e2);
                    }
                    return null;
                }
            });
        }
        catch (RuntimeWrappedException e2) {
            e2.rethrowCause(RepositoryClientException.class);
            e2.rethrowCause(LicensePolicyException.class);
            throw new RepositoryClientException(e2.getCause());
        }
    }

    protected void indexChangeSets(long start, long end, boolean isUpdate) throws DbException {
        SvnChangeSetDAO changesetDAO = ((Svn2Cache)this.getCache()).getChangeSetDAO();
        LongSortedSet changesetIds = changesetDAO.getSvnChangeSetIds(start, end);
        this.indexChangeSets(start, end, isUpdate, new ReversedLongSortedSet(changesetIds));
    }

    private void indexChangeSets(long start, long end, boolean isUpdate, Collection<Long> changesetIds) {
        if (changesetIds.isEmpty()) {
            return;
        }
        Timer timer = this.startIndexingTimer(start, end);
        boolean hasPre24Changesets = isUpdate && this.indexingContext.getCrossRepLuceneIndex().getRescanStatus((RevisionCache)this.getCache()).needsPre24ChangesetHandling();
        this.getChangesetIndexer().indexChangesetsAndAuthors(((Svn2Cache)this.getCache()).getCrossRepLuceneConnection(), (ChangeSetResolver)this.getCache(), Iterables.transform(changesetIds, (Function)Functions.toStringFunction()), this.getStatus(), isUpdate, null, hasPre24Changesets);
        this.getBranchCrossRepoIndexer().indexBranchesForChangeSetIds(Iterables.transform(changesetIds, (Function)Functions.toStringFunction()), (Iterable<Branch>)((Svn2Cache)this.getCache()).getBranches(), this.getCache(), this.getStatus());
        if (isUpdate) {
            this.getPathCrossRepoIndexer().indexPathsForChangeSetIds(this.repositoryInfo.getRepositoryName(), this.getCache(), Iterables.transform(changesetIds, (Function)Functions.toStringFunction()), this.getPathMatcher(), this.getStatus());
        }
        this.stopIndexingTimer(timer, changesetIds.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChangeset(ac itemSpace, SvnLogMessage message) throws LicensePolicyException, RepositoryClientException {
        this.context = new Svn2MessageContext(this.engine, null, message);
        this.context.setDb(itemSpace);
        Svn2Cache cache = (Svn2Cache)this.getCache();
        SvnChangeSetDAO changeSetDAO = cache.getChangeSetDAO();
        boolean hasPaths = false;
        HashSet<String> branches = new HashSet<String>();
        try {
            if (cache.getFileRevisionDAO().getLatestPathChange(Path.ROOT) == -1L && this.context.getMostSpecificChange(Path.ROOT) == null) {
                this.createRootDir();
                hasPaths = true;
            }
            SvnLogicalPathMatcher pathMatcher = this.repositoryInfo.getPathMatcher();
            block9: for (SvnChangePath changePath : message.getChangePaths()) {
                this.getStatus().throwOnStopRequested();
                Path physicalPath = this.context.getLocalPath(changePath);
                if (!this.repositoryInfo.isPathInRepo(physicalPath)) {
                    boolean skipPath = true;
                    if (changePath.getCopySrcPath() != null) {
                        Path basePath = new Path(this.repositoryInfo.getRepositoryBase(this.context.getRevision()));
                        Path cpPath = new Path(changePath.getPath());
                        if (cpPath.isAncestor(basePath)) {
                            skipPath = false;
                        }
                    }
                    if (skipPath) continue;
                }
                Path sourcePhysicalPath = this.repositoryInfo.getLocalPath(changePath.getCopySrcPath(), changePath.getCopySrcRevision());
                boolean sourceAvailableInRepo = this.repositoryInfo.isPathInRepo(sourcePhysicalPath, changePath.getCopySrcRevision());
                if (physicalPath.isAbove()) {
                    physicalPath = Path.ROOT;
                }
                String effectiveBranch = pathMatcher.getEffectiveBranch(physicalPath);
                if (!pathMatcher.isTag(physicalPath) || !this.context.isPartOfAdd(changePath)) {
                    branches.add(effectiveBranch);
                }
                hasPaths = true;
                ChangePath.Action action = changePath.getAction();
                switch (action) {
                    case add: {
                        if (changePath.getCopySrcPath() != null) {
                            if (sourceAvailableInRepo) {
                                if (!this.context.isPathMoved(changePath.getCopySrcPath())) {
                                    this.processCopy(changePath);
                                    continue block9;
                                }
                                this.processMove(changePath);
                                continue block9;
                            }
                            this.processExternalAddition(changePath);
                            continue block9;
                        }
                        this.processAddition(changePath);
                        continue block9;
                    }
                    case modify: {
                        if (this.context.isPartOfAdd(changePath)) {
                            this.processAddition(changePath);
                            continue block9;
                        }
                        this.processModification(changePath);
                        continue block9;
                    }
                    case delete: {
                        if (this.context.isPartOfAdd(changePath)) continue block9;
                        this.processDeletion(changePath);
                        continue block9;
                    }
                    case replace: {
                        if (changePath.getCopySrcPath() != null) {
                            this.processCopyReplacement(changePath);
                            continue block9;
                        }
                        if (this.context.isPartOfAdd(changePath)) {
                            this.processAddition(changePath);
                            continue block9;
                        }
                        this.processReplacement(changePath);
                        continue block9;
                    }
                }
                Logs.APP_LOG.error((Object)("Unknown SVN action on change - " + action + " on path " + changePath.getPath() + ", revision = " + this.context.getRevision()));
            }
            if (hasPaths) {
                this.createChangeset(cache, branches);
            } else {
                int numEmpty = (int)cache.getScanProperty(CommonProperties.NUM_EMPTY_CS.value, 0L) + 1;
                cache.setScanProperty(CommonProperties.NUM_EMPTY_CS.value, numEmpty);
                this.getStatus().incrementNumEmptyChangesets();
                if (message.getRevisionNumber() == this.initialIndexingTarget) {
                    long previousCsid = changeSetDAO.getPreviousCsid(message.getRevisionNumber());
                    SvnChangeSet previousChangeset = (SvnChangeSet)changeSetDAO.load(Long.toString(previousCsid));
                    if (previousChangeset.getIndexingState() != ChangeSetIndexingState.COMPLETE) {
                        this.setInitialIndexingTarget(previousCsid);
                    } else {
                        this.wrapUpProcessor.markIndexingComplete(cache, previousCsid);
                    }
                }
            }
        }
        finally {
            this.context = null;
            if (!this.getStatus().isInitialScanningComplete() && message.getRevisionNumber() >= this.initialIndexingTarget) {
                this.getStatus().setInitialScanningComplete(true);
                this.indexingContext.getEventPublisher().publish((Object)new InitialRepositoryScanCompleteEventImpl(this.getRepoName(), Long.toString(this.initialIndexingTarget)));
                Logs.APP_LOG.info((Object)("Initial scan of repository " + this.getRepoName() + " is complete."));
            }
        }
    }

    private void createChangeset(Svn2Cache cache, Set<String> branches) throws LicensePolicyException {
        SvnChangeSetDAO changeSetDAO = cache.getChangeSetDAO();
        SvnChangeSet changeset = new SvnChangeSet(this.context.getRevision(), changeSetDAO, cache.getFileRevisionDAO());
        changeset.setAuthor(this.context.getAuthor());
        changeset.setDate(this.context.getDate());
        changeset.setComment(this.context.getCommitMessage());
        changeset.setRevProps(this.context.getRevProps());
        changeset.setBranches(branches);
        changeset.setIndexingState(ChangeSetIndexingState.SCANNED);
        this.ancestryProcessor.process(changeset);
        changeSetDAO.store(changeset);
        this.getStatus().setIndexingUpToDate(false);
        for (String branchName : branches) {
            if (!StringUtils.isNotEmpty((String)branchName)) continue;
            Branch branch = new Branch(branchName, changeset.getId(), null);
            cache.storeBranch(branch);
        }
    }

    private void createRootDir() throws DbException, LicensePolicyException {
        Logs.APP_LOG.debug((Object)"Creating repository root");
        SvnRevInfo rootFileRevision = this.context.createFileRevision(new Path("/"));
        rootFileRevision.setFileType(2);
        rootFileRevision.setAdded(true);
        this.getStatus().setMessage("Creating changeset " + this.context.getRevision() + " - creating root dir");
        this.context.insertFileRevision(rootFileRevision);
    }

    private void processReplacement(SvnChangePath changePath) throws LicensePolicyException, RepositoryClientException {
        Path path = this.context.getLocalPath(changePath);
        SvnRevInfo fileRevision = this.context.createFileRevision(path);
        fileRevision.setAdded(true);
        this.setFileType(fileRevision, changePath);
        SvnRevInfoDAO fileRevisionDAO = ((Svn2Cache)this.getCache()).getFileRevisionDAO();
        this.determinePredecessor(fileRevisionDAO, fileRevision);
        this.getStatus().setMessage("Creating changeset " + this.context.getRevision() + " - processing replacement " + path);
        this.context.insertFileRevision(fileRevision);
    }

    private void processDeletion(SvnChangePath changePath) throws LicensePolicyException, RepositoryClientException {
        Path path = this.context.getLocalPath(changePath);
        SvnRevInfo fileRevision = this.context.createFileRevision(path);
        fileRevision.setDead(true);
        this.setFileType(fileRevision, changePath);
        this.determinePredecessor(((Svn2Cache)this.getCache()).getFileRevisionDAO(), fileRevision);
        this.getStatus().setMessage("Creating changeset " + this.context.getRevision() + " - processing deletion " + path);
        this.context.insertFileRevision(fileRevision);
    }

    private void processMove(SvnChangePath changePath) throws LicensePolicyException, RepositoryClientException {
        Path sourcePath = this.repositoryInfo.getLocalPath(changePath.getCopySrcPath(), changePath.getCopySrcRevision());
        Path path = this.context.getLocalPath(changePath);
        SvnRevInfo fileRevision = this.context.createFileRevision(path);
        fileRevision.setAdded(true);
        fileRevision.setMove(!this.context.getRepositoryInfo().getPathMatcher().isTag(sourcePath));
        fileRevision.setCopySourcePath(sourcePath);
        fileRevision.setCopySourceRevision(changePath.getCopySrcRevision());
        this.setFileType(fileRevision, changePath);
        int ancestorRevId = this.determineAncestor(((Svn2Cache)this.getCache()).getFileRevisionDAO(), fileRevision);
        if (ancestorRevId != -1) {
            fileRevision.setAncestorLink(new AncestorLink(AncestorLink.Type.COPY, ancestorRevId));
        }
        this.getStatus().setMessage("Creating changeset " + this.context.getRevision() + " - processing copy from " + sourcePath + " to " + path);
        this.context.insertFileRevision(fileRevision);
    }

    private void processModification(SvnChangePath changePath) throws LicensePolicyException, RepositoryClientException {
        Path path = this.context.getLocalPath(changePath);
        SvnRevInfo fileRevision = this.context.createFileRevision(path);
        fileRevision.setModify(true);
        this.setFileType(fileRevision, changePath);
        SvnRevInfoDAO fileRevisionDAO = ((Svn2Cache)this.getCache()).getFileRevisionDAO();
        this.determinePredecessor(fileRevisionDAO, fileRevision);
        this.getStatus().setMessage("Creating changeset " + this.context.getRevision() + " - processing modification " + path);
        this.context.insertFileRevision(fileRevision);
    }

    private int determinePredecessor(SvnRevInfoDAO fileRevisionDAO, SvnRevInfo revision) {
        Path path = revision.getPath();
        int predecessorRevId = -1;
        long predecessorCsid = fileRevisionDAO.getLatestPathChangeUpto(path, revision.getSvnRevision(), false);
        if (predecessorCsid != -1L) {
            predecessorRevId = fileRevisionDAO.getRevId(path, predecessorCsid);
            RevInfoKey predecessorKey = fileRevisionDAO.getKey(predecessorRevId);
            if (predecessorKey != null) {
                revision.setPredecessor(predecessorKey);
            } else {
                Logs.APP_LOG.warn((Object)("Unable to load key for revid = " + predecessorCsid));
            }
        }
        if (predecessorRevId != -1) {
            revision.setAncestorLink(new AncestorLink(AncestorLink.Type.DIRECT, predecessorRevId));
        }
        return predecessorRevId;
    }

    private int determineAncestor(SvnRevInfoDAO fileRevisionDAO, SvnRevInfo revision) {
        long sourceRevision;
        long ancestorCsid;
        int ancestorRevId = -1;
        Path srcPath = revision.getCopySourcePath();
        if (srcPath != null && (ancestorCsid = fileRevisionDAO.getLatestPathChangeUpto(srcPath, sourceRevision = revision.getCopySourceRevision(), true)) != -1L) {
            ancestorRevId = fileRevisionDAO.getRevId(srcPath, ancestorCsid);
        }
        return ancestorRevId;
    }

    private void processAddition(SvnChangePath changePath) throws LicensePolicyException, RepositoryClientException {
        Path path = this.context.getLocalPath(changePath);
        SvnRevInfo fileRevision = this.context.createFileRevision(path);
        fileRevision.setAdded(true);
        this.setFileType(fileRevision, changePath);
        this.getStatus().setMessage("Creating changeset " + this.context.getRevision() + " - processing addition " + path);
        this.context.insertFileRevision(fileRevision);
    }

    private void processExternalAddition(SvnChangePath changePath) throws LicensePolicyException, RepositoryClientException {
        Path path = this.context.getLocalPath(changePath);
        if (path.isAbove()) {
            path = Path.ROOT;
        }
        SvnRevInfo fileRevision = this.context.createFileRevision(path);
        fileRevision.setAdded(true);
        this.setFileType(fileRevision, changePath);
        this.getStatus().setMessage("Creating changeset " + this.context.getRevision() + " - processing addition " + path);
        this.context.insertFileRevision(fileRevision);
    }

    private void processCopy(SvnChangePath changePath) throws LicensePolicyException, RepositoryClientException {
        Path copySourcePath = this.repositoryInfo.getLocalPath(changePath.getCopySrcPath(), changePath.getCopySrcRevision());
        Path path = this.context.getLocalPath(changePath);
        SvnLogicalPathMatcher pathMatcher = this.context.getRepositoryInfo().getPathMatcher();
        SvnRevInfo fileRevision = this.context.createFileRevision(path);
        fileRevision.setAdded(true);
        fileRevision.setCopy(!pathMatcher.isTag(copySourcePath));
        fileRevision.setCopySourcePath(copySourcePath);
        fileRevision.setCopySourceRevision(changePath.getCopySrcRevision());
        this.setFileType(fileRevision, changePath);
        int ancestorRevId = this.determineAncestor(((Svn2Cache)this.getCache()).getFileRevisionDAO(), fileRevision);
        if (ancestorRevId != -1) {
            if (pathMatcher.isBranch(fileRevision.getPath()) && pathMatcher.getLogicalPath(fileRevision.getPath()).equals(pathMatcher.getLogicalPath(copySourcePath))) {
                fileRevision.setAncestorLink(new AncestorLink(AncestorLink.Type.BRANCHPOINT, ancestorRevId));
            } else {
                fileRevision.setAncestorLink(new AncestorLink(AncestorLink.Type.COPY, ancestorRevId));
            }
        }
        this.getStatus().setMessage("Creating changeset " + this.context.getRevision() + " - processing copy from " + copySourcePath + " to " + path);
        this.context.insertFileRevision(fileRevision);
    }

    private void processCopyReplacement(SvnChangePath changePath) throws LicensePolicyException, RepositoryClientException {
        Path copySourcePath = this.repositoryInfo.getLocalPath(changePath.getCopySrcPath(), changePath.getCopySrcRevision());
        Path path = this.context.getLocalPath(changePath);
        SvnLogicalPathMatcher pathMatcher = this.context.getRepositoryInfo().getPathMatcher();
        SvnRevInfo fileRevision = this.context.createFileRevision(path);
        if (this.context.isPartOfAdd(changePath)) {
            fileRevision.setAdded(true);
        } else {
            fileRevision.setModify(true);
            SvnRevInfoDAO fileRevisionDAO = ((Svn2Cache)this.getCache()).getFileRevisionDAO();
            this.determinePredecessor(fileRevisionDAO, fileRevision);
        }
        fileRevision.setCopySourcePath(copySourcePath);
        fileRevision.setCopySourceRevision(changePath.getCopySrcRevision());
        this.setFileType(fileRevision, changePath);
        int ancestorRevId = this.determineAncestor(((Svn2Cache)this.getCache()).getFileRevisionDAO(), fileRevision);
        if (ancestorRevId != -1) {
            if (pathMatcher.isBranch(fileRevision.getPath()) && pathMatcher.getLogicalPath(fileRevision.getPath()).equals(pathMatcher.getLogicalPath(copySourcePath))) {
                fileRevision.setAncestorLink(new AncestorLink(AncestorLink.Type.BRANCHPOINT, ancestorRevId));
            } else {
                fileRevision.setAncestorLink(new AncestorLink(AncestorLink.Type.COPY, ancestorRevId));
            }
        }
        this.getStatus().setMessage("Creating changeset " + this.context.getRevision() + " - processing copy/replace from " + copySourcePath + " to " + path);
        this.context.insertFileRevision(fileRevision);
    }

    private void setFileType(SvnRevInfo revision, SvnChangePath changePath) throws RepositoryClientException {
        NodeKind nodeKind = changePath.getNodeKind();
        int filetype = nodeKind != NodeKind.dir && nodeKind != NodeKind.file ? this.context.getFileType(revision.getPath()) : this.context.getFileTypeFromNodeKind(nodeKind);
        if (filetype == -1) {
            Logs.APP_LOG.error((Object)("Unknown nodekind for changePath " + changePath.getPath() + "@" + revision.getChangeSetId()));
        }
        revision.setFileType(filetype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeCountEmptyChangesets() throws RepositoryClientException, LicensePolicyException {
        final Svn2Cache cache = (Svn2Cache)this.getCache();
        long csidLimit = cache.getScanProperty(CommonProperties.PHASE1_SLURP.value, -1L);
        final ArrayList<SvnLogMessage> missingChangesets = new ArrayList<SvnLogMessage>();
        final AtomicInteger numEmpty = new AtomicInteger(0);
        if (csidLimit != -1L) {
            SvnThrottledClient client = this.clientPool.allocateClient();
            try {
                RepositoryStatus status = this.getStatus();
                SvnChangeSetDAO changesetDAO = cache.getChangeSetDAO();
                Svn2RepositoryClient repoClient = new Svn2RepositoryClient(this.repositoryInfo, status, client);
                long startRevision = this.getEffectiveStartRevision(repoClient).getEffectiveStartRevision();
                SortedIntSet changesetIds = repoClient.getChangesetIds(startRevision);
                boolean inNonIndexedRange = false;
                long fromRev = -1L;
                long toRev = -1L;
                int rangeCount = 0;
                int csid = changesetIds.nextSetBit(0);
                while (csid >= 0 && (long)csid <= csidLimit) {
                    status.throwOnStopRequested();
                    if (inNonIndexedRange) {
                        if (changesetDAO.isIndexed(csid)) {
                            this.processNonIndexedRange(client, fromRev, toRev, missingChangesets, numEmpty);
                            inNonIndexedRange = false;
                        } else {
                            if (rangeCount >= 1000) {
                                this.processNonIndexedRange(client, fromRev, toRev, missingChangesets, numEmpty);
                                fromRev = csid;
                                rangeCount = 0;
                            }
                            toRev = csid;
                            ++rangeCount;
                        }
                    } else if (!changesetDAO.isIndexed(csid)) {
                        inNonIndexedRange = true;
                        rangeCount = 1;
                        fromRev = csid;
                        toRev = csid;
                    }
                    csid = changesetIds.nextSetBit(csid + 1);
                }
                if (inNonIndexedRange) {
                    this.processNonIndexedRange(client, fromRev, toRev, missingChangesets, numEmpty);
                }
            }
            finally {
                this.clientPool.returnClient(client);
            }
        }
        try {
            cache.withDbWriteLock(100, new DbTask<Void>(){

                @Override
                public Void perform(ac itemSpace) {
                    try {
                        for (SvnLogMessage message : missingChangesets) {
                            SvnChangeSet changeset = new SvnChangeSet(message.getRevisionNumber(), cache.getChangeSetDAO(), cache.getFileRevisionDAO());
                            String branch = "root:";
                            changeset.setAuthor(message.getAuthor());
                            changeset.setDate(message.getDate().getTime());
                            changeset.setComment(message.getMessage());
                            changeset.setRevProps(message.getRevProps());
                            changeset.setBranches(Collections.singletonList(branch));
                            changeset.setIndexingState(ChangeSetIndexingState.COMPLETE);
                            cache.getChangeSetDAO().store(changeset);
                        }
                        cache.setScanProperty(CommonProperties.NUM_EMPTY_CS.value, numEmpty.intValue());
                        cache.setScanProperty(CommonProperties.COUNT_EMPTY_FLAG.value, 0L);
                        Svn2Scanner.this.getStatus().setNumEmptyChangesets(numEmpty.intValue());
                    }
                    catch (LicensePolicyException e2) {
                        throw new RuntimeWrappedException(e2);
                    }
                    return null;
                }
            });
        }
        catch (RuntimeWrappedException e2) {
            e2.rethrowCause(LicensePolicyException.class);
            e2.rethrowAsRuntime();
        }
    }

    private void processNonIndexedRange(SvnThrottledClient client, long from, long to, final List<SvnLogMessage> missingChangesets, final AtomicInteger numEmpty) throws RepositoryClientException {
        Revision.Number fromRev = new Revision.Number(from);
        Revision.Number toRev = new Revision.Number(to);
        String pathURL = this.repositoryInfo.getPathURL(Path.ROOT, to);
        List<RevisionRange> revRanges = Svn2Utils.createRevisionRange((Revision)fromRev, (Revision)toRev);
        client.logMessages(pathURL, (Revision)toRev, revRanges, !this.repositoryInfo.isFollowBaseHistory(), true, false, SvnConstants.STD_REVPROPS, 0L, new LogMessageCallback(){

            public void singleMessage(Set<ChangePath> changedPaths, long revision, Map<String, byte[]> revprops, boolean hasChildren) {
                boolean hasPaths = false;
                if (changedPaths != null) {
                    for (ChangePath changePath : changedPaths) {
                        if (!Svn2Scanner.this.repositoryInfo.isPathInRepo(changePath.getPath(), revision)) continue;
                        hasPaths = true;
                        break;
                    }
                }
                if (hasPaths) {
                    missingChangesets.add(new SvnLogMessage(changedPaths, revision, revprops));
                } else {
                    numEmpty.incrementAndGet();
                }
            }
        });
    }

    @Override
    public long reindexChangesets(Long endChangesetSvnId, EggTimer eggTimer) throws DbException {
        int changesetCount;
        endChangesetSvnId = endChangesetSvnId == null ? ((Svn2Cache)this.getCache()).getScanProperty(CommonProperties.PHASE1_SLURP.value, 0L) : endChangesetSvnId.longValue();
        long blockSize = 1000L;
        SvnChangeSetDAO changesetDAO = ((Svn2Cache)this.getCache()).getChangeSetDAO();
        for (long endBatchSvnId = endChangesetSvnId.longValue(); endBatchSvnId > -1L && endBatchSvnId > 0L; endBatchSvnId -= (long)changesetCount) {
            this.getStatus().throwOnStopRequested();
            SortedSet<Long> svnChangesetIds = changesetDAO.getSvnChangeSetIdsWithLimit(endBatchSvnId, blockSize, true);
            changesetCount = svnChangesetIds.size();
            if (changesetCount > 0) {
                Long startBatchSvnId = svnChangesetIds.last();
                this.setStatusReindexingChangesets(endBatchSvnId, startBatchSvnId);
                this.indexChangeSets(startBatchSvnId, endBatchSvnId, true, svnChangesetIds);
                if (eggTimer.isTimeExpired()) {
                    return startBatchSvnId;
                }
            }
            if ((long)changesetCount >= blockSize) continue;
            return -1L;
        }
        return -1L;
    }

    private Svn2EffectiveStartRevision getEffectiveStartRevision(Svn2RepositoryClient repoClient) throws RepositoryClientException {
        return new Svn2EffectiveStartRevision(repoClient.getFirstRevision(), this.repositoryInfo.getStartRev());
    }

    private static class Svn2EffectiveStartRevision {
        private final long firstRevision;
        private final long effectiveStartRevision;

        public long getEffectiveStartRevision() {
            return this.effectiveStartRevision;
        }

        public boolean isIndexingFromMiddleOfTheHistory() {
            return this.firstRevision < this.effectiveStartRevision;
        }

        public Svn2EffectiveStartRevision(long firstRevision, long startRevision) {
            this.firstRevision = firstRevision;
            this.effectiveStartRevision = Math.max(firstRevision, startRevision);
        }
    }
}

