/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fisheye.RuntimeWrappedException;
import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2ClientPool;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.crossrepo.BranchIndexer;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.crossrepo.PathIndexer;
import com.cenqua.fisheye.csindex.ChangesetIndexer;
import com.cenqua.fisheye.infinitydb.DbTask;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevidChangeSet;
import com.cenqua.fisheye.rep.impl.CommonIndexer;
import com.cenqua.fisheye.svn.SvnChangeSet;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.svn.db.SvnChangeSetDAO;
import com.cenqua.fisheye.svn.db.SvnRevInfoDAO;
import com.cenqua.fisheye.svn.util.SvnPropertyUtil;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.obfuscate.idb.ac;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexWriter;
import org.apache.subversion.javahl.types.Revision;

public class Svn2RescanProcessor {
    private final Svn2Cache cache;
    private final Svn2ClientPool clientPool;
    private final SvnRepositoryInfo repositoryInfo;
    private final PathIndexer pathIndexer;
    private static final int BATCH_SIZE = 100;
    private final BranchIndexer branchIndexer;
    private CommonIndexer indexer;
    private ChangesetIndexer changesetIndexer;
    private RepositoryStatus status;
    private final SvnRevInfoDAO fileRevDAO;
    private final SvnChangeSetDAO changesetDAO;

    public Svn2RescanProcessor(Svn2Cache cache, Svn2ClientPool clientPool, SvnRepositoryInfo repositoryInfo, CommonIndexer indexer, ChangesetIndexer changesetIndexer, PathIndexer pathIndexer, BranchIndexer branchIndexer, RepositoryStatus status) {
        this.cache = cache;
        this.clientPool = clientPool;
        this.repositoryInfo = repositoryInfo;
        this.indexer = indexer;
        this.changesetIndexer = changesetIndexer;
        this.status = status;
        this.pathIndexer = pathIndexer;
        this.branchIndexer = branchIndexer;
        this.fileRevDAO = cache.getFileRevisionDAO();
        this.changesetDAO = cache.getChangeSetDAO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateChangesets(long start, long end) throws DbException, RepositoryClientException, LicensePolicyException {
        StringBuilder resultMessage = new StringBuilder();
        SvnThrottledClient client = this.clientPool.allocateClient();
        try {
            LongSortedSet changesets = this.changesetDAO.getSvnChangeSetIds(start, end);
            long first = -1L;
            long last = -1L;
            LongIterator i2 = changesets.iterator();
            while (i2.hasNext()) {
                long csid = i2.nextLong();
                if (first == -1L || first > csid) {
                    first = csid;
                }
                if (last == -1L || last < csid) {
                    last = csid;
                }
                Logs.APP_LOG.debug((Object)("Updating revision:" + csid));
                final SvnChangeSet changeSet = this.cache.getChangeSet(Long.toString(csid));
                if (changeSet.getIndexingState() != ChangeSetIndexingState.COMPLETE) {
                    resultMessage.append("Changeset ").append(csid).append(" is still indexing. Please retry\n");
                }
                final Map<String, byte[]> revProps = client.revProperties(this.repositoryInfo.getRepositoryRoot(csid), (Revision)new Revision.Number(csid));
                this.cache.withDbWriteLock(20, new DbTask<Void>(){

                    @Override
                    public Void perform(ac itemSpace) {
                        try {
                            Svn2RescanProcessor.this.updateChangeSet(Svn2RescanProcessor.this.cache, changeSet, revProps);
                        }
                        catch (LicensePolicyException e2) {
                            throw new RuntimeWrappedException(e2);
                        }
                        return null;
                    }
                });
            }
            if (first != -1L && last != -1L) {
                this.indexChangeSets(first, last, true);
                this.reindexMetadata(first, last);
            }
        }
        catch (RuntimeWrappedException e2) {
            e2.rethrowCause(LicensePolicyException.class);
            e2.rethrowAsRuntime();
        }
        finally {
            this.clientPool.returnClient(client);
        }
        return resultMessage.toString();
    }

    private void updateChangeSet(Svn2Cache cache, SvnChangeSet changeSet, Map<String, byte[]> revProps) throws DbException, LicensePolicyException {
        HashSet<String> revPropSet = new HashSet<String>();
        for (Map.Entry<String, byte[]> entry : revProps.entrySet()) {
            String name = entry.getKey();
            if (entry.getValue() == null) continue;
            String value = SvnPropertyUtil.getStringValue(entry.getValue());
            if (name.equals("svn:log")) {
                if (value.equals(changeSet.getComment())) continue;
                Logs.APP_LOG.debug((Object)("Updating svn:log for " + changeSet.getId()));
                changeSet.setComment(value);
                this.updateRevisionComment(changeSet, value);
                continue;
            }
            if (name.equals("svn:author")) {
                if (value.equals(changeSet.getAuthor())) continue;
                Logs.APP_LOG.debug((Object)("Updating svn:author for " + changeSet.getId()));
                changeSet.setAuthor(value);
                this.updateRevisionAuthor(changeSet, value);
                continue;
            }
            if (name.equals("svn:date")) {
                try {
                    long newDate = ISO8601DateHelper.parseAsUTC(value).getTime();
                    if (newDate == changeSet.getDate()) continue;
                    Logs.APP_LOG.debug((Object)("Updating svn:date for " + changeSet.getId()));
                    changeSet.setDate(newDate);
                    this.updateRevisionDate(changeSet, newDate);
                }
                catch (ISO8601DateHelper.InvalidDateException e2) {
                    Logs.APP_LOG.error((Object)("Unable to update date value: " + value), (Throwable)e2);
                }
                continue;
            }
            Logs.APP_LOG.debug((Object)("Updating " + name + " revprop for " + changeSet.getId()));
            this.updateRevisionProperty(cache, changeSet, name, value);
            revPropSet.add(name);
        }
        cache.getChangeSetDAO().store(changeSet);
    }

    private void updateRevisionProperty(Svn2Cache cache, SvnChangeSet changeSet, String name, String value) throws DbException {
        long csid = Long.parseLong(changeSet.getId());
        cache.getChangeSetDAO().updateRevProp(csid, name, value);
    }

    private void updateRevisionComment(SvnChangeSet changeSet, final String value) throws DbException {
        changeSet.visitRevisions(new Visitor<FileRevision>(){

            @Override
            public void visit(FileRevision revision) {
                Svn2RescanProcessor.this.fileRevDAO.updateComment(revision.getRevID(), value);
            }
        });
    }

    private void updateRevisionAuthor(SvnChangeSet changeSet, final String value) throws DbException {
        changeSet.visitRevisions(new Visitor<FileRevision>(){

            @Override
            public void visit(FileRevision revision) {
                Svn2RescanProcessor.this.fileRevDAO.updateAuthor(revision.getRevID(), value);
            }
        });
    }

    private void updateRevisionDate(SvnChangeSet changeSet, final long date) throws DbException {
        changeSet.visitRevisions(new Visitor<FileRevision>(){

            @Override
            public void visit(FileRevision revision) {
                Svn2RescanProcessor.this.fileRevDAO.updateDate(revision.getRevID(), date);
            }
        });
    }

    protected void indexChangeSets(final long start, final long end, boolean isUpdate) throws DbException {
        Timer timer = new Timer("Indexing changesets of " + this.repositoryInfo.getName());
        ArrayList<String> indexableChangeSets = new ArrayList<String>();
        LongSortedSet changesets = this.changesetDAO.getSvnChangeSetIds(start, end);
        this.cache.getCrossRepLuceneConnection().withWriter(CrossRepLuceneIndexes.METADATA, new LuceneConnection.WriterAction<Void>((LongSet)changesets){
            final /* synthetic */ LongSet val$changesets;
            {
                this.val$changesets = longSet;
            }

            @Override
            public Void perform(IndexWriter writer) throws IOException, DbException {
                for (long csid = start; csid <= end; ++csid) {
                    if (this.val$changesets.contains(csid)) continue;
                    Logs.APP_LOG.debug((Object)String.format("Removing changeset %s from index, as it doesn't exist anymore", csid));
                    writer.deleteDocuments(((ChangesetQueryBuilder)((ChangesetQueryBuilder)ChangesetQueryBuilder.newBuilder(Svn2RescanProcessor.this.repositoryInfo.getName()).changesetsOnly()).changesetId(String.valueOf(csid))).build());
                }
                return null;
            }
        });
        if (!changesets.isEmpty()) {
            this.changesetIndexer.indexChangesetsAndAuthors(this.cache.getCrossRepLuceneConnection(), this.cache, Iterables.transform((Iterable)changesets, (Function)Functions.toStringFunction()), this.status, isUpdate, indexableChangeSets, false);
        }
        timer.end();
    }

    private void reindexMetadata(long startChangeset, long endChangeset) throws DbException {
        int count = 0;
        int totalPending = 0;
        long total = endChangeset - startChangeset + 1L;
        LinkedList<RevidChangeSet> changesets = new LinkedList<RevidChangeSet>();
        int batchSize = 100;
        for (long i2 = startChangeset; i2 <= endChangeset; ++i2) {
            this.status.throwOnStopRequested();
            SvnChangeSet cs = this.cache.getChangeSet(Long.toString(i2));
            if (cs != null) {
                changesets.add(cs);
                totalPending += cs.getRevisionInfosCount() + 1;
                ++count;
            } else {
                --total;
            }
            if (totalPending < batchSize && i2 != endChangeset) continue;
            this.status.setMessage("Indexing revision metadata item " + count + " of " + total);
            this.indexBatch(changesets);
            totalPending = 0;
        }
    }

    private void indexBatch(List<RevidChangeSet> changesets) throws DbException {
        try {
            Timer timer = new Timer("Indexing metadata batch sized " + changesets.size());
            this.pathIndexer.indexPathsForChangeSets(this.repositoryInfo.getRepositoryName(), changesets, this.repositoryInfo.getPathMatcher(), this.status);
            this.branchIndexer.indexBranchesForChangeSetIds(Iterables.transform(changesets, ChangeSet.TO_CSID), this.cache.getBranches(), this.cache, this.status);
            timer.end();
        }
        catch (Exception e2) {
            Logs.APP_LOG.debug((Object)"error in metadata scanning, skipping");
        }
    }
}

