/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fecru.upgrade.UpgradeManager;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2ClientPool;
import com.atlassian.fisheye.svn.Svn2Scanner;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.BaseRepositoryEngine;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.NetworkRepositorySettings;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnChangeSet;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnPasswordSupplier;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnScmConfig;
import com.cenqua.fisheye.svn.SvnThrottledClientFactory;
import com.cenqua.fisheye.svn.db.SvnChangeSetDAO;
import com.cenqua.fisheye.util.Throttle;
import java.util.concurrent.atomic.AtomicInteger;

public class Svn2RepositoryEngine
extends BaseRepositoryEngine<Svn2Scanner, Svn2Cache> {
    private final SvnRepositoryInfo repositoryInfo;
    private final SvnScmConfig svnConfig;
    private final Svn2ClientPool clientPool;

    public Svn2RepositoryEngine(RepositoryConfig config, UpgradeManager upgradeManager, IndexingContext indexingContext) {
        super(config, upgradeManager, indexingContext);
        this.svnConfig = (SvnScmConfig)config.getScmConfig();
        this.repositoryInfo = new SvnRepositoryInfo(this.getCfg());
        NetworkRepositorySettings networkSettings = this.svnConfig.getNetworkSettings();
        SvnPasswordSupplier passwordSupplier = new SvnPasswordSupplier(networkSettings.getUsername(), networkSettings.getPassword(), this.getStatus());
        float throttleLimit = networkSettings.getCps();
        Throttle throttle = new Throttle();
        if (throttleLimit > 0.0f) {
            throttle.setOperationsPerSecond(throttleLimit);
        }
        SvnThrottledClientFactory throttledClientFactory = new SvnThrottledClientFactory(this.getCfg().getName(), throttle, this.repositoryInfo.getRepositoryURL(), passwordSupplier, this.repositoryInfo.getCommandTimeout(), this.getStatus().getRecentActivities());
        this.clientPool = new Svn2ClientPool(throttledClientFactory);
    }

    @Override
    protected void ensureCorrectScmVersion() throws ConfigException {
    }

    @Override
    protected Svn2Scanner createScanner() throws DbException, ConfigException {
        return new Svn2Scanner(this);
    }

    @Override
    protected Svn2Cache createCache(long cacheSerial) {
        return new Svn2Cache(cacheSerial, this.getDiskCacheVersion(), this.getDatabaseHandle(), this.getIndexConnection(), this.getLicenseEnforcer(), this.getIndexingContext(), this.repositoryInfo, this.clientPool);
    }

    @Override
    public String getLink(RevInfoKey revInfoKey) {
        return this.repositoryInfo.getPathURL(revInfoKey.getPath(), Long.parseLong(revInfoKey.getRev())) + "@" + revInfoKey.getRev();
    }

    @Override
    public void requestFullscan() {
    }

    @Override
    protected long getPollPeriod() {
        return this.svnConfig.getNetworkSettings().getPollPeriod();
    }

    public Svn2ClientPool getClientPool() {
        return this.clientPool;
    }

    public SvnRepositoryInfo getRepositoryInfo() {
        return this.repositoryInfo;
    }

    @Override
    public SvnLogicalPathMatcher getPathMatcher() {
        return this.svnConfig.getPathMatcher();
    }

    @Override
    public void requestStop() {
        super.requestStop();
        this.clientPool.stop();
    }

    @Override
    protected void initialiseRepositoryStatus() {
        long lastScanned;
        long target;
        super.initialiseRepositoryStatus();
        Svn2Cache cache = (Svn2Cache)this.getInternalRevisionCache();
        RepositoryStatus status = this.getStatus();
        if (!status.isInitialIndexingComplete() && (target = cache.getScanProperty(CommonProperties.INITIAL_INDEX_TARGET.value, -1L)) != -1L && (lastScanned = cache.getScanProperty(CommonProperties.PHASE1_SLURP.value, -1L)) >= target) {
            status.setInitialScanningComplete(true);
        }
        long lastInfilled = cache.getScanProperty(CommonProperties.LAST_INFILL.value, -1L);
        long lastWrapped = cache.getScanProperty(CommonProperties.LAST_WRAPUP.value, -1L);
        long earliestScanned = this.getEarliestInState(-1L, ChangeSetIndexingState.SCANNED);
        if (earliestScanned != -1L && lastInfilled != -1L && lastInfilled > earliestScanned) {
            lastInfilled = earliestScanned - 1L;
            cache.setScanProperty(CommonProperties.LAST_INFILL.value, lastInfilled);
            if (lastInfilled < lastWrapped) {
                lastWrapped = lastInfilled;
                cache.setScanProperty(CommonProperties.LAST_WRAPUP.value, lastWrapped);
            }
            status.setInitialIndexingComplete(false);
        }
        long earliestPreWrap = this.getEarliestInState(-1L, ChangeSetIndexingState.CONTENT_INDEXED);
        earliestPreWrap = this.getEarliestInState(earliestPreWrap, ChangeSetIndexingState.METADATA_INDEXED);
        if ((earliestPreWrap = this.getEarliestInState(earliestPreWrap, ChangeSetIndexingState.INFILLED)) != -1L && lastWrapped != -1L && lastWrapped > earliestPreWrap) {
            lastWrapped = earliestPreWrap - 1L;
            cache.setScanProperty(CommonProperties.LAST_WRAPUP.value, lastWrapped);
            status.setInitialIndexingComplete(false);
        }
        status.setIndexingUpToDate(lastWrapped == cache.getChangeSetDAO().getLastCsid());
    }

    @Override
    protected long getPausePeriodMillis() {
        return 120000L;
    }

    @Override
    public long getEffectivePollPeriod() {
        long pollPeriod = super.getEffectivePollPeriod();
        if (!(this.getStatus().isIndexingUpToDate() || pollPeriod != 0L && pollPeriod <= 60000L)) {
            pollPeriod = 60000L;
        }
        return pollPeriod;
    }

    public long getEarliestInState(long currentEarliest, ChangeSetIndexingState state) {
        long earliest = currentEarliest;
        if (((AtomicInteger)this.getStatus().getIndexingStateCounts().get((Object)state)).get() != 0) {
            SvnChangeSetDAO changeSetDAO = ((Svn2Cache)this.getInternalRevisionCache()).getChangeSetDAO();
            for (SvnChangeSet changeset : changeSetDAO.getChangeSetsInState(state)) {
                if (changeset == null && Boolean.getBoolean("fisheye.svn.earliest.in.state.ignore.missing.changesets")) {
                    Logs.APP_LOG.warn((Object)String.format("changeset is null but %s=true so continuing...", "fisheye.svn.earliest.in.state.ignore.missing.changesets"));
                    continue;
                }
                if (earliest != -1L && changeset.getLongId() >= earliest) continue;
                earliest = changeset.getLongId();
            }
        }
        return earliest;
    }
}

