/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fisheye.svn.Svn2Utils;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.callback.ListCallback;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.Info;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;

public class Svn2RepositoryClient {
    private final SvnRepositoryInfo repositoryInfo;
    private RepositoryStatus status;
    private final SvnThrottledClient client;

    public boolean isEmptyRepo() throws RepositoryClientException {
        final AtomicBoolean isEmpty = new AtomicBoolean(false);
        this.client.info(this.repositoryInfo.getLatestRepositoryRoot(), Revision.HEAD, Revision.HEAD, Depth.empty, new InfoCallback(){

            public void singleInfo(Info info) {
                if (info.getRev() == 0L && info.getLastChangedRev() == 0L) {
                    isEmpty.set(true);
                }
            }
        });
        return isEmpty.get();
    }

    public Svn2RepositoryClient(SvnRepositoryInfo repositoryInfo, RepositoryStatus status, SvnThrottledClient client) {
        this.repositoryInfo = repositoryInfo;
        this.status = status;
        this.client = client;
    }

    public long getFirstRevision() throws RepositoryClientException {
        final AtomicLong firstRev = new AtomicLong(-1L);
        List<RevisionRange> revRanges = Svn2Utils.createRevisionRange((Revision)new Revision.Number(0L), Revision.HEAD);
        this.client.logMessages(this.repositoryInfo.getLatestRepositoryRoot(), Revision.HEAD, revRanges, !this.repositoryInfo.isFollowBaseHistory(), false, false, null, 1L, new LogMessageCallback(){

            public void singleMessage(Set<ChangePath> changePaths, long revision, Map<String, byte[]> revProps, boolean b2) {
                firstRev.set(revision);
            }
        });
        if (firstRev.get() < 0L) {
            Logs.APP_LOG.warn((Object)"Unable to determine initial revision in repository");
        }
        if (firstRev.get() <= 0L) {
            return 1L;
        }
        return firstRev.get();
    }

    protected long getLatestRevision() throws RepositoryClientException {
        LatestRevisionCallback callback = new LatestRevisionCallback();
        this.client.info(this.repositoryInfo.getLatestRepositoryRoot(), Revision.HEAD, Revision.HEAD, Depth.empty, callback);
        final AtomicLong latestRevision = new AtomicLong(callback.getLatestRevision());
        if (latestRevision.get() < 0L) {
            this.client.list(this.repositoryInfo.getLatestRepositoryRoot(), Revision.HEAD, Revision.HEAD, Depth.immediates, -1, false, new ListCallback(){

                public void doEntry(DirEntry dirEntry, Lock lock) {
                    if (dirEntry.getLastChangedRevisionNumber() > latestRevision.get()) {
                        latestRevision.set(dirEntry.getLastChangedRevisionNumber());
                    }
                }
            });
        }
        if (latestRevision.get() < 0L) {
            throw new RepositoryClientException("Unable to determine latest revision of the Subversion repository: " + this.repositoryInfo.getRepositoryDescriptor());
        }
        return latestRevision.get();
    }

    public SortedIntSet getChangesetIds(long startRevision) throws RepositoryClientException {
        final SegmentedIntSet csids = new SegmentedIntSet();
        Revision.Number startRev = new Revision.Number(startRevision);
        List<RevisionRange> revRanges = Svn2Utils.createRevisionRange((Revision)startRev, Revision.HEAD);
        this.client.logMessages(this.repositoryInfo.getLatestRepositoryRoot(), Revision.HEAD, revRanges, !this.repositoryInfo.isFollowBaseHistory(), false, false, null, 0L, new LogMessageCallback(){

            public void singleMessage(Set<ChangePath> changePaths, long revision, Map<String, byte[]> propertyMap, boolean b2) {
                Svn2RepositoryClient.this.status.throwOnStopRequested();
                csids.set((int)revision);
            }
        });
        return csids;
    }

    private static class LatestRevisionCallback
    implements InfoCallback {
        long latestRevision = -1L;

        private LatestRevisionCallback() {
        }

        public void singleInfo(Info info) {
            this.latestRevision = info.getRev();
        }

        public long getLatestRevision() {
            return this.latestRevision;
        }
    }
}

