/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2ChangesetProcessor;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.crossrepo.PathIndexer;
import com.cenqua.fisheye.infinitydb.DbTask;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.svn.db.SvnChangeSetDAO;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.obfuscate.idb.ac;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongSortedSet;

public class Svn2MetadataProcessor
extends Svn2ChangesetProcessor {
    @Override
    protected ChangeSetIndexingState getResultingState() {
        return ChangeSetIndexingState.METADATA_INDEXED;
    }

    @Override
    protected long getVersion() {
        return 29L;
    }

    @Override
    protected int getDbLockPriority() {
        return 40;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processChangesets(Svn2RepositoryEngine engine, final LongSortedSet csids) throws LicensePolicyException {
        if (csids.isEmpty()) {
            return true;
        }
        Timer timer = new Timer("Indexing metadata for " + csids.firstLong() + " to " + csids.lastLong());
        Svn2Cache cache = (Svn2Cache)engine.getInternalRevisionCache();
        final SvnChangeSetDAO changesetDAO = cache.getChangeSetDAO();
        PathIndexer pathIndexer = engine.getIndexingContext().getPathCrossRepoIndexer();
        try {
            pathIndexer.indexPathsForChangeSetIds(engine.getRepositoryInfo().getRepositoryName(), cache, Iterables.transform((Iterable)csids, (Function)Functions.toStringFunction()), engine.getPathMatcher(), null);
            cache.withDbWriteLock(this.getDbLockPriority(), new DbTask<Void>(){

                @Override
                public Void perform(ac itemSpace) {
                    LongBidirectionalIterator longBidirectionalIterator = csids.iterator();
                    while (longBidirectionalIterator.hasNext()) {
                        long csid = (Long)longBidirectionalIterator.next();
                        Svn2MetadataProcessor.this.updateIndexingState(changesetDAO, csid);
                    }
                    return null;
                }
            });
            boolean bl = true;
            return bl;
        }
        finally {
            timer.end();
        }
    }
}

