/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fisheye.spi.admin.data.ImportMode;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2ClientPool;
import com.atlassian.fisheye.svn.Svn2FileHistory;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.LineCountState;
import com.cenqua.fisheye.svn.SvnAction;
import com.cenqua.fisheye.svn.SvnChangePath;
import com.cenqua.fisheye.svn.SvnLogMessage;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.svn.db.SvnRevInfoDAO;
import com.cenqua.fisheye.svn.util.ChangePathUtil;
import com.cenqua.fisheye.util.CustomFileNameMap;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.obfuscate.idb.ac;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.NodeKind;

public class Svn2MessageContext {
    private final Svn2ClientPool clientPool;
    private final SvnRepositoryInfo repositoryInfo;
    private final RepositoryStatus status;
    private final SvnLogMessage message;
    private final Svn2Cache cache;
    private final Svn2RepositoryEngine engine;
    private final SvnRevInfoDAO fileRevisionDAO;
    private final boolean startRevWithNoImport;
    private Map<Path, Integer> fileTypeMap;
    private Map<String, String> revProps;
    private ac db;
    private final List<SvnChangePath> changePaths = new ArrayList<SvnChangePath>();
    private DiffTextCache diffTextCache;
    private Set<Path> updatedPaths = new HashSet<Path>();

    public Svn2MessageContext(Svn2RepositoryEngine engine, DiffTextCache diffTextCache, SvnLogMessage message) {
        this.engine = engine;
        this.diffTextCache = diffTextCache;
        this.clientPool = engine.getClientPool();
        this.repositoryInfo = engine.getRepositoryInfo();
        this.status = engine.getStatus();
        this.message = message;
        this.cache = (Svn2Cache)engine.getInternalRevisionCache();
        if (message.getChangePaths() != null) {
            this.changePaths.addAll(message.getChangePaths());
        }
        this.fileRevisionDAO = this.cache.getFileRevisionDAO();
        this.startRevWithNoImport = this.repositoryInfo.getStartRev() > 0L && this.repositoryInfo.getImportMode() == ImportMode.NO_IMPORT;
    }

    public Svn2RepositoryEngine getEngine() {
        return this.engine;
    }

    public long getRevision() {
        return this.message.getRevisionNumber();
    }

    public String getAuthor() {
        return this.message.getAuthor();
    }

    public long getDate() {
        return this.message.getDate().getTime();
    }

    public String getCommitMessage() {
        return this.message.getMessage();
    }

    public Iterable<SvnChangePath> getChangePaths() {
        return this.changePaths;
    }

    private boolean isApplicableChangePath(String serverPath, SvnChangePath changePath) {
        return changePath.getPath().equals(serverPath) || ChangePathUtil.isSubPath(changePath.getPath(), serverPath);
    }

    public SvnChangePath getMostSpecificChange(Path localPath) {
        SvnChangePath mostSpecific = null;
        if (this.message.getChangePaths() != null) {
            String serverPath = this.repositoryInfo.getServerPath(localPath, this.message.getRevisionNumber());
            for (SvnChangePath changePath : this.message.getChangePaths()) {
                if (!this.isApplicableChangePath(serverPath, changePath) || mostSpecific != null && changePath.getPath().length() <= mostSpecific.getPath().length()) continue;
                mostSpecific = changePath;
            }
        }
        return mostSpecific;
    }

    public List<SvnChangePath> getApplicableChangePaths(SvnChangePath checkPath) {
        ArrayList<SvnChangePath> result = new ArrayList<SvnChangePath>();
        if (this.message.getChangePaths() != null) {
            for (SvnChangePath changePath : this.message.getChangePaths()) {
                if (!this.isApplicableChangePath(checkPath.getPath(), changePath)) continue;
                result.add(changePath);
            }
        }
        return result;
    }

    public Path getLocalPath(SvnChangePath changePath) {
        return this.repositoryInfo.getLocalPath(changePath.getPath(), this.getRevision());
    }

    public boolean isPathMoved(String serverPath) {
        return this.getMoveDestination(serverPath) != null;
    }

    public Pair<SvnChangePath, SvnChangePath> getMoveChangePaths(String serverPath) {
        SvnChangePath deletingChange = null;
        SvnChangePath addingSourceChange = null;
        if (this.message.getChangePaths() != null) {
            for (SvnChangePath changePath : this.message.getChangePaths()) {
                boolean moreSpecific;
                ChangePath.Action action = changePath.getAction();
                if (ChangePathUtil.isSubPath(changePath.getPath(), serverPath)) {
                    boolean deleteAction = action == ChangePath.Action.delete || action == ChangePath.Action.replace;
                    boolean bl = moreSpecific = deletingChange == null || changePath.getPath().length() > deletingChange.getPath().length();
                    if (deleteAction && moreSpecific) {
                        deletingChange = changePath;
                    } else if (!deleteAction && moreSpecific) {
                        deletingChange = null;
                    }
                }
                if (changePath.getCopySrcPath() == null || !ChangePathUtil.isSubPath(changePath.getCopySrcPath(), serverPath)) continue;
                boolean addAction = action == ChangePath.Action.add || action == ChangePath.Action.replace;
                boolean bl = moreSpecific = addingSourceChange == null || changePath.getPath().length() > addingSourceChange.getPath().length();
                if (addAction && moreSpecific) {
                    addingSourceChange = changePath;
                    continue;
                }
                if (action != ChangePath.Action.delete || !moreSpecific) continue;
                addingSourceChange = null;
            }
        }
        if (deletingChange == null || addingSourceChange == null) {
            return null;
        }
        return Pair.newInstance(deletingChange, addingSourceChange);
    }

    public String getMoveDestination(String serverPath) {
        Pair<SvnChangePath, SvnChangePath> movePair = this.getMoveChangePaths(serverPath);
        if (movePair == null) {
            return null;
        }
        return this.getMoveDestination(movePair, serverPath);
    }

    public String getMoveDestination(Pair<SvnChangePath, SvnChangePath> movePair, String serverPath) {
        String subPath = ChangePathUtil.getRelativePath(movePair.getFirst().getPath(), serverPath);
        return movePair.getSecond().getPath() + subPath;
    }

    public Map<String, String> getRevProps() {
        if (this.revProps == null) {
            this.revProps = this.message.getRevProps();
            this.revProps.remove("svn:date");
            this.revProps.remove("svn:author");
            this.revProps.remove("svn:log");
        }
        return this.revProps;
    }

    public int getFileType(Path path) throws RepositoryClientException {
        if (this.fileTypeMap == null) {
            this.createFileTypeMap();
        }
        if (this.fileTypeMap.containsKey(path)) {
            return this.fileTypeMap.get(path);
        }
        return 1;
    }

    private void createFileTypeMap() throws RepositoryClientException {
        this.fileTypeMap = new HashMap<Path, Integer>();
        HashSet<SvnChangePath> unknownNodeKinds = new HashSet<SvnChangePath>();
        this.fileTypeMap.put(Path.ROOT, 2);
        for (SvnChangePath changePath : this.message.getChangePaths()) {
            this.getStatus().throwOnStopRequested();
            NodeKind nodeKind = changePath.getNodeKind();
            Path path = this.repositoryInfo.getLocalPath(changePath.getPath(), this.getRevision());
            if (!this.repositoryInfo.isPathInRepo(path)) continue;
            if (nodeKind == NodeKind.dir || nodeKind == NodeKind.file) {
                this.fileTypeMap.put(path, this.getFileTypeFromNodeKind(nodeKind));
                continue;
            }
            if (path.isRoot()) {
                this.fileTypeMap.put(path, 2);
                continue;
            }
            for (SvnChangePath subPath : this.message.getChangePaths()) {
                if (!ChangePathUtil.isStrictSubPath(changePath.getPath(), subPath.getPath())) continue;
                this.fileTypeMap.put(path, 2);
                this.updateFiletypeAsDir(path);
                break;
            }
            if (this.fileTypeMap.containsKey(path)) continue;
            unknownNodeKinds.add(changePath);
        }
        if (!unknownNodeKinds.isEmpty()) {
            for (SvnChangePath changePath : unknownNodeKinds) {
                Path path = this.repositoryInfo.getLocalPath(changePath.getPath(), this.getRevision());
                SvnRevInfo latestRev = this.cache.getLatestFileRevision(path);
                if (latestRev != null && !latestRev.isDead()) {
                    this.fileTypeMap.put(path, latestRev.isFile() ? 1 : 2);
                } else if (changePath.getCopySrcPath() != null) {
                    long srcRevision = changePath.getCopySrcRevision();
                    Path sourcePath = this.repositoryInfo.getLocalPath(changePath.getCopySrcPath(), srcRevision);
                    long sourceCsid = this.fileRevisionDAO.getLatestPathChangeUpto(sourcePath, srcRevision, true);
                    FileRevision sourceRev = this.cache.getFileRevision(new RevInfoKey(path, Long.toString(sourceCsid)));
                    if (sourceRev != null) {
                        this.fileTypeMap.put(path, sourceRev.isFile() ? 1 : 2);
                    }
                }
                if (!this.fileTypeMap.containsKey(path)) {
                    this.fileTypeMap.put(path, 1);
                }
                if (path.isRoot()) continue;
                this.updateFiletypeAsDir(path.getParent());
            }
        }
    }

    public void updateFiletypeAsDir(Path path) {
        if (this.updatedPaths.contains(path)) {
            return;
        }
        block0: do {
            FileRevision revision;
            FileRevision revision2;
            this.updatedPaths.add(path);
            long latestCsid = this.fileRevisionDAO.getLatestPathChangeUpto(path, this.getRevision(), false);
            if (latestCsid == -1L) continue;
            if (this.fileRevisionDAO.isDir(this.fileRevisionDAO.getRevId(path, latestCsid))) break;
            Svn2FileHistory history = this.cache.getFileHistory(path, true);
            TreeMultimap headMap = TreeMultimap.create();
            SortedMap hmap = history.getRevisionMap().asMap().headMap(this.getRevision());
            for (Map.Entry entry : hmap.entrySet()) {
                headMap.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
            }
            ArrayList fileRevisions = new ArrayList(headMap.values());
            ListIterator iterator = fileRevisions.listIterator(fileRevisions.size());
            while (iterator.hasPrevious() && !(revision2 = (FileRevision)iterator.previous()).isDir() && !revision2.isDead()) {
                this.fileRevisionDAO.updateFileType(revision2.getRevID(), 2);
            }
            TreeMultimap tailMap = TreeMultimap.create();
            SortedMap tmap = history.getRevisionMap().asMap().tailMap(this.getRevision());
            for (Map.Entry entry : tmap.entrySet()) {
                tailMap.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
            }
            Iterator iterator2 = tailMap.values().iterator();
            while (iterator2.hasNext() && !(revision = (FileRevision)((Object)iterator2.next())).isDir()) {
                this.fileRevisionDAO.updateFileType(revision.getRevID(), 2);
                if (!revision.isDead()) continue;
                continue block0;
            }
        } while (!(path = path.getParent()).isRoot());
    }

    public int getFileTypeFromNodeKind(NodeKind nodeKind) {
        switch (nodeKind) {
            case dir: {
                return 2;
            }
            case file: {
                return 1;
            }
            case unknown: {
                return -1;
            }
            case none: {
                return -1;
            }
        }
        return -1;
    }

    public String getRepositoryRoot() {
        return this.repositoryInfo.getRepositoryRoot(this.getRevision());
    }

    public SvnRepositoryInfo getRepositoryInfo() {
        return this.repositoryInfo;
    }

    public Svn2ClientPool getClientPool() {
        return this.clientPool;
    }

    public SvnRevInfo createFileRevision(Path physicalPath) {
        SvnRevInfo revision = new SvnRevInfo();
        revision.setSVNRevision(this.getRevision());
        revision.setAuthor(this.getAuthor());
        revision.setDate(this.getDate());
        revision.setComment(this.getCommitMessage());
        revision.setPath(physicalPath);
        revision.setLineCountState(LineCountState.NONE);
        this.setPathInfo(revision);
        revision.setFileType(1);
        return revision;
    }

    public void setPathInfo(SvnRevInfo revision) {
        Path path;
        SvnLogicalPathMatcher pathMatcher = this.repositoryInfo.getPathMatcher();
        boolean isTrunkLike = !pathMatcher.isTag(path = revision.getPath()) && !pathMatcher.isBranch(path);
        revision.addBranch(this.repositoryInfo.getPathMatcher().getEffectiveBranch(path));
        revision.setTrunkLike(isTrunkLike);
        revision.setLogicalPath(pathMatcher.getLogicalPath(path));
    }

    public void setDb(ac db) {
        this.db = db;
    }

    public CustomFileNameMap getFileNameMap() {
        return this.repositoryInfo.getSvnConfig().getRootConfig().getRawMimeMap();
    }

    public boolean isPartOfAdd(SvnChangePath changePath) {
        List<SvnChangePath> applicablePaths = this.getApplicableChangePaths(changePath);
        if (applicablePaths.size() <= 1) {
            return false;
        }
        for (SvnChangePath applicablePath : applicablePaths) {
            if (applicablePath.equals(changePath) || !SvnAction.isAddAction(applicablePath.getAction())) continue;
            return true;
        }
        return false;
    }

    public int insertFileRevision(SvnRevInfo svnRevInfo) throws DbException, LicensePolicyException {
        if (this.db == null) {
            throw new IllegalStateException("DB Write lock is not held");
        }
        Path path = svnRevInfo.getPath();
        int existingRevid = this.fileRevisionDAO.getPureRevId(path, svnRevInfo.getSvnRevision());
        if (existingRevid != -1) {
            Logs.APP_LOG.error((Object)("Attempting to insert a revision which already exists for " + svnRevInfo.getRevInfoKey()));
            return -1;
        }
        SvnLogicalPathMatcher pathMatcher = this.repositoryInfo.getPathMatcher();
        boolean tagRevision = false;
        if (pathMatcher.isTag(path)) {
            boolean bl = tagRevision = !svnRevInfo.isCopy() || pathMatcher.isTagRoot(path);
        }
        if (this.startRevWithNoImport) {
            this.createParentDirs(path);
        }
        int revid = this.fileRevisionDAO.insertNew(svnRevInfo, (AncestorLink)null, !tagRevision);
        if (tagRevision) {
            String tag = pathMatcher.getTag(path);
            this.fileRevisionDAO.addTag(revid, tag);
        }
        return revid;
    }

    private void createParentDirs(Path path) throws DbException, LicensePolicyException {
        Path parentPath = path.getParent();
        if (path.equals(Path.ROOT) || this.fileRevisionDAO.getLatestPathChange(parentPath) != -1L) {
            return;
        }
        SvnChangePath existingParentInCommit = this.getMostSpecificChange(parentPath);
        Path existingParentPath = existingParentInCommit != null ? this.getLocalPath(existingParentInCommit) : Path.ROOT;
        List<String> dirComponents = Arrays.asList(parentPath.getComponents());
        Logs.APP_LOG.debug((Object)("Creating non existing parents between existing " + existingParentInCommit + " and path " + path));
        Path dirPath = existingParentPath;
        for (String dirComponent : dirComponents.subList(existingParentPath.numComponents(), dirComponents.size())) {
            long csid = this.fileRevisionDAO.getLatestPathChange(dirPath = new Path(dirPath, dirComponent));
            if (csid != -1L) continue;
            SvnRevInfo dir = this.createFileRevision(dirPath);
            dir.setFileType(2);
            this.fileRevisionDAO.insertNew(dir, (AncestorLink)null, false);
        }
    }

    public void updateRevision(int revid, SvnRevInfo revision) {
        SvnRevInfoDAO fileRevDAO = this.fileRevisionDAO;
        fileRevDAO.updateAuthor(revid, revision.getAuthor());
        fileRevDAO.updateComment(revid, revision.getComment());
        fileRevDAO.updateDate(revid, revision.getDate());
        fileRevDAO.updateState(revid, revision);
        fileRevDAO.updateCopySource(revid, revision);
        fileRevDAO.updateLineCount(revid, revision.getLineCount(), revision.getLinesAdded(), revision.getLinesRemoved(), revision.getLineCountState());
        fileRevDAO.storeSvnProperties(revid, revision.getProperties());
        fileRevDAO.updateBinary(revid, revision.isBinary());
    }

    public RepositoryStatus getStatus() {
        return this.status;
    }

    public DiffTextCache getDiffTextCache() {
        return this.diffTextCache;
    }

    public boolean isStartRevWithNoImport() {
        return this.startRevWithNoImport;
    }
}

