/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fisheye.RuntimeWrappedException;
import com.atlassian.fisheye.svn.Svn2MessageContext;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.svn.RepositoryWalker;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.util.DuplicatingOutputStream;
import com.cenqua.fisheye.util.LineCountingInputStream;
import com.cenqua.fisheye.util.LineCountingOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.subversion.javahl.callback.ProplistCallback;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.Info;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;

public class Svn2InitialImportVisitor
implements RepositoryWalker.Visitor {
    private final Svn2MessageContext context;
    private DiffTextCache diffTextCache;
    private final RepositoryStatus status;
    private final SvnRepositoryInfo repositoryInfo;
    private final Set<String> branches = new HashSet<String>();
    private final SvnLogicalPathMatcher pathMatcher;

    public Svn2InitialImportVisitor(Svn2MessageContext context, DiffTextCache diffTextCache, RepositoryStatus status) {
        this.context = context;
        this.diffTextCache = diffTextCache;
        this.status = status;
        this.repositoryInfo = context.getRepositoryInfo();
        this.pathMatcher = this.repositoryInfo.getPathMatcher();
    }

    private SvnRevInfo createRev(Path physicalPath, NodeKind nodeKind) {
        SvnRevInfo rev = null;
        if (this.repositoryInfo.isPathInRepo(physicalPath)) {
            if (!this.pathMatcher.isTag(physicalPath) || this.pathMatcher.isTagRoot(physicalPath)) {
                this.status.setMessage("Importing " + physicalPath);
                rev = this.context.createFileRevision(physicalPath);
                rev.setFileType(nodeKind == NodeKind.dir ? 2 : 1);
                rev.setAdded(true);
            }
            this.branches.add(this.pathMatcher.getEffectiveBranch(physicalPath));
        }
        return rev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean visitRemoteEntry(SvnThrottledClient client, Path localPath, long revision, Info info) throws RepositoryClientException, IOException, DbException {
        block13: {
            SvnRevInfo revInfo;
            block14: {
                this.status.throwOnStopRequested();
                if (!this.repositoryInfo.isPathInRepo(localPath)) {
                    return false;
                }
                String tag = this.repositoryInfo.getPathMatcher().getTag(localPath);
                if (tag != null) {
                    return false;
                }
                String pathURL = this.repositoryInfo.getPathURL(localPath, revision);
                Revision.Number rev = new Revision.Number(revision);
                revInfo = this.createRev(localPath, info.getKind());
                if (revInfo == null) break block13;
                client.properties(pathURL, (Revision)rev, (Revision)rev, Depth.empty, null, new ProplistCallback(){

                    public void singlePath(String path, Map<String, byte[]> properties) {
                        revInfo.setProperties(properties, Svn2InitialImportVisitor.this.context.getFileNameMap());
                    }
                });
                if (revInfo.getFileType() == 1) {
                    LineCountingOutputStream lcos;
                    DuplicatingOutputStream dos;
                    boolean isOversize;
                    boolean bl = isOversize = !this.repositoryInfo.isOfIndexableSize(localPath, info.getReposSize(), String.valueOf(revision));
                    if (isOversize) {
                        revInfo.setOversize(true);
                    } else {
                        dos = new DuplicatingOutputStream();
                        lcos = new LineCountingOutputStream();
                        dos.addClient(new LineCountingOutputStream());
                        dos.addClient(this.diffTextCache);
                        try {
                            this.diffTextCache.startFileRevision(true, revInfo);
                            client.streamFileContent(pathURL, (Revision)rev, (Revision)rev, dos);
                            this.diffTextCache.finishFileRevision();
                        }
                        catch (RepositoryClientException e2) {
                            Logs.APP_LOG.warn((Object)("Unable to get initial content for " + localPath), (Throwable)e2);
                        }
                        this.setRevisionLineInfo(revInfo, lcos.getLineCount(), lcos.getLineCount(), 0, revInfo.getTmpDiffAddedFile(), revInfo.getTmpDiffRemovedFile());
                        IOHelper.close(dos, lcos);
                    }
                    break block14;
                    catch (IOException e2) {
                        try {
                            Logs.APP_LOG.warn((Object)("Unable to get initial content for " + localPath), (Throwable)e2);
                        }
                        catch (Throwable throwable) {
                            IOHelper.close(dos, lcos);
                            throw throwable;
                        }
                        IOHelper.close(dos, lcos);
                    }
                }
            }
            revInfo.createAdditionHunk();
            try {
                this.status.setMessage("Creating changeset " + this.context.getRevision() + " - importing " + localPath);
                this.context.insertFileRevision(revInfo);
            }
            catch (LicensePolicyException e3) {
                throw new RuntimeWrappedException(e3);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean visitWorkingCopyEntry(SvnThrottledClient client, File wcFile, Info fileInfo, long revision) throws RepositoryClientException, IOException, DbException {
        this.status.throwOnStopRequested();
        Path localPath = this.repositoryInfo.pathFromInfo(fileInfo, revision);
        Revision.Number rev = new Revision.Number(revision);
        final SvnRevInfo svnRevInfo = this.createRev(localPath, fileInfo.getKind());
        if (svnRevInfo != null) {
            block10: {
                client.properties(wcFile.getAbsolutePath(), (Revision)rev, (Revision)rev, Depth.empty, null, new ProplistCallback(){

                    public void singlePath(String path, Map<String, byte[]> properties) {
                        svnRevInfo.setProperties(properties, Svn2InitialImportVisitor.this.context.getFileNameMap());
                    }
                });
                if (fileInfo.getKind() == NodeKind.file) {
                    LineCountingInputStream lcis;
                    FileInputStream fis;
                    boolean isOversize;
                    boolean bl = isOversize = !this.repositoryInfo.isOfIndexableSize(localPath, wcFile.length(), String.valueOf(revision));
                    if (isOversize) {
                        svnRevInfo.setOversize(true);
                    } else {
                        fis = null;
                        lcis = null;
                        svnRevInfo.setTmpDiffAddedFile(wcFile);
                        fis = new FileInputStream(wcFile);
                        lcis = new LineCountingInputStream(fis);
                        lcis.readFully();
                        this.setRevisionLineInfo(svnRevInfo, lcis.getLineCount(), lcis.getLineCount(), 0, wcFile, null);
                        IOHelper.close(fis);
                        IOHelper.close(lcis);
                    }
                    break block10;
                    catch (IOException e2) {
                        try {
                            Logs.APP_LOG.warn((Object)("Unable to get content info for working copy file: " + wcFile.getAbsolutePath()), (Throwable)e2);
                        }
                        catch (Throwable throwable) {
                            IOHelper.close(fis);
                            IOHelper.close(lcis);
                            throw throwable;
                        }
                        IOHelper.close(fis);
                        IOHelper.close(lcis);
                    }
                }
            }
            svnRevInfo.createAdditionHunk();
            try {
                this.status.setMessage("Creating changeset " + this.context.getRevision() + " - importing " + localPath);
                this.context.insertFileRevision(svnRevInfo);
            }
            catch (LicensePolicyException e3) {
                throw new RuntimeWrappedException(e3);
            }
        }
        return true;
    }

    private void setRevisionLineInfo(SvnRevInfo revision, int lineCount, int numAdded, int numRemoved, File tmpAdded, File tmpRemoved) {
        revision.setLineCount(lineCount);
        revision.setLinesAdded(numAdded);
        revision.setLinesRemoved(numRemoved);
        revision.setTmpDiffAddedFile(tmpAdded);
        revision.setTmpDiffRemovedFile(tmpRemoved);
    }

    public Set<String> getBranches() {
        return this.branches;
    }
}

