/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fisheye.RuntimeWrappedException;
import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.pipeline.ChangeSetEntry;
import com.atlassian.fisheye.pipeline.ChangeSetPipeline;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2ChangesetDiffSummary;
import com.atlassian.fisheye.svn.Svn2MessageContext;
import com.atlassian.fisheye.svn.Svn2PropertyChanges;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.atlassian.fisheye.svn.Svn2Utils;
import com.atlassian.fisheye.svn.SvnPathInfo;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.infinitydb.DbTask;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.LineReader;
import com.cenqua.fisheye.io.ReaderLineReader;
import com.cenqua.fisheye.io.Utf16ERandomAccessIoStream;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.LineCountState;
import com.cenqua.fisheye.svn.SvnAction;
import com.cenqua.fisheye.svn.SvnChangePath;
import com.cenqua.fisheye.svn.SvnChangeSet;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnMimeUtils;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.svn.db.SvnChangeSetDAO;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.svn.db.SvnRevInfoDAO;
import com.cenqua.fisheye.svn.diff.ChangeInfo;
import com.cenqua.fisheye.svn.diff.DiffListener;
import com.cenqua.fisheye.svn.diff.SvnDiffParser;
import com.cenqua.fisheye.svn.diff.SvnDiffParsingException;
import com.cenqua.fisheye.svn.util.SvnPropertyUtil;
import com.cenqua.fisheye.svn.util.SvnRepositoryPathUtil;
import com.cenqua.fisheye.svn.util.SvnURLDecoder;
import com.cenqua.fisheye.util.CustomFileNameMap;
import com.cenqua.fisheye.util.LineCountingInputStream;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.web.rdiff.PatchPrinter;
import com.cenqua.obfuscate.idb.ac;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.subversion.javahl.DiffSummary;
import org.apache.subversion.javahl.callback.DiffSummaryCallback;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.callback.ProplistCallback;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.Info;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;

public class Svn2Infill2Processor {
    public static final Revision START_REV_0 = new Revision.Number(0L);
    private final Svn2RepositoryEngine engine;
    private final SvnRepositoryInfo repositoryInfo;
    private final SvnRepositoryPathUtil svnRepositoryPathUtil = new SvnRepositoryPathUtil();

    public Svn2Infill2Processor(Svn2RepositoryEngine engine) {
        this.engine = engine;
        this.repositoryInfo = engine.getRepositoryInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(final long timeLimitMillis) throws RepositoryClientException, LicensePolicyException, IOException {
        AtomicLong lastCsProcessed;
        final Svn2Cache cache = (Svn2Cache)this.engine.getInternalRevisionCache();
        final SvnChangeSetDAO changeSetDAO = cache.getChangeSetDAO();
        long startRevision = cache.hasScanProperty(CommonProperties.LAST_INFILL.value) ? cache.getScanProperty(CommonProperties.LAST_INFILL.value, 0L) + 1L : this.repositoryInfo.getStartRev();
        final ChangeSetPipeline pipeline = this.engine.getIndexingContext().getChangeSetPipeline();
        final AtomicLong pipelineEntryStart = new AtomicLong(-1L);
        final AtomicLong pipelineEntryEnd = new AtomicLong(-1L);
        final AtomicLong pipelineTimestamp = new AtomicLong(-1L);
        final AtomicInteger pipelineEntryCount = new AtomicInteger(0);
        do {
            final SortedSet<Long> changesetIds = changeSetDAO.getSvnChangeSetIdsWithLimit(startRevision, 1000L, false);
            lastCsProcessed = new AtomicLong(-1L);
            try {
                if (changesetIds.isEmpty()) continue;
                cache.withDbWriteLock(40, new DbTask<Void>(){

                    @Override
                    public Void perform(ac itemSpace) {
                        try {
                            Iterator iterator = changesetIds.iterator();
                            while (iterator.hasNext()) {
                                long csid = (Long)iterator.next();
                                Svn2Infill2Processor.this.engine.getStatus().throwOnStopRequested();
                                Svn2Infill2Processor.this.engine.getStatus().setMessage("Expanding paths of changeset " + csid);
                                SvnChangeSet changeset = (SvnChangeSet)changeSetDAO.getChangeSet(Long.toString(csid));
                                if (changeset == null) {
                                    Logs.APP_LOG.warn((Object)("Unable to find changeset " + csid + " for infill processing"));
                                    continue;
                                }
                                Logs.APP_LOG.debug((Object)("Adding CSID for innfilling: " + csid));
                                Svn2MessageContext context = Svn2Utils.recreateMessageContext(Svn2Infill2Processor.this.engine, changeset);
                                context.setDb(itemSpace);
                                Svn2Infill2Processor.this.infillChangeSet(cache, context);
                                changeSetDAO.setIndexingState(Long.toString(csid), ChangeSetIndexingState.INFILLED);
                                lastCsProcessed.set(csid);
                                long currentStart = pipelineEntryStart.get();
                                if (currentStart == -1L || csid < currentStart) {
                                    pipelineEntryStart.set(csid);
                                }
                                if (csid > pipelineEntryEnd.get()) {
                                    pipelineEntryEnd.set(csid);
                                }
                                pipelineTimestamp.set(changeset.getDate());
                                if (pipelineEntryCount.incrementAndGet() >= Svn2Infill2Processor.this.engine.getPipelineBatchSize()) {
                                    Logs.APP_LOG.debug((Object)("Submitting CSIDs: " + pipelineEntryStart.get() + " to " + pipelineEntryEnd.get()));
                                    Svn2Infill2Processor.this.submitPipelineEntries(pipeline, pipelineEntryStart, pipelineEntryEnd, pipelineTimestamp);
                                    pipelineEntryCount.set(0);
                                }
                                if (System.currentTimeMillis() <= timeLimitMillis) continue;
                                break;
                            }
                            if (lastCsProcessed.get() != -1L) {
                                cache.setScanProperty(CommonProperties.LAST_INFILL.value, lastCsProcessed.get());
                            }
                            return null;
                        }
                        catch (RepositoryClientException e2) {
                            throw new RuntimeWrappedException(e2);
                        }
                        catch (LicensePolicyException e3) {
                            throw new RuntimeWrappedException(e3);
                        }
                        catch (IOException e4) {
                            throw new RuntimeWrappedException(e4);
                        }
                    }
                });
            }
            catch (RuntimeWrappedException e2) {
                e2.rethrowCause(RepositoryClientException.class);
                e2.rethrowCause(LicensePolicyException.class);
                e2.rethrowCause(IOException.class);
                e2.rethrowAsRuntime();
            }
            finally {
                this.engine.getStatus().setMessage("");
            }
        } while ((startRevision = lastCsProcessed.get() + 1L) > 0L && System.currentTimeMillis() < timeLimitMillis);
        if (pipelineEntryStart.get() != -1L) {
            this.submitPipelineEntries(pipeline, pipelineEntryStart, pipelineEntryEnd, pipelineTimestamp);
        }
    }

    private void submitPipelineEntries(ChangeSetPipeline pipeline, AtomicLong pipelineEntryStart, AtomicLong pipelineEntryEnd, AtomicLong pipelineTimestamp) {
        String start = Long.toString(pipelineEntryStart.get());
        String end = Long.toString(pipelineEntryEnd.get());
        Logs.APP_LOG.debug((Object)("Adding " + start + " - " + end + " to pipeline"));
        pipeline.put(new ChangeSetEntry(this.engine.getName(), pipelineTimestamp.get(), start, end));
        pipelineEntryStart.set(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void infillChangeSet(Svn2Cache cache, final Svn2MessageContext context) throws RepositoryClientException, LicensePolicyException, IOException {
        final SvnRevInfoDAO fileRevisionDAO = ((Svn2Cache)context.getEngine().getInternalRevisionCache()).getFileRevisionDAO();
        SvnThrottledClient client = this.engine.getClientPool().allocateClient();
        try {
            Svn2ChangesetDiffSummary changesetDiffSummary = this.createDiffSummary(context, client);
            final Svn2PropertyChanges propertyChanges = this.getPropertyChanges(context, client, changesetDiffSummary.getPropertyChanges());
            Set<Path> dirsToUpdate = this.getUnmarkedDirectories(context, changesetDiffSummary);
            for (Path dir : dirsToUpdate) {
                context.updateFiletypeAsDir(dir);
            }
            for (Path path : changesetDiffSummary.getAllPaths()) {
                context.getStatus().throwOnStopRequested();
                SvnRevInfoDAO.SvnRevisionSummary previousRev = this.getPreviousRevision(context, fileRevisionDAO, path);
                if (previousRev != null) {
                    changesetDiffSummary.setParentBinaryOversize(path, previousRev.isOversize(), previousRev.isBinary());
                    continue;
                }
                changesetDiffSummary.setPreviousRevMissing(path, true);
            }
            final ArrayList<Path> deletedPaths = new ArrayList<Path>();
            Visitor<SvnRevInfoDAO.SvnRevisionSummary> deletedPathVisitor = new Visitor<SvnRevInfoDAO.SvnRevisionSummary>(){

                @Override
                public void visit(SvnRevInfoDAO.SvnRevisionSummary revision) {
                    deletedPaths.add(revision.getPath());
                }
            };
            Visitor<SvnRevInfoDAO.SvnRevisionSummary> propertyVisitor = new Visitor<SvnRevInfoDAO.SvnRevisionSummary>(){

                @Override
                public void visit(SvnRevInfoDAO.SvnRevisionSummary revision) {
                    SvnRevInfoDAO.SvnRevisionSummary previousRev;
                    Map<String, String> properties = Collections.emptyMap();
                    Path path = revision.getPath();
                    if (propertyChanges.isPathPropertiesChanged(path)) {
                        properties = propertyChanges.getPathProperties().get(path);
                    } else if (!revision.isAdded() && (previousRev = Svn2Infill2Processor.this.getPreviousRevision(context, fileRevisionDAO, path)) != null) {
                        properties = previousRev.getProperties();
                    }
                    int revid = revision.getRevID();
                    fileRevisionDAO.storeSvnProperties(revid, properties);
                    if (properties != null && properties.containsKey("svn:mime-type")) {
                        String mimeType = properties.get("svn:mime-type");
                        fileRevisionDAO.updateBinary(revid, SvnMimeUtils.isBinaryMimeType(context.getFileNameMap(), mimeType));
                    }
                }
            };
            this.visitAllRevisions(context, deletedPathVisitor, propertyVisitor);
            if (changesetDiffSummary.hasCopiedPaths()) {
                this.processCopiedPaths(context, changesetDiffSummary, propertyChanges);
            }
            this.processDeletedPaths(context, deletedPaths, changesetDiffSummary);
            DiffListener listener = new DiffListener(context.getDiffTextCache(), this.repositoryInfo.getPathMatcher());
            this.processDiffPaths(cache, context, client, changesetDiffSummary, propertyChanges, listener);
            if (changesetDiffSummary.hasDiffPaths()) {
                this.processChanges(context, changesetDiffSummary, listener.getChangeInfos(), propertyChanges);
            }
        }
        finally {
            context.getClientPool().returnClient(client);
        }
    }

    @VisibleForTesting
    Svn2ChangesetDiffSummary createDiffSummary(Svn2MessageContext context, SvnThrottledClient client) throws RepositoryClientException {
        InfoData infoData = this.getInfoData(context, client);
        SvnChangePath rootChange = context.getMostSpecificChange(Path.ROOT);
        Svn2ChangesetDiffSummary changesetDiffSummary = rootChange != null && SvnAction.isAddAction(rootChange.getAction()) ? this.summarizeRootDiff(context, infoData.infoMap) : this.summarizeDiff(context, client, infoData.infoMap);
        if (infoData.hasExcludedPaths) {
            changesetDiffSummary.setHasExcludedPaths(true);
        }
        return changesetDiffSummary;
    }

    private Svn2ChangesetDiffSummary summarizeDiff(final Svn2MessageContext context, SvnThrottledClient client, final Map<Path, SvnPathInfo> infoMap) throws RepositoryClientException {
        final SvnLogicalPathMatcher pathMatcher = this.repositoryInfo.getPathMatcher();
        Revision.Number startRev = new Revision.Number(context.getRevision() - 1L);
        Revision.Number endRev = new Revision.Number(context.getRevision());
        String repositoryRoot = context.getRepositoryRoot();
        final FishEyeSysProps.SvnPropertiesOnAdd propertiesOnAdd = FishEyeSysProps.SVN_PROPERTIES_ON_ADD;
        final Svn2ChangesetDiffSummary changesetDiffSummary = new Svn2ChangesetDiffSummary(context);
        client.diffSummarize(repositoryRoot, (Revision)endRev, (Revision)startRev, (Revision)endRev, Depth.infinity, null, false, new DiffSummaryCallback(){

            public void onSummary(DiffSummary diffSummary) {
                Path controllingPath;
                context.getStatus().throwOnStopRequested();
                Path diffPath = new Path(diffSummary.getPath());
                SvnChangePath controllingChange = context.getMostSpecificChange(diffPath);
                if (controllingChange == null) {
                    Logs.APP_LOG.debug((Object)("Unable to find controlling change for : " + diffPath));
                    return;
                }
                if (!Svn2Infill2Processor.this.repositoryInfo.isPathInRepo(diffPath)) {
                    changesetDiffSummary.setHasExcludedPaths(true);
                    return;
                }
                if (pathMatcher.isTag(diffPath) && controllingChange.getCopySrcPath() != null) {
                    controllingPath = Svn2Infill2Processor.this.repositoryInfo.getLocalPath(controllingChange.getPath(), context.getRevision());
                    Path controllingSrc = Svn2Infill2Processor.this.repositoryInfo.getLocalPath(controllingChange.getCopySrcPath(), controllingChange.getCopySrcRevision());
                    Path logicalDestPath = pathMatcher.getLogicalPath(controllingPath);
                    Path logicalSrcPath = pathMatcher.getLogicalPath(controllingSrc);
                    if (logicalDestPath != null && logicalDestPath.equals(logicalSrcPath) && !controllingPath.equals(diffPath)) {
                        return;
                    }
                }
                if (diffSummary.propsChanged()) {
                    changesetDiffSummary.addPropertyChanged(diffPath, diffSummary.getDiffKind());
                } else if (diffSummary.getDiffKind().equals((Object)DiffSummary.DiffKind.added) && propertiesOnAdd != FishEyeSysProps.SvnPropertiesOnAdd.None) {
                    boolean isInCopySource;
                    controllingPath = Svn2Infill2Processor.this.repositoryInfo.getLocalPath(controllingChange.getPath(), context.getRevision());
                    boolean isAddRootPath = controllingPath.equals(diffPath);
                    boolean skipPropListOnAddRootPath = propertiesOnAdd == FishEyeSysProps.SvnPropertiesOnAdd.ReuseCopySource && controllingChange.getCopySrcPath() != null && diffSummary.getNodeKind() == NodeKind.dir;
                    boolean bl = isInCopySource = controllingChange.getCopySrcPath() != null && Svn2Infill2Processor.this.repositoryInfo.isPathInRepo(controllingChange.getCopySrcPath(), controllingChange.getCopySrcRevision());
                    if (isAddRootPath && !skipPropListOnAddRootPath || !isInCopySource) {
                        changesetDiffSummary.addPropertyChanged(diffPath, diffSummary.getDiffKind());
                    } else if (skipPropListOnAddRootPath) {
                        Logs.APP_LOG.debug((Object)("Skipping 'svn proplist' for " + diffPath + " as it was part of the copy from " + controllingChange.getCopySrcPath()));
                    }
                }
                SvnPathInfo info = (SvnPathInfo)infoMap.get(diffPath);
                changesetDiffSummary.addDiffPath(diffPath, controllingChange, diffSummary.getDiffKind(), diffSummary.getNodeKind(), info);
            }
        });
        return changesetDiffSummary;
    }

    private Svn2ChangesetDiffSummary summarizeRootDiff(Svn2MessageContext context, Map<Path, SvnPathInfo> infoMap) throws RepositoryClientException {
        SvnLogicalPathMatcher pathMatcher = this.repositoryInfo.getPathMatcher();
        Svn2ChangesetDiffSummary changesetDiffSummary = new Svn2ChangesetDiffSummary(context);
        for (Map.Entry<Path, SvnPathInfo> entry : infoMap.entrySet()) {
            Path path = entry.getKey();
            SvnChangePath changePath = context.getMostSpecificChange(path);
            SvnPathInfo info = entry.getValue();
            if (changePath == null) {
                Logs.APP_LOG.warn((Object)("Unable to find Change for : " + path + " - probable configuration error in svn root/path"));
                continue;
            }
            changesetDiffSummary.addDiffPath(path, changePath, Svn2Utils.getDiffKindFromAction(changePath.getAction()), info.getKind(), info);
            if (pathMatcher.isTag(path)) continue;
            changesetDiffSummary.addPropertyChanged(path, DiffSummary.DiffKind.added);
        }
        return changesetDiffSummary;
    }

    private InfoData getInfoData(final Svn2MessageContext context, SvnThrottledClient client) throws RepositoryClientException {
        final InfoData infoData = new InfoData();
        for (SvnChangePath changePath : context.getChangePaths()) {
            ChangePath.Action action = changePath.getAction();
            boolean isCopy = changePath.getCopySrcPath() != null;
            Path localPath = this.repositoryInfo.getLocalPath(changePath.getPath(), context.getRevision());
            String pathURL = this.repositoryInfo.getPathURL(localPath, context.getRevision());
            Revision.Number rev = new Revision.Number(context.getRevision());
            if (SvnAction.isAddAction(action) && !isCopy) {
                if (context.isPartOfAdd(changePath)) continue;
                client.info(pathURL, (Revision)rev, (Revision)rev, Depth.infinity, new InfoCallback(){

                    public void singleInfo(Info info) {
                        Path path = Svn2Infill2Processor.this.repositoryInfo.pathFromInfo(info, context.getRevision());
                        if (Svn2Infill2Processor.this.repositoryInfo.isPathInRepo(path)) {
                            infoData.infoMap.put(path, SvnPathInfo.fromInfo(info));
                        } else {
                            infoData.hasExcludedPaths = true;
                        }
                    }
                });
                continue;
            }
            if (action != ChangePath.Action.modify) continue;
            client.info(pathURL, (Revision)rev, (Revision)rev, Depth.empty, new InfoCallback(){

                public void singleInfo(Info info) {
                    Path path = Svn2Infill2Processor.this.repositoryInfo.pathFromInfo(info, context.getRevision());
                    infoData.infoMap.put(path, SvnPathInfo.fromInfo(info));
                }
            });
        }
        return infoData;
    }

    private void processCopiedPaths(Svn2MessageContext context, Svn2ChangesetDiffSummary changesetDiffSummary, Svn2PropertyChanges propertyChanges) throws LicensePolicyException, RepositoryClientException {
        Svn2Cache cache = (Svn2Cache)context.getEngine().getInternalRevisionCache();
        for (Path copiedPath : changesetDiffSummary.getCopiedPaths()) {
            context.getStatus().throwOnStopRequested();
            SvnChangePath controllingChange = changesetDiffSummary.getControllingChange(copiedPath);
            this.processCopiedPath(context, cache, controllingChange, copiedPath, changesetDiffSummary.isDir(copiedPath), propertyChanges);
        }
    }

    private void processCopiedPath(Svn2MessageContext context, Svn2Cache cache, SvnChangePath controllingChangePath, Path diffPath, boolean dir, Svn2PropertyChanges propertyChanges) throws LicensePolicyException, RepositoryClientException {
        boolean isTag;
        SvnLogicalPathMatcher pathMatcher = this.repositoryInfo.getPathMatcher();
        long srcRevision = controllingChangePath.getCopySrcRevision();
        Path srcRootPath = this.repositoryInfo.getLocalPath(controllingChangePath.getCopySrcPath(), srcRevision);
        Path destRootPath = this.repositoryInfo.getLocalPath(controllingChangePath.getPath(), context.getRevision());
        Path relativePath = diffPath.getRelativePath(destRootPath);
        Path srcPath = new Path(srcRootPath, relativePath);
        SvnRevInfoDAO fileRevisionDAO = cache.getFileRevisionDAO();
        boolean isCopy = false;
        boolean isMove = false;
        boolean srcInRepo = this.repositoryInfo.isPathInRepo(srcPath);
        if (srcInRepo) {
            if (context.isPathMoved(controllingChangePath.getCopySrcPath())) {
                isMove = true;
            } else {
                isCopy = true;
            }
        }
        boolean bl = isTag = pathMatcher.isTag(diffPath) && !pathMatcher.isTagRoot(diffPath);
        if (isTag) {
            int srcPathRevId = fileRevisionDAO.getPureRevId(srcPath, srcRevision);
            if (srcPathRevId != -1) {
                isTag = false;
            } else {
                Path srcLogicalPath;
                Path destLogicalPath = pathMatcher.getLogicalPath(diffPath);
                if (!destLogicalPath.equals(srcLogicalPath = pathMatcher.getLogicalPath(srcPath))) {
                    isTag = false;
                }
            }
        }
        if (!isTag) {
            int copiedRevId = fileRevisionDAO.getPureRevId(diffPath, context.getRevision());
            SvnRevInfo revision = context.createFileRevision(diffPath);
            revision.setAdded(true);
            revision.setCopy(isCopy);
            revision.setMove(isMove);
            revision.setCopySourcePath(srcPath);
            revision.setCopySourceRevision(srcRevision);
            revision.setFileType(dir ? 2 : 1);
            Map<String, String> pathProperties = propertyChanges.getPathProperties().get(diffPath);
            if (pathProperties != null) {
                revision.setStringProperties(pathProperties, context.getFileNameMap());
            }
            if (srcInRepo) {
                this.updateRevisionFromCopySource(revision, fileRevisionDAO, srcPath, srcRevision, pathProperties == null, context.getFileNameMap());
            }
            if (copiedRevId == -1) {
                context.insertFileRevision(revision);
            } else {
                context.updateRevision(copiedRevId, revision);
            }
        }
    }

    private void updateRevisionFromCopySource(SvnRevInfo revision, SvnRevInfoDAO fileRevisionDAO, Path srcPath, long srcRevision, boolean updateProperties, CustomFileNameMap customFileNameMap) {
        long srcCsid = fileRevisionDAO.getLatestPathChangeUpto(srcPath, srcRevision, false);
        SvnRevInfoDAO.SvnRevisionSummary svnRevisionSummary = null;
        if (srcCsid != -1L) {
            svnRevisionSummary = fileRevisionDAO.loadSummary(fileRevisionDAO.getRevId(srcPath, srcCsid));
        }
        if (svnRevisionSummary != null) {
            revision.setLineCount(svnRevisionSummary.getLineCount());
            revision.setLinesAdded(svnRevisionSummary.getLineCount());
            revision.setBinary(svnRevisionSummary.isBinary());
            revision.setOversize(svnRevisionSummary.isOversize());
            if (updateProperties) {
                revision.setStringProperties(svnRevisionSummary.getProperties(), customFileNameMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeletedPaths(final Svn2MessageContext context, List<Path> deletedPaths, Svn2ChangesetDiffSummary diffSummary) throws LicensePolicyException {
        Timer timer = new Timer("Processing deleted paths for " + context.getRevision());
        final Svn2Cache cache = (Svn2Cache)context.getEngine().getInternalRevisionCache();
        final SvnRevInfoDAO fileRevisionDAO = cache.getFileRevisionDAO();
        final HashSet deletedInSummary = new HashSet();
        Iterables.addAll(deletedInSummary, diffSummary.getDeletedPaths());
        try {
            for (Path deletedPath : deletedPaths) {
                context.getStatus().throwOnStopRequested();
                fileRevisionDAO.visitDirectoryTree(deletedPath, context.getRevision() - 1L, new CommonRevInfoDAO.DirectoryTreeVisitor(){

                    @Override
                    public void visit(long pathId, long changesetid) throws DbException {
                        Path deletedPath = fileRevisionDAO.getPath(pathId);
                        try {
                            deletedInSummary.remove(deletedPath);
                            Svn2Infill2Processor.this.processDeletedPath(context, cache, deletedPath, changesetid);
                        }
                        catch (LicensePolicyException e2) {
                            throw new RuntimeWrappedException(e2);
                        }
                    }
                });
            }
            for (Path path : deletedInSummary) {
                context.getStatus().throwOnStopRequested();
                long csid = fileRevisionDAO.getLatestPathChangeUpto(path, context.getRevision() - 1L, true);
                this.processDeletedPath(context, cache, path, csid);
            }
        }
        catch (RuntimeWrappedException e2) {
            e2.rethrowCause(LicensePolicyException.class);
            e2.rethrowAsRuntime();
        }
        finally {
            timer.end();
        }
    }

    private void processDeletedPath(Svn2MessageContext context, Svn2Cache cache, Path deletedPath, long parentCsid) throws LicensePolicyException {
        SvnLogicalPathMatcher pathMatcher = this.repositoryInfo.getPathMatcher();
        SvnRevInfoDAO fileRevisionDAO = cache.getFileRevisionDAO();
        if (pathMatcher.isTag(deletedPath)) {
            Path logicalPath = pathMatcher.getLogicalPath(deletedPath);
            String tag = pathMatcher.getTag(deletedPath);
            fileRevisionDAO.addTagRemoval(deletedPath, logicalPath, tag, context.getRevision());
        }
        if (pathMatcher.isTagRoot(deletedPath) || !pathMatcher.isTag(deletedPath)) {
            SvnRevInfoDAO.SvnRevisionSummary parentRevision = null;
            int parentRevId = fileRevisionDAO.getRevId(deletedPath, parentCsid);
            if (parentRevId == -1) {
                Logs.APP_LOG.info((Object)("Unable to find " + deletedPath + "@" + parentCsid + " for deletion at " + context.getRevision()));
            } else {
                parentRevision = fileRevisionDAO.loadSummary(parentRevId);
            }
            int deletedRevId = fileRevisionDAO.getPureRevId(deletedPath, context.getRevision());
            if (deletedRevId == -1) {
                SvnRevInfo revision = context.createFileRevision(deletedPath);
                revision.setDead(true);
                if (parentRevision != null) {
                    revision.setOversize(parentRevision.isOversize());
                    revision.setBinary(parentRevision.isBinary());
                    revision.setFileType(parentRevision.getFileType());
                }
                context.insertFileRevision(revision);
            } else {
                fileRevisionDAO.updateDead(deletedRevId, true);
                if (parentRevision != null) {
                    fileRevisionDAO.updateOversize(deletedRevId, parentRevision.isOversize());
                    fileRevisionDAO.updateBinary(deletedRevId, parentRevision.isBinary());
                    fileRevisionDAO.updateFileType(deletedRevId, parentRevision.getFileType());
                }
            }
        }
    }

    private Svn2PropertyChanges getPropertyChanges(Svn2MessageContext context, SvnThrottledClient client, Map<Path, DiffSummary.DiffKind> propertyChangePaths) throws RepositoryClientException {
        Revision.Number rev = new Revision.Number(context.getRevision());
        HashMap<Path, Map<String, String>> pathProperties = new HashMap<Path, Map<String, String>>();
        HashMap<Path, Set<String>> removedProperties = new HashMap<Path, Set<String>>();
        HashSet<Path> addedRoots = new HashSet<Path>();
        for (Map.Entry<Path, DiffSummary.DiffKind> entry : propertyChangePaths.entrySet()) {
            Map<String, String> oldProperties;
            context.getStatus().throwOnStopRequested();
            Path path = entry.getKey();
            if (pathProperties.containsKey(path) || this.containsSubPath(addedRoots, path)) continue;
            DiffSummary.DiffKind diffKind = entry.getValue();
            String pathURL = this.repositoryInfo.getPathURL(path, context.getRevision());
            if (diffKind.equals((Object)DiffSummary.DiffKind.added)) {
                Path baseAddPath = this.getAddedEntryProperties(context, client, propertyChangePaths, path, pathProperties);
                addedRoots.add(baseAddPath);
                continue;
            }
            Map<String, String> currentProperties = this.getPathPropertiesFromSvn(context, client, this.repositoryInfo.getDefaultCharset(), (Revision)rev, path, pathURL);
            if (!currentProperties.isEmpty()) {
                pathProperties.put(path, currentProperties);
            }
            if (diffKind.equals((Object)DiffSummary.DiffKind.added) || (oldProperties = this.getPathProperties(context, path)) == null) continue;
            oldProperties.keySet().removeAll(currentProperties.keySet());
            if (oldProperties.isEmpty()) continue;
            removedProperties.put(path, oldProperties.keySet());
        }
        return new Svn2PropertyChanges(pathProperties, removedProperties);
    }

    private boolean containsSubPath(Set<Path> roots, Path path) {
        for (Path root : roots) {
            if (!root.equals(path) && !root.isAncestor(path)) continue;
            return true;
        }
        return false;
    }

    private Path getAddedEntryProperties(Svn2MessageContext context, SvnThrottledClient client, Map<Path, DiffSummary.DiffKind> propertyChangePaths, Path path, final Map<Path, Map<String, String>> pathProperties) throws RepositoryClientException {
        DiffSummary.DiffKind parentDiffKind;
        Path parent;
        Path base = path;
        while (!base.isRoot() && propertyChangePaths.containsKey(parent = base.getParent()) && (parentDiffKind = propertyChangePaths.get(parent)) != null && parentDiffKind.equals((Object)DiffSummary.DiffKind.added)) {
            base = parent;
        }
        final Path basePath = base;
        final String baseURL = this.repositoryInfo.getPathURL(basePath, context.getRevision());
        Revision.Number rev = new Revision.Number(context.getRevision());
        final Charset propCharset = this.repositoryInfo.getDefaultCharset();
        client.properties(baseURL, (Revision)rev, (Revision)rev, Depth.infinity, null, new ProplistCallback(){

            public void singlePath(String path, Map<String, byte[]> properties) {
                String normalizedPath = Svn2Infill2Processor.this.svnRepositoryPathUtil.normalizeURL(path);
                if (!normalizedPath.startsWith(baseURL)) {
                    Logs.APP_LOG.warn((Object)String.format("Problem getting added entry property: normalized SVN path (%s) does not start with baseURL (%s)", normalizedPath, baseURL));
                    return;
                }
                String relativePath = normalizedPath.substring(baseURL.length());
                Path propPath = new Path(basePath, relativePath);
                HashMap<String, String> props = new HashMap<String, String>();
                for (Map.Entry<String, byte[]> entry : properties.entrySet()) {
                    props.put(entry.getKey().intern(), new String(entry.getValue(), propCharset).intern());
                }
                pathProperties.put(propPath, props);
            }
        });
        return basePath;
    }

    private Map<String, String> getPathPropertiesFromSvn(final Svn2MessageContext context, SvnThrottledClient client, final Charset propCharset, Revision rev, final Path path, final String pathURL) throws RepositoryClientException {
        final HashMap<String, String> props = new HashMap<String, String>();
        client.properties(pathURL, rev, rev, Depth.empty, null, new ProplistCallback(){

            public void singlePath(String propsPathURL, Map properties) {
                boolean pathsEqual = pathURL.equals(propsPathURL);
                if (!pathsEqual) {
                    Path repoBase;
                    Path pathFromRoot;
                    Path propsPath;
                    String repositoryRoot = Svn2Infill2Processor.this.repositoryInfo.getRepositoryRoot(context.getRevision());
                    if (!propsPathURL.endsWith("/") && repositoryRoot.endsWith("/")) {
                        repositoryRoot = repositoryRoot.substring(0, repositoryRoot.length() - 1);
                    }
                    if ((propsPath = (pathFromRoot = new Path(propsPathURL.substring(repositoryRoot.length()))).getRelativePath(repoBase = new Path(Svn2Infill2Processor.this.repositoryInfo.getRepositoryBase(context.getRevision())))).isAbove()) {
                        return;
                    }
                    propsPath = new Path(SvnURLDecoder.decode(propsPath.getPath()));
                    pathsEqual = propsPath.equals(path);
                }
                if (pathsEqual) {
                    for (Object key : properties.keySet()) {
                        Object value = properties.get(key);
                        if (value instanceof String) {
                            props.put((String)key, (String)value);
                            continue;
                        }
                        if (!(value instanceof byte[])) continue;
                        byte[] bytes = (byte[])value;
                        props.put((String)key, new String(bytes, propCharset));
                    }
                } else {
                    Logs.APP_LOG.error((Object)("Unexpected path received " + propsPathURL + " when getting properties for " + pathURL));
                }
            }
        });
        return props;
    }

    private Map<String, String> getPathProperties(Svn2MessageContext context, Path path) throws RepositoryClientException {
        SvnRevInfoDAO fileRevisionDAO = ((Svn2Cache)this.engine.getInternalRevisionCache()).getFileRevisionDAO();
        SvnRevInfoDAO.SvnRevisionSummary previousRev = this.getPreviousRevision(context, fileRevisionDAO, path);
        if (previousRev != null) {
            return previousRev.getProperties();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDiffPaths(Svn2Cache cache, Svn2MessageContext context, SvnThrottledClient client, Svn2ChangesetDiffSummary changesetDiffSummary, Svn2PropertyChanges propertyChanges, DiffListener listener) throws RepositoryClientException, IOException, DbException {
        Timer timer = new Timer("Processing diff paths for " + context.getRevision());
        SvnRepositoryInfo repositoryInfo = context.getRepositoryInfo();
        File diffFile = null;
        try {
            boolean combinedDiff;
            diffFile = File.createTempFile("FESVNW_", "", repositoryInfo.getRepoTempDir());
            Revision.Number startRev = new Revision.Number(context.getRevision() - 1L);
            Revision.Number rev = new Revision.Number(context.getRevision());
            SvnChangeSetDAO changesetDAO = ((Svn2Cache)context.getEngine().getInternalRevisionCache()).getChangeSetDAO();
            long previousCsid = changesetDAO.getPreviousCsid(context.getRevision());
            Set<Path> nonDefaultCharsetPaths = this.getNonDefaultCharsets(cache, context, changesetDiffSummary, propertyChanges);
            boolean bl = combinedDiff = nonDefaultCharsetPaths.isEmpty() && changesetDiffSummary.canDoCombinedDiff() && previousCsid != -1L;
            if (combinedDiff) {
                timer.mark("Processing combined diff");
                Path commonRoot = this.getCommonRoot(repositoryInfo, context.getRevision(), changesetDiffSummary.getDiffControllingChanges());
                while (context.getMostSpecificChange(commonRoot) != null && !commonRoot.isRoot()) {
                    commonRoot = commonRoot.getParent();
                }
                IOHelper.deleteFile(diffFile);
                String string = repositoryInfo.getPathURL(commonRoot, context.getRevision());
                client.diff(string, (Revision)rev, (Revision)startRev, (Revision)rev, null, diffFile.getAbsolutePath(), Depth.infinity, null, true, false, false, false);
                try {
                    this.processDiff(context, diffFile, commonRoot, false, repositoryInfo.getDefaultCharset(), listener);
                    Map<Path, ChangeInfo> changeInfos = listener.getChangeInfos();
                    for (Path path : changesetDiffSummary.getDiffPaths()) {
                        context.getStatus().throwOnStopRequested();
                        if (changeInfos.containsKey(path)) continue;
                        ChangeInfo changeInfo = new ChangeInfo();
                        changeInfo.setDiffGenerated(true);
                        changeInfos.put(path, changeInfo);
                    }
                    timer.mark("Combined diff done");
                }
                catch (SvnDiffParsingException e2) {
                    Logs.APP_LOG.debug((Object)"The was a problem parsing the combined diff output - switching to file-by-file", (Throwable)e2);
                    combinedDiff = false;
                    listener.reset();
                }
            }
            if (!combinedDiff) {
                timer.mark("Processing file by file diff");
                for (Path path : changesetDiffSummary.getDiffPaths()) {
                    context.getStatus().throwOnStopRequested();
                    if (changesetDiffSummary.isDir(path)) continue;
                    DiffSummary.DiffKind diffKind = changesetDiffSummary.getDiffKind(path);
                    SvnPathInfo info = changesetDiffSummary.getInfo(path);
                    if (info == null) {
                        info = this.getSingleInfo(context, client, path);
                        changesetDiffSummary.setInfo(path, info);
                    }
                    if (changesetDiffSummary.isDiffOversize(path)) {
                        if (!changesetDiffSummary.isOversize(path)) {
                            this.addNewFileChangeInfo(context, client, path, listener, info);
                            continue;
                        }
                        ChangeInfo changeInfo = new ChangeInfo();
                        changeInfo.setOversize(changesetDiffSummary.isOversize(path));
                        listener.getChangeInfos().put(path, changeInfo);
                        continue;
                    }
                    if (diffKind.equals((Object)DiffSummary.DiffKind.added)) {
                        if (!changesetDiffSummary.isControllingPath(path)) continue;
                        this.addNewFileChangeInfo(context, client, path, listener, info);
                        continue;
                    }
                    if (nonDefaultCharsetPaths.contains(path)) {
                        this.createUTF16LEDiff(cache, context, diffFile, path);
                        try {
                            this.processDiff(context, diffFile, Path.ROOT, true, Utf16ERandomAccessIoStream.UTF_16LE, listener);
                        }
                        catch (SvnDiffParsingException e3) {
                            Logs.APP_LOG.error((Object)("Unable to parse encoded diff for " + path), (Throwable)e3);
                        }
                        continue;
                    }
                    IOHelper.deleteFile(diffFile);
                    String diffURL = repositoryInfo.getPathURL(path, context.getRevision());
                    Revision diffStartRev = changesetDiffSummary.isFullDiffRequired(path) ? START_REV_0 : startRev;
                    client.diff(diffURL, (Revision)rev, diffStartRev, (Revision)rev, null, diffFile.getAbsolutePath(), Depth.empty, null, true, false, false, false);
                    try {
                        this.processDiff(context, diffFile, path, true, repositoryInfo.getDefaultCharset(), listener);
                    }
                    catch (SvnDiffParsingException e4) {
                        Logs.APP_LOG.error((Object)("Unable to parse diff for " + path), (Throwable)e4);
                    }
                }
                timer.mark("File by File diff done - processing adds");
            }
            for (Map.Entry entry : propertyChanges.getRemovedProperties().entrySet()) {
                context.getStatus().throwOnStopRequested();
                if (!((Set)entry.getValue()).contains("svn:mime-type")) continue;
                Path path = (Path)entry.getKey();
                this.addNewFileChangeInfo(context, client, path, listener, changesetDiffSummary.getInfo(path));
            }
        }
        catch (Throwable throwable) {
            IOHelper.deleteFile(diffFile);
            timer.end();
            throw throwable;
        }
        IOHelper.deleteFile(diffFile);
        timer.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createUTF16LEDiff(Svn2Cache cache, Svn2MessageContext context, File diffFile, Path diffPath) throws IOException, RepositoryClientException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(diffFile), Utf16ERandomAccessIoStream.UTF_16LE);
        try {
            long previousRevision = context.getRevision() - 1L;
            long previousChangeRevision = cache.getFileRevisionDAO().getLatestPathChangeUpto(diffPath, previousRevision, false);
            PatchPrinter printer = new PatchPrinter(cache, writer);
            printer.sendFileDiff(diffPath, Long.toString(previousChangeRevision), Long.toString(context.getRevision()));
        }
        catch (Throwable throwable) {
            IOHelper.close(writer);
            throw throwable;
        }
        IOHelper.close(writer);
    }

    private Set<Path> getNonDefaultCharsets(Svn2Cache cache, Svn2MessageContext context, Svn2ChangesetDiffSummary changesetDiffSummary, Svn2PropertyChanges propertyChanges) {
        HashSet<Path> nonDefaultCharsetPaths = new HashSet<Path>();
        Charset defaultCharset = this.repositoryInfo.getDefaultCharset();
        for (Path path : changesetDiffSummary.getDiffPaths()) {
            Charset oldCharset;
            Map<String, String> properties = propertyChanges.getPathProperties().get(path);
            boolean nonDefaultCharset = false;
            if (properties != null) {
                String mimeTypeValue = properties.get("svn:mime-type");
                Charset charset = SvnMimeUtils.getMimeTypeCharset(mimeTypeValue);
                boolean bl = nonDefaultCharset = charset != null && !charset.equals(defaultCharset);
            }
            if (nonDefaultCharset) {
                nonDefaultCharsetPaths.add(path);
                continue;
            }
            long previousRevision = cache.getFileRevisionDAO().getLatestPathChangeUpto(path, context.getRevision() - 1L, false);
            if (previousRevision == -1L || (oldCharset = cache.getTextEncoding(new RevInfoKey(path, Long.toString(previousRevision)))).equals(defaultCharset)) continue;
            nonDefaultCharsetPaths.add(path);
        }
        return nonDefaultCharsetPaths;
    }

    private SvnPathInfo getSingleInfo(Svn2MessageContext context, SvnThrottledClient client, Path path) throws RepositoryClientException {
        Revision.Number rev = new Revision.Number(context.getRevision());
        String pathURL = this.repositoryInfo.getPathURL(path, context.getRevision());
        final AtomicReference infoRef = new AtomicReference();
        client.info(pathURL, (Revision)rev, (Revision)rev, Depth.empty, new InfoCallback(){

            public void singleInfo(Info info) {
                infoRef.set(info);
            }
        });
        return SvnPathInfo.fromInfo((Info)infoRef.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDiff(Svn2MessageContext context, File diffFile, Path diffRootPath, boolean directPath, Charset encoding, DiffListener listener) throws DbException, IOException, SvnDiffParsingException {
        SvnRepositoryInfo repositoryInfo = context.getRepositoryInfo();
        SvnDiffParser diffParser = new SvnDiffParser(repositoryInfo.getLocale(), context.getStatus());
        FileInputStream fis = null;
        ReaderLineReader reader = null;
        try {
            fis = new FileInputStream(diffFile);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, encoding);
            reader = new ReaderLineReader(LineReader.Mode.MODE_MIXED, new BufferedReader(isr));
            if (directPath) {
                diffParser.setContextPath(diffRootPath.getParent());
            } else {
                diffParser.setContextPath(diffRootPath);
            }
            diffParser.setContext(diffFile, context.getRevision());
            diffParser.process(reader, listener);
        }
        catch (Throwable throwable) {
            IOHelper.close(fis);
            IOHelper.close(new Closeable[]{reader});
            throw throwable;
        }
        IOHelper.close(fis);
        IOHelper.close(new Closeable[]{reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void addNewFileChangeInfo(Svn2MessageContext context, SvnThrottledClient client, Path path, DiffListener listener, SvnPathInfo info) throws RepositoryClientException, IOException {
        block9: {
            diffTextCache = context.getDiffTextCache();
            repositoryInfo = context.getRepositoryInfo();
            exportDir = new File(repositoryInfo.getRepoTempDir(), "export");
            exportDir.mkdirs();
            url = repositoryInfo.getPathURL(path, context.getRevision());
            contentFile = null;
            fis = null;
            lcis = null;
            try {
                contentFile = diffTextCache.isEnabled() != false ? diffTextCache.getNewTempFile() : File.createTempFile("FESVNN_", "", exportDir);
                rev = new Revision.Number(context.getRevision());
                changeInfo = new ChangeInfo();
                changeInfo.setTmpDiffAddedFile(contentFile);
                changeInfo.setFileDiff(true);
                changeInfo.setDiffGenerated(false);
                mimeType = new AtomicReference<Object>(null);
                hasSvnSpecialProperty = new AtomicBoolean(false);
                client.properties(url, (Revision)rev, (Revision)rev, Depth.empty, null, new ProplistCallback(){

                    public void singlePath(String path, Map<String, byte[]> properties) {
                        if (properties.containsKey("svn:mime-type")) {
                            mimeType.set(SvnPropertyUtil.getStringValue(properties.get("svn:mime-type")));
                        } else if (properties.containsKey("svn:special")) {
                            hasSvnSpecialProperty.set(true);
                        }
                    }
                });
                fileNameMap = context.getFileNameMap();
                binary = SvnMimeUtils.isBinaryMimeType(fileNameMap, mimeType.get()) != false || fileNameMap.isBinaryType(path.getName(), true) != false;
                changeInfo.setBinary(binary);
                if (binary) ** GOTO lbl50
                if (info != null && info.getKind() == NodeKind.file) break block9;
                Logs.APP_LOG.error((Object)("Not exporting content for " + url + " in rev " + context.getRevision() + " as it is a directory."));
            }
            catch (Throwable var19_19) {
                IOHelper.close(new Closeable[]{fis});
                IOHelper.close(new Closeable[]{lcis});
                if (!diffTextCache.isEnabled()) {
                    IOHelper.deleteFile(contentFile);
                }
                throw var19_19;
            }
            IOHelper.close(new Closeable[]{fis});
            IOHelper.close(new Closeable[]{lcis});
            if (!diffTextCache.isEnabled()) {
                IOHelper.deleteFile(contentFile);
            }
            return;
        }
        if (info.getReposSize() > repositoryInfo.getMaxIndexableSize()) {
            changeInfo.setOversize(true);
        } else {
            client.doExport(url, contentFile.getAbsolutePath(), (Revision)rev, (Revision)rev, true, true, Depth.empty, "LF");
            if (contentFile.exists() && !hasSvnSpecialProperty.get()) {
                fis = new FileInputStream(contentFile);
                lcis = new LineCountingInputStream(new BufferedInputStream(fis));
                lcis.readFully();
                changeInfo.incAdded(lcis.getLineCount());
                changeInfo.setFileDiff(true);
                changeInfo.addHunk(Hunk.createUnifiedAddHunk(1, 1, lcis.getLineCount()));
            }
        }
lbl50:
        // 5 sources

        listener.getChangeInfos().put(path, changeInfo);
        IOHelper.close(new Closeable[]{fis});
        IOHelper.close(new Closeable[]{lcis});
        if (!diffTextCache.isEnabled()) {
            IOHelper.deleteFile(contentFile);
        }
    }

    private Path getCommonRoot(SvnRepositoryInfo repositoryInfo, long revision, Iterable<SvnChangePath> changes) {
        Path commonRoot = null;
        for (SvnChangePath change : changes) {
            Path path = repositoryInfo.getLocalPath(change.getPath(), revision);
            if (commonRoot == null) {
                commonRoot = path;
                continue;
            }
            commonRoot = path.getCommonRoot(commonRoot);
        }
        return commonRoot;
    }

    private Set<Path> getUnmarkedDirectories(Svn2MessageContext context, Svn2ChangesetDiffSummary changesetDiffSummary) {
        ImmutableSet.Builder unmarkedDirectories = ImmutableSet.builder();
        Svn2Cache cache = (Svn2Cache)context.getEngine().getInternalRevisionCache();
        String thisRevision = Long.toString(context.getRevision());
        for (Path dir : changesetDiffSummary.getDirPaths()) {
            FileRevision revision = cache.getFileRevision(new RevInfoKey(dir, thisRevision));
            if (revision == null || revision.isDir()) continue;
            unmarkedDirectories.add((Object)dir);
        }
        return unmarkedDirectories.build();
    }

    private void visitAllRevisions(Svn2MessageContext context, final Visitor<SvnRevInfoDAO.SvnRevisionSummary> deletedPathVisitor, final Visitor<SvnRevInfoDAO.SvnRevisionSummary> propertyVisitor) throws LicensePolicyException, RepositoryClientException {
        Svn2Cache cache = (Svn2Cache)context.getEngine().getInternalRevisionCache();
        final SvnRevInfoDAO fileRevisionDAO = cache.getFileRevisionDAO();
        cache.getCommonRevInfoDAO().searchChangeSetRevids(Long.toString(context.getRevision()), new Predicate<Integer>(){

            public boolean apply(Integer revid) {
                SvnRevInfoDAO.SvnRevisionSummary revisionSummary = fileRevisionDAO.loadSummary(revid);
                if (revisionSummary.isDead()) {
                    deletedPathVisitor.visit(revisionSummary);
                }
                if (revisionSummary.getProperties() == null || revisionSummary.getProperties().isEmpty()) {
                    propertyVisitor.visit(revisionSummary);
                }
                return false;
            }
        });
    }

    private SvnRevInfoDAO.SvnRevisionSummary getPreviousRevision(Svn2MessageContext context, SvnRevInfoDAO fileRevisionDAO, Path path) {
        long previousCsid = fileRevisionDAO.getLatestPathChangeUpto(path, context.getRevision() - 1L, false);
        if (previousCsid == -1L) {
            return null;
        }
        return fileRevisionDAO.loadSummary(fileRevisionDAO.getRevId(path, previousCsid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChanges(Svn2MessageContext context, Svn2ChangesetDiffSummary changesetDiffSummary, Map<Path, ChangeInfo> changeInfos, Svn2PropertyChanges propertyChanges) throws LicensePolicyException {
        Svn2Cache cache = (Svn2Cache)context.getEngine().getInternalRevisionCache();
        SvnRevInfoDAO fileRevisionDAO = cache.getFileRevisionDAO();
        RepositoryStatus status = context.getStatus();
        Timer timer = new Timer("Processing diffs for " + context.getRevision());
        try {
            int count = 0;
            for (Path path : changesetDiffSummary.getDiffPaths()) {
                context.getStatus().throwOnStopRequested();
                if (count++ % 128 == 0) {
                    status.setMessage("Processing change " + path);
                }
                ChangeInfo changeInfo = changeInfos.get(path);
                DiffSummary.DiffKind diffKind = changesetDiffSummary.getDiffKind(path);
                int revId = fileRevisionDAO.getPureRevId(path, context.getRevision());
                if (revId == -1) {
                    Map<String, String> properties;
                    SvnRevInfo revision = context.createFileRevision(path);
                    if (changesetDiffSummary.isDir(path)) {
                        revision.setFileType(2);
                    }
                    if ((properties = propertyChanges.getPathProperties().get(path)) != null) {
                        revision.setStringProperties(properties, context.getFileNameMap());
                    }
                    if (diffKind.equals((Object)DiffSummary.DiffKind.added)) {
                        revision.setAdded(true);
                    } else if (diffKind.equals((Object)DiffSummary.DiffKind.deleted)) {
                        revision.setDead(true);
                    } else {
                        Logs.APP_LOG.error((Object)("Unexpected Diff Kind : " + path + "@" + context.getRevision()));
                    }
                    revId = context.insertFileRevision(revision);
                }
                if (changeInfo != null) {
                    LineCountState newState;
                    int total;
                    fileRevisionDAO.setHunks(revId, changeInfo.getHunks());
                    if (changesetDiffSummary.isFullDiffRequired(path) || diffKind.equals((Object)DiffSummary.DiffKind.added)) {
                        total = changeInfo.getNumAdded();
                        newState = LineCountState.FULL;
                    } else {
                        total = 0;
                        newState = LineCountState.DIFF;
                    }
                    fileRevisionDAO.updateOversize(revId, changeInfo.isOversize());
                    fileRevisionDAO.updateLineCount(revId, total, changeInfo.getNumAdded(), changeInfo.getNumRemoved(), newState);
                    fileRevisionDAO.updateDiffValid(revId, changeInfo.isDiffGenerated());
                    fileRevisionDAO.updateDiffFiles(revId, changeInfo.getTmpDiffAddedFile(), changeInfo.getTmpDiffRemovedFile());
                    continue;
                }
                Logs.APP_LOG.debug((Object)("No change info for " + path + "@" + context.getRevision()));
            }
            status.setMessage("");
        }
        finally {
            timer.end();
        }
    }

    private static class InfoData {
        final Map<Path, SvnPathInfo> infoMap = new HashMap<Path, SvnPathInfo>();
        boolean hasExcludedPaths;

        private InfoData() {
        }
    }
}

