/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.IndexableFileRevision;
import com.cenqua.fisheye.rep.SortedMapFileHistory;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.SortedMap;

public class Svn2FileHistory
extends SortedMapFileHistory {
    private final SvnLogicalPathMatcher matcher;

    public Svn2FileHistory(SvnLogicalPathMatcher matcher, Path physicalPath, TreeMultimap<Long, FileRevision> history) {
        super(physicalPath, history);
        this.matcher = matcher;
    }

    @Override
    public String resolveRevisionFromString(Path path, String s2) throws DbException {
        try {
            Long rev = Long.valueOf(s2);
            if (this.getRevisionMap().containsKey((Object)rev)) {
                return s2;
            }
            String containerId = this.matcher.getContainerId(path);
            SortedMap headMap = this.getRevisionMap().asMap().headMap(rev);
            ArrayList<Long> keys = new ArrayList<Long>(headMap.keySet());
            for (int i2 = keys.size() - 1; i2 >= 0; --i2) {
                Long key = (Long)keys.get(i2);
                for (FileRevision revision : (Collection)headMap.get(key)) {
                    if (!this.matcher.getContainerId(revision.getPath()).equals(containerId)) continue;
                    return key.toString();
                }
            }
        }
        catch (NumberFormatException rev) {
            // empty catch block
        }
        IndexableFileRevision br = null;
        for (FileRevision info : this.getRevisions()) {
            if (info.getTags().contains(s2)) {
                return info.getRevision();
            }
            if (!info.getBranch().equals(s2)) continue;
            if (br == null) {
                br = info;
                continue;
            }
            if (info.getDate() <= br.getDate()) continue;
            br = info;
        }
        if (br != null) {
            return br.getRevision();
        }
        if ("HEAD".equals(s2)) {
            return this.getHead();
        }
        return null;
    }

    @Override
    public String getMainBranch() {
        LinkedHashSet<String> trunks = new LinkedHashSet<String>();
        for (FileRevision revision : this.getRevisions()) {
            if (!revision.isTrunkLike()) continue;
            if (revision.getBranch().equals("trunk")) {
                return "trunk";
            }
            trunks.add(revision.getBranch());
        }
        if (trunks.isEmpty()) {
            return "trunk";
        }
        if (trunks.size() == 1) {
            return (String)trunks.iterator().next();
        }
        if (trunks.contains("trunk")) {
            return "trunk";
        }
        ArrayList orderedTrunks = new ArrayList(trunks);
        return (String)orderedTrunks.get(orderedTrunks.size() - 1);
    }
}

