/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2ChangesetProcessor;
import com.atlassian.fisheye.svn.Svn2ContentContext;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.atlassian.fisheye.svn.Svn2Utils;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.DbTask;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryIndexer;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.svn.db.SvnChangeSetDAO;
import com.cenqua.fisheye.svn.db.SvnRevInfoDAO;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.util.bitset.BitSets;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idb.ac;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.Revision;

public class Svn2ContentProcessor
extends Svn2ChangesetProcessor {
    private static final int MAX_DELETE_SIZE = 1000;
    private static final int BATCH_SIZE = 200;

    @Override
    protected ChangeSetIndexingState getResultingState() {
        return ChangeSetIndexingState.CONTENT_INDEXED;
    }

    @Override
    protected long getVersion() {
        return 29L;
    }

    @Override
    protected int getDbLockPriority() {
        return 40;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processChangesets(Svn2RepositoryEngine engine, final LongSortedSet csids) throws RepositoryClientException {
        Timer timer = new Timer("Indexing content for " + csids.firstLong() + " to " + csids.lastLong());
        SvnThrottledClient client = null;
        try {
            Svn2ContentContext context = new Svn2ContentContext(engine);
            client = engine.getClientPool().allocateClient();
            final Svn2Cache cache = context.getCache();
            final SvnChangeSetDAO changesetDAO = cache.getChangeSetDAO();
            final long latestCsidIndexed = cache.getLatestIndexedCsid();
            if (latestCsidIndexed == -1L) {
                boolean bl = false;
                return bl;
            }
            final AtomicBoolean contentIndexingDone = new AtomicBoolean(false);
            LongBidirectionalIterator longBidirectionalIterator = csids.iterator();
            while (longBidirectionalIterator.hasNext()) {
                DiffTextCache diffTextCache;
                long csid = (Long)longBidirectionalIterator.next();
                if (latestCsidIndexed == csid) {
                    engine.getStatus().setMessage("Indexing content for changeset " + csid);
                    this.contentIndexChangeset(context, csid);
                    contentIndexingDone.set(true);
                }
                if (!(diffTextCache = Svn2Utils.getDiffTextCache(engine, csid, false)).isEmpty()) {
                    this.indexDiffText(engine, diffTextCache, csid);
                }
                diffTextCache.delete();
            }
            cache.withDbWriteLock(this.getDbLockPriority(), new DbTask<Void>(){

                @Override
                public Void perform(ac itemSpace) {
                    LongBidirectionalIterator longBidirectionalIterator = csids.iterator();
                    while (longBidirectionalIterator.hasNext()) {
                        long csid = (Long)longBidirectionalIterator.next();
                        Svn2ContentProcessor.this.updateIndexingState(changesetDAO, csid);
                        if (!contentIndexingDone.get()) continue;
                        cache.setScanProperty(CommonProperties.CONTENT_LAST_INDEXED.value, latestCsidIndexed);
                    }
                    return null;
                }
            });
            boolean bl = true;
            return bl;
        }
        finally {
            engine.getStatus().setMessage("");
            engine.getClientPool().returnClient(client);
            timer.end();
        }
    }

    private void indexDiffText(final Svn2RepositoryEngine engine, final DiffTextCache diffTextCache, long csid) {
        Svn2Cache cache = (Svn2Cache)engine.getInternalRevisionCache();
        final SvnRevInfoDAO fileRevisionDAO = cache.getFileRevisionDAO();
        final RepositoryIndexer repositoryIndexer = new RepositoryIndexer(engine.getIndexer(), cache.getLuceneConnection(), engine.getCfg());
        fileRevisionDAO.visitChangeSetRevisions(Long.toString(csid), new StoppableVisitor<FileRevision>(){

            @Override
            public boolean visit(FileRevision revInfo) {
                engine.getStatus().throwOnStopRequested();
                repositoryIndexer.indexDiffText(revInfo, revInfo.getRevID(), diffTextCache, fileRevisionDAO.getCommonRevInfoDAO());
                IOHelper.deleteFile(revInfo.getTmpDiffRemovedFile());
                IOHelper.deleteFile(revInfo.getTmpDiffAddedFile());
                return true;
            }
        });
        Svn2Utils.clearDiffText(engine, csid);
    }

    private void contentIndexChangeset(Svn2ContentContext context, long csid) {
        long lastContentIndexed = context.getCache().getScanProperty(CommonProperties.CONTENT_LAST_INDEXED.value, 0L);
        try {
            this.indexContentChanges(context, lastContentIndexed, csid);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexContentChanges(Svn2ContentContext context, long startRevision, long endRevision) throws DbException, IOException {
        Timer timer = new Timer("Indexing content " + startRevision + ":" + endRevision);
        if (context.getRepositoryInfo().isContentIndexingEnabled()) {
            context.getStatus().setMessage("Indexing diff content from changeset " + startRevision + " to " + endRevision);
            SortedIntSet physicalPaths = this.getPhysicalPaths(context, startRevision, endRevision);
            long lastPathId = context.getCache().getScanProperty(CommonProperties.CONTENT_LASTPATHID.value, -1L);
            if (lastPathId != -1L) {
                BitSets.clear(physicalPaths, 0L, lastPathId);
            }
            this.filterPhysicalContentPaths(context, physicalPaths);
            boolean indexedOk = false;
            try {
                this.deleteContent(context, physicalPaths);
                this.indexUpdatedContent(context, physicalPaths);
                context.getStatus().throwOnStopRequested();
                indexedOk = true;
            }
            finally {
                if (!indexedOk) {
                    this.deleteContent(context, physicalPaths);
                }
            }
        }
        timer.end();
    }

    private SortedIntSet getPhysicalPaths(Svn2ContentContext context, long startRevision, long endRevision) throws DbException {
        SvnRevInfoDAO fileRevisionDAO = context.getCache().getFileRevisionDAO();
        SortedIntSet revids = fileRevisionDAO.getRevidsInChangeSetRange(startRevision, endRevision);
        return fileRevisionDAO.getPhysicalPaths(revids);
    }

    protected void filterPhysicalContentPaths(Svn2ContentContext context, SortedIntSet physicalPaths) {
        SvnLogicalPathMatcher pathMatcher = context.getRepositoryInfo().getPathMatcher();
        int physicalPathId = physicalPaths.nextSetBit(0);
        while (physicalPathId >= 0) {
            context.getStatus().throwOnStopRequested();
            Path physicalPath = context.getCache().getFileRevisionDAO().getPhysicalPath(physicalPathId);
            if (context.getRepositoryInfo().isPathInRepo(physicalPath)) {
                boolean indexible;
                String containerId = pathMatcher.getContainerId(physicalPath);
                boolean indexRoot = !FishEyeSysProps.SVN_INDEX_TRUNK_CONTENT_ONLY;
                boolean isRootPath = containerId.startsWith("root:");
                boolean isTrunkPath = containerId.startsWith("trunk:");
                boolean bl = indexible = isTrunkPath || isRootPath && indexRoot;
                if (!indexible) {
                    physicalPaths.clear(physicalPathId);
                }
            }
            physicalPathId = physicalPaths.nextSetBit(physicalPathId + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexUpdatedContent(Svn2ContentContext context, SortedIntSet physicalPaths) throws DbException, IOException {
        File contentFile = File.createTempFile("content", null, context.getRepositoryInfo().getRepoTempDir());
        SvnRevInfoDAO fileRevisionDAO = context.getCache().getFileRevisionDAO();
        try {
            int pathIndex = 0;
            int count = physicalPaths.cardinality();
            int physicalPathId = physicalPaths.nextSetBit(0);
            while (physicalPathId >= 0) {
                context.getStatus().throwOnStopRequested();
                ++pathIndex;
                Path physicalPath = fileRevisionDAO.getPhysicalPath(physicalPathId);
                long csid = fileRevisionDAO.getLatestPathChange(physicalPath);
                int revid = fileRevisionDAO.getRevId(physicalPath, csid);
                SvnRevInfoDAO.SvnRevisionSummary revision = fileRevisionDAO.loadSummary(revid);
                boolean doExport = true;
                if (revision == null || revision.isBinaryOrOversize() || revision.isDead()) {
                    doExport = false;
                } else if (revision.getFileType() != 1) {
                    doExport = false;
                } else if (revision.getProperties().containsKey("svn:special")) {
                    doExport = false;
                }
                if (doExport) {
                    context.getStatus().setMessage("Indexing content: " + physicalPath + " (" + pathIndex + " of " + count + ")");
                    this.indexFileContent(context, contentFile, physicalPath, revision);
                }
                if (pathIndex % 200 == 0) {
                    BitSets.clear(physicalPaths, 0L, physicalPathId);
                }
                physicalPathId = physicalPaths.nextSetBit(physicalPathId + 1);
            }
        }
        finally {
            contentFile.delete();
        }
        BitSets.clear(physicalPaths, 0L, physicalPaths.length() + 1);
    }

    private void deleteContent(Svn2ContentContext context, SortedIntSet paths) throws DbException {
        RepositoryIndexer repositoryIndexer = context.getRepositoryIndexer();
        if (repositoryIndexer.hasContentDocuments()) {
            SegmentedIntSet subset = new SegmentedIntSet();
            int pathId = paths.nextSetBit(0);
            while (pathId >= 0) {
                context.getStatus().throwOnStopRequested();
                subset.set(pathId);
                if (subset.cardinality() > 1000) {
                    this.deleteContentSubSet(context, subset);
                    subset = new SegmentedIntSet();
                }
                pathId = paths.nextSetBit(pathId + 1);
            }
            this.deleteContentSubSet(context, subset);
        }
    }

    private void deleteContentSubSet(Svn2ContentContext context, SortedIntSet physicalPaths) throws DbException {
        Collection<Path> outdatedRevids = this.getPaths(context, physicalPaths);
        context.getRepositoryIndexer().deleteContent(outdatedRevids);
    }

    protected Collection<Path> getPaths(Svn2ContentContext context, SortedIntSet physicalPaths) throws DbException {
        ArrayList<Path> paths = new ArrayList<Path>();
        int physicalPathId = physicalPaths.nextSetBit(0);
        while (physicalPathId >= 0) {
            paths.add(context.getCache().getFileRevisionDAO().getPath(physicalPathId));
            physicalPathId = physicalPaths.nextSetBit(physicalPathId + 1);
        }
        return paths;
    }

    private void indexFileContent(Svn2ContentContext context, File contentFile, Path physicalPath, SvnRevInfoDAO.SvnRevisionSummary revision) throws IOException, DbException {
        contentFile.delete();
        boolean exported = false;
        try {
            exported = this.exportContent(context, physicalPath, contentFile, revision.getSvnRevision());
        }
        catch (RepositoryClientException e2) {
            Logs.APP_LOG.warn((Object)"Error exporting content for indexing", (Throwable)e2);
        }
        if (!exported) {
            Logs.APP_LOG.warn((Object)("Skipping " + physicalPath + " as content is not available"));
        } else if (!contentFile.exists()) {
            Logs.APP_LOG.error((Object)("Not indexing contents of HEAD of " + physicalPath + " because content was not exported"));
        } else {
            Charset encoding = context.getCache().getTextEncoding(revision.getRevInfoKey());
            context.getRepositoryIndexer().indexContent(revision, contentFile, encoding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportContent(Svn2ContentContext context, Path physicalPath, File contentFile, long revision) throws IOException, DbException, RepositoryClientException {
        SvnThrottledClient client = context.getEngine().getClientPool().allocateClient();
        try {
            Revision.Number rev = new Revision.Number(revision);
            String url = context.getRepositoryInfo().getPathURL(physicalPath, revision);
            client.doExport(url, contentFile.getAbsolutePath(), (Revision)rev, (Revision)rev, true, true, Depth.empty, "LF");
        }
        finally {
            context.getEngine().getClientPool().returnClient(client);
        }
        return true;
    }
}

