/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.util.IndexingStats;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.svn.SvnThrottledClientFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class Svn2ClientPool
extends GenericObjectPool {
    private Map<SvnThrottledClient, Object> activeClients = null;
    private boolean trackClients = false;
    private Object NULL_OBJECT = new Object();
    private IndexingStats indexingStats = new IndexingStats();

    public Svn2ClientPool(SvnThrottledClientFactory factory) {
        super((PoolableObjectFactory)factory);
        this.setMaxActive(80);
        this.setMaxIdle(3);
        this.setWhenExhaustedAction((byte)1);
        this.setMaxWait(20000L);
        this.activeClients = new ConcurrentHashMap<SvnThrottledClient, Object>(80);
    }

    public SvnThrottledClient allocateClient() throws DbException {
        try {
            SvnThrottledClient client = (SvnThrottledClient)this.borrowObject();
            if (this.activeClients != null) {
                this.activeClients.put(client, this.trackClients ? new Exception() : this.NULL_OBJECT);
            }
            client.setFailOnTimeout(true);
            client.resetStats();
            return client;
        }
        catch (Exception e2) {
            if (this.activeClients != null && this.trackClients) {
                for (Object exception : this.activeClients.values()) {
                    Logs.APP_LOG.warn((Object)"In use client", (Throwable)((Exception)exception));
                }
            }
            throw new DbException("Unable to allocate an SVN client", e2);
        }
    }

    public void returnClient(SvnThrottledClient client) {
        if (client != null) {
            try {
                if (this.activeClients != null) {
                    this.activeClients.remove(client);
                }
                this.getIndexingStats().addStats(client.getStats());
                this.returnObject(client);
            }
            catch (Exception e2) {
                Logs.APP_LOG.error((Object)"Exception returning SVN client instance", (Throwable)e2);
            }
        }
    }

    public void stop() {
        for (SvnThrottledClient client : this.activeClients.keySet()) {
            client.cancel();
        }
    }

    public IndexingStats getIndexingStats() {
        return this.indexingStats;
    }
}

